/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Display;
import wlirc2.Database;
import wlirc2.Encoding;
import wlirc2.Irc;
import wlirc2.Listener;
import wlirc2.Utils;

public class BluetoothIrc
implements Irc {
    public static final UUID UID = new UUID("102030405060708090A0B0C0D0E0F010", false);
    private DataOutputStream out;
    private DataInputStream in;
    private StreamConnection c;
    private boolean isconnected = false;
    public Vector vectorSend;
    public Vector vectorReceive;
    private Display display;
    private Database db;
    private byte[] restbyte;
    private Listener listener;

    public BluetoothIrc(Database database, Display display, Listener listener) {
        this.db = database;
        this.vectorSend = new Vector();
        this.vectorReceive = new Vector();
        this.display = display;
        this.restbyte = null;
        this.listener = listener;
    }

    public boolean isConnected() {
        return this.isconnected;
    }

    public void setConnected(boolean bl) {
        this.isconnected = bl;
    }

    public void sendReceive(boolean bl) throws IOException {
        int n = this.in.available();
        if (n > 0) {
            int n2 = this.restbyte == null ? 0 : this.restbyte.length;
            byte[] byArray = new byte[n2 + n];
            if (this.restbyte != null) {
                System.arraycopy(this.restbyte, 0, byArray, 0, this.restbyte.length);
            }
            this.in.readFully(byArray, n2, n);
            int n3 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 13 && byArray[i] != 10) continue;
                String string = Encoding.toString(byArray, n3, i - n3, this.db.encoding);
                if (string != null && !(string = string.trim()).equals("")) {
                    System.out.println("IN> " + string);
                    this.vectorReceive.addElement(string);
                }
                n3 = i;
            }
            if (n3 != byArray.length) {
                this.restbyte = new byte[byArray.length - n3];
                System.arraycopy(byArray, n3, this.restbyte, 0, this.restbyte.length);
            }
        }
        if (!this.vectorSend.isEmpty()) {
            String string = (String)Utils.popFifo(this.vectorSend);
            string = string + "\r\n";
            this.out.write(Encoding.getBytes(string, this.db.encoding));
            this.out.flush();
            System.out.println("OUT> " + string);
        }
        if (n < 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void findBlueToothServer(DiscoveryAgent discoveryAgent) throws BluetoothStateException {
        this.listener.console.writeInfo("Searching for bluetooth server");
        this.db.bluetoothstring = discoveryAgent.selectService(UID, 0, false);
        if (this.db.bluetoothstring != null) {
            this.listener.console.writeInfo("BluetoothServer found");
            this.db.save(2);
        }
    }

    public void connect(String string, int n) throws IOException, ConnectionNotFoundException {
        LocalDevice localDevice = LocalDevice.getLocalDevice();
        localDevice.setDiscoverable(10390323);
        DiscoveryAgent discoveryAgent = localDevice.getDiscoveryAgent();
        this.listener.console.writeInfo("Search for BluetoothServer");
        boolean bl = true;
        if (this.db.bluetoothstring == null || this.db.bluetoothstring.equals("")) {
            this.findBlueToothServer(discoveryAgent);
            bl = false;
        }
        try {
            this.c = (StreamConnection)Connector.open((String)this.db.bluetoothstring, (int)3);
        }
        catch (Exception exception) {
            if (bl) {
                this.listener.console.writeInfo("Could not find cached bluetooth server");
                this.findBlueToothServer(discoveryAgent);
                this.c = (StreamConnection)Connector.open((String)this.db.bluetoothstring, (int)3);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ConnectionNotFoundException) {
                throw (ConnectionNotFoundException)exception;
            }
            throw new IOException(exception.toString());
        }
        this.out = this.c.openDataOutputStream();
        String string2 = string + ":" + n + "\n";
        this.out.write(string2.getBytes());
        this.out.flush();
        this.in = this.c.openDataInputStream();
        this.isconnected = true;
    }

    public void disconnect() throws IOException {
        this.writeLine("Quit :used WLIrc 2.0 Beta 5");
        this.sendReceive(false);
        try {
            this.out.close();
            this.in.close();
            this.c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String readLine() throws IOException {
        if (!this.vectorReceive.isEmpty()) {
            return (String)Utils.popFifo(this.vectorReceive);
        }
        return null;
    }

    public synchronized void writeLine(String string) throws IOException {
        if (string != null) {
            this.vectorSend.addElement(string);
        }
    }

    public Listener getListener() {
        return this.listener;
    }
}

