/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.GUIControl;
import wlirc2.Utils;
import wlirc2.WLIrc2;

public class FileBrowser
implements Runnable,
CommandListener {
    private List list;
    private Display display;
    private Command openCommand = new Command("Open", 4, 1);
    private Command saveCommand = new Command("Save", 4, 2);
    private Command showCommand = new Command("Show", 4, 2);
    private Command closeCommand = new Command("Close", 2, 2);
    private Command cancelCommand = new Command("Cancel", 3, 4);
    private Command backgroundCommand = new Command("Background", 2, 2);
    private String curdir = "/";
    private Enumeration files = null;
    private String filename = null;
    private String playfile = null;
    private Displayable olddisplay;
    private boolean write;
    public boolean onlybrowse = false;
    private Player player;
    public static final String FILE_SEPARATOR = "/";

    public FileBrowser(Display display, Displayable displayable) {
        this.display = display;
        this.olddisplay = displayable;
    }

    public String browseFile(boolean bl) {
        this.write = bl;
        this.list = bl ? new List("Save file", 3) : new List("Load file", 3);
        Thread thread = new Thread(this);
        thread.start();
        while (this.filename == null) {
            Object object;
            Object object2;
            if (this.files != null) {
                this.list.deleteAll();
                if (this.curdir != FILE_SEPARATOR) {
                    this.list.append("..", null);
                }
                while (this.files.hasMoreElements()) {
                    object2 = this.files.nextElement();
                    object = object2.toString();
                    if (bl && (!bl || !((String)object).endsWith(FILE_SEPARATOR))) continue;
                    this.list.append((String)object, null);
                }
                this.files = null;
                this.list.addCommand(this.openCommand);
                this.list.setSelectCommand(this.openCommand);
                this.list.addCommand(this.showCommand);
                this.list.addCommand(this.cancelCommand);
                if (bl) {
                    this.list.addCommand(this.saveCommand);
                }
                this.list.setCommandListener((CommandListener)this);
                if (this.playfile == null) {
                    this.display.setCurrent((Displayable)this.list);
                }
            }
            if (this.playfile != null) {
                try {
                    object2 = (FileConnection)Connector.open((String)("file://" + this.curdir + this.playfile), (int)1);
                    object = object2.openDataInputStream();
                    String string = Utils.getContentType(this.playfile);
                    this.player = Manager.createPlayer((InputStream)object, (String)string);
                    this.player.realize();
                    Form form = new Form(this.playfile);
                    form.addCommand(this.closeCommand);
                    GUIControl gUIControl = (GUIControl)this.player.getControl("GUIControl");
                    if (gUIControl != null) {
                        form.append((Item)gUIControl.initDisplayMode(0, null));
                    } else {
                        form.addCommand(this.backgroundCommand);
                    }
                    form.setCommandListener((CommandListener)this);
                    this.player.start();
                    this.display.setCurrent((Displayable)form);
                }
                catch (MediaException mediaException) {
                    this.display.setCurrent(new Alert("Cannot show file!"), (Displayable)this.list);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.playfile = null;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.display.setCurrent(this.olddisplay);
        if (this.filename != null && this.filename.equals("")) {
            return null;
        }
        return this.filename;
    }

    public void run() {
        try {
            this.getDirContent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WLIrc2.writeError(exception, this.display, this.olddisplay);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        Form form;
        String string;
        System.err.println("COMMAND:" + command);
        if (command == this.closeCommand) {
            this.display.setCurrent((Displayable)this.list);
            try {
                this.player.stop();
                this.player.deallocate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (command == this.backgroundCommand) {
            this.display.setCurrent((Displayable)this.list);
            return;
        }
        if (command == this.cancelCommand) {
            this.filename = "";
            return;
        }
        if (command == this.saveCommand) {
            this.filename = this.curdir;
            return;
        }
        if (command == this.openCommand) {
            string = this.list.getString(this.list.getSelectedIndex());
            if (string.equals("..")) {
                form = Utils.splitString(this.curdir, FILE_SEPARATOR);
                String string2 = "";
                for (int i = 0; i < ((String[])form).length - 2; ++i) {
                    string2 = string2 + (String)form[i] + FILE_SEPARATOR;
                }
                this.curdir = string2;
            } else if (string.endsWith(FILE_SEPARATOR)) {
                this.curdir = this.curdir + string;
            } else if (!this.onlybrowse) {
                this.filename = this.curdir + string;
            } else {
                command = this.showCommand;
            }
            try {
                this.getDirContent();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                WLIrc2.writeError(exception, this.display, this.olddisplay);
            }
        }
        if (command == this.showCommand) {
            string = this.list.getString(this.list.getSelectedIndex());
            if ((string = string.toLowerCase()).endsWith(FILE_SEPARATOR) || string.equals("..")) {
                return;
            }
            form = new Form(string);
            form.append((Item)new Gauge("Loading", false, -1, 3));
            this.display.setCurrent((Displayable)form);
            this.playfile = string;
        }
    }

    public byte[] getFile(String string) throws IOException {
        FileConnection fileConnection = (FileConnection)Connector.open((String)("file://" + string), (int)1);
        DataInputStream dataInputStream = fileConnection.openDataInputStream();
        byte[] byArray = new byte[(int)fileConnection.fileSize()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        fileConnection.close();
        return byArray;
    }

    public void writeFile(InputStream inputStream, int n, String string) throws IOException {
        while (string.indexOf(FILE_SEPARATOR) != -1) {
            string = string.substring(string.indexOf(FILE_SEPARATOR) + 1);
        }
        String string2 = this.browseFile(true);
        System.err.println("FILENAME: " + string2 + string);
        FileConnection fileConnection = (FileConnection)Connector.open((String)("file://" + string2 + string), (int)2);
        fileConnection.create();
        DataOutputStream dataOutputStream = fileConnection.openDataOutputStream();
        int n2 = 1024;
        int n3 = 0;
        while (n2 == 1024) {
            if (n2 + n3 > n) {
                n2 = n - n3;
            }
            n3 += n2;
            byte[] byArray = new byte[n2];
            inputStream.read(byArray);
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
        }
        dataOutputStream.close();
    }

    public void getDirContent() throws IOException {
        Enumeration enumeration = null;
        FileConnection fileConnection = null;
        System.err.println("DIR: " + this.curdir);
        boolean bl = false;
        if (this.curdir.equals(FILE_SEPARATOR)) {
            enumeration = FileSystemRegistry.listRoots();
            bl = true;
        } else {
            fileConnection = (FileConnection)Connector.open((String)("file://" + this.curdir), (int)1);
            if (fileConnection != null) {
                enumeration = fileConnection.list();
            }
            fileConnection.close();
        }
        this.files = enumeration;
    }
}

