/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import wlirc2.DCC;
import wlirc2.Database;
import wlirc2.Irc;
import wlirc2.Private;
import wlirc2.Profile;
import wlirc2.ScreenOutput;
import wlirc2.Utils;
import wlirc2.WLIrc2;

public class Channel
extends ScreenOutput {
    private List controlList;
    private List ctcpList;
    private static final String OP = "Op";
    private static final String DEOP = "Deop";
    private static final String VOICE = "Voice";
    private static final String DEVOICE = "Devoice";
    private static final String KICK = "Kick";
    private static final String BACK = "[Back]";
    private static final String PING = "Ping";
    private static final String TIME = "Time";
    private static final String VERSION = "Version";
    protected boolean readinglist = false;
    protected String topic = "";

    public Channel(Display display, Database database, Profile profile, Irc irc, String string) {
        super(display, database, profile, irc, string);
        this.list = new Vector();
        this.showlist = database.gui_show_names;
        this.witem.addCommand(this.namesCommand);
        this.witem.setDefaultCommand(this.namesCommand);
        this.witem.addCommand(this.topicCommand);
        this.witem.addCommand(this.closeCommand);
    }

    public void addCommandsWitem() {
        this.witem.addCommand(this.closeCommand);
        this.witem.addCommand(this.topicCommand);
        super.addCommandsWitem();
    }

    public void addWitemNamesCommand() {
        this.witem.removeCommand(this.closeCommand);
        this.witem.removeCommand(this.topicCommand);
        super.addWitemNamesCommand();
    }

    public void switchNameList() {
        this.witem.list_use = this.showlist = !this.showlist;
        this.witem.setListWidth();
        this.witem.refreshGuiParameters();
        this.witem.position = this.witem.v.size() - this.witem.getMaxlinesScreen();
        if (this.witem.position < 0) {
            this.witem.position = 0;
        }
        if (!this.showlist) {
            this.addCommandsWitem();
        } else {
            this.addWitemNamesCommand();
        }
        this.witem.update();
    }

    public void commandAction(Command command, Item item) {
        try {
            super.commandAction(command, item);
            if (command == this.namesCommand) {
                this.switchNameList();
            } else if (command == this.closeCommand) {
                this.irc.writeLine("part " + this.getName());
                this.close();
            } else if (command == this.topicCommand) {
                Alert alert = new Alert("Topic", this.topic, null, AlertType.INFO);
                alert.setTimeout(-2);
                this.display.setCurrent((Displayable)alert);
            } else if (this.controlList != null && command == List.SELECT_COMMAND) {
                String string = this.controlList.getString(this.controlList.getSelectedIndex());
                String string2 = Utils.trimName(this.controlList.getTitle());
                if (OP.equals(string)) {
                    this.irc.writeLine("mode " + this.getName() + " +o " + Utils.trimName(string2));
                } else if (DEOP.equals(string)) {
                    this.irc.writeLine("mode " + this.getName() + " -o " + Utils.trimName(string2));
                } else if (VOICE.equals(string)) {
                    this.irc.writeLine("mode " + this.getName() + " +v " + Utils.trimName(string2));
                } else if (DEVOICE.equals(string)) {
                    this.irc.writeLine("mode " + this.getName() + " -v " + Utils.trimName(string2));
                } else if (KICK.equals(string)) {
                    this.irc.writeLine("kick " + this.getName() + " " + Utils.trimName(string2));
                    this.show();
                    this.controlList = null;
                }
            } else if (command == this.whoisCommand) {
                String string = (String)this.list.elementAt(this.witem.list_selected);
                this.irc.writeLine("whois " + Utils.trimName(string));
                this.show();
            } else if (command == this.queryCommand && this.witem.list_use) {
                String string = (String)this.list.elementAt(this.witem.list_selected);
                Private private_ = this.irc.getListener().getPrivate(string, this.display, this.db, this.irc);
                private_.show();
            } else if (command == this.controlCommand) {
                this.controlList = new List((String)this.list.elementAt(this.witem.list_selected), 3);
                this.controlList.append(OP, null);
                this.controlList.append(DEOP, null);
                this.controlList.append(VOICE, null);
                this.controlList.append(DEVOICE, null);
                this.controlList.append(KICK, null);
                this.controlList.append(BACK, null);
                this.controlList.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.controlList);
            } else if (command == this.ctcpCommand) {
                this.ctcpList = new List((String)this.list.elementAt(this.witem.list_selected), 3);
                this.ctcpList.append(VERSION, null);
                this.ctcpList.append(PING, null);
                this.ctcpList.append(TIME, null);
                this.ctcpList.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.ctcpList);
            } else if (command == this.dccCommand) {
                new Thread(new DCC(this.irc, Utils.trimName((String)this.list.elementAt(this.witem.list_selected)), this.display, this.display.getCurrent(), this.db)).start();
            } else if (this.ctcpList != null && command == List.SELECT_COMMAND) {
                String string = this.ctcpList.getString(this.ctcpList.getSelectedIndex());
                String string3 = (String)this.list.elementAt(this.witem.list_selected);
                if (PING.equals(string)) {
                    int n = new Random().nextInt();
                    WLIrc2.ctcplist.put("" + n, new Long(System.currentTimeMillis()));
                    this.irc.writeLine("PRIVMSG " + Utils.trimName(string3) + " :" + '\u0001' + "PING " + n);
                } else if (VERSION.equals(string)) {
                    this.irc.writeLine("PRIVMSG " + Utils.trimName(string3) + " :" + '\u0001' + "VERSION");
                } else if (TIME.equals(string)) {
                    this.irc.writeLine("PRIVMSG " + Utils.trimName(string3) + " :" + '\u0001' + "TIME");
                }
                this.ctcpList = null;
                this.show();
            }
        }
        catch (IOException iOException) {
            WLIrc2.writeError(iOException, this.display, (Displayable)WLIrc2.mainForm);
        }
    }

    public void write(String string, String string2, boolean bl) {
        if (bl) {
            super.write("* " + string + " " + string2, bl);
        } else {
            super.write(string + "> " + string2, bl);
        }
    }

    public void addName(String string) {
        int n = this.list.size();
        String string2 = string.toUpperCase();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)this.list.elementAt(i);
            if (string2.compareTo(string3.toUpperCase()) >= 1) continue;
            this.list.insertElementAt(string, i);
            return;
        }
        this.list.addElement(string);
    }

    public void updateName(String string, String string2) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)this.list.elementAt(i);
            if (!Utils.trimName(string3).equals(string)) continue;
            this.list.removeElementAt(i);
            this.addName(string2);
            break;
        }
    }

    public void updateHeader() {
        this.witem.header = this.getName() + "[" + this.list.size() + "]: " + this.topic;
    }

    public boolean hasName(String string) {
        int n = this.list.size();
        string = Utils.trimName(string);
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.list.elementAt(i);
            if (!Utils.trimName(string2).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void deleteName(String string) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.list.elementAt(i);
            if (!Utils.trimName(string2).equals(string)) continue;
            this.list.removeElementAt(i);
            break;
        }
    }

    public void close() {
        this.irc.getListener().channels.remove(this.getName().toUpperCase());
        super.close();
    }
}

