/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Display;
import wlirc2.Database;
import wlirc2.Encoding;
import wlirc2.GatewayException;
import wlirc2.Irc;
import wlirc2.Listener;
import wlirc2.Utils;

public class PollHttpIrc
implements Irc {
    private String mSession = null;
    public Vector vectorReceive;
    public Vector vectorSend;
    private Database db;
    private Display display;
    private int erroroccured = 0;
    private String gateway = null;
    private Listener listener;
    private boolean isconnected = false;

    public PollHttpIrc(Database database, Display display, Listener listener) {
        this.db = database;
        this.display = display;
        this.vectorReceive = new Vector();
        this.vectorSend = new Vector();
        this.listener = listener;
    }

    public synchronized void connect(String string, int n) throws IOException, GatewayException {
        String[] stringArray = Utils.splitString(this.db.gateway, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (i > 0) {
                    this.listener.console.writeInfo("Trying to connect with gateway " + stringArray[i]);
                }
                this.internalConnect(stringArray[i], string, n);
                this.gateway = stringArray[i];
                break;
            }
            catch (Exception exception) {
                if (i >= stringArray.length - 1) {
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new IOException(exception + "(" + exception.toString() + ")");
                }
                this.listener.console.writeInfo("Could not connect to gateway " + stringArray[i] + " (" + exception.toString() + ")");
                continue;
            }
        }
    }

    private synchronized void internalConnect(String string, String string2, int n) throws IOException, GatewayException {
        FilterInputStream filterInputStream = null;
        HttpConnection httpConnection = null;
        try {
            this.isconnected = true;
            String string3 = string2 + ":" + n;
            String string4 = this.db.fastconnect ? "FC&l=" + Utils.URLencode(Listener.authstring(this.listener.profile)) + "&s=" + Utils.URLencode(this.listener.profile.startupScript) + "&j=" + Utils.URLencode(this.listener.profile.channels) + "&f=" + Utils.URLencode(this.listener.profile.friends) : "CONNECT";
            httpConnection = (HttpConnection)Connector.open((String)(string + "?version=" + Utils.URLencode("2.0 Beta 5") + "&command=" + string4 + "&data=" + Utils.URLencode(string3) + "&uid=" + this.db.userkey), (int)3);
            this.setConnection(httpConnection);
            String string5 = httpConnection.getHeaderField("Set-cookie");
            if (httpConnection.getResponseCode() != 200) {
                throw new GatewayException("Could not connect to gateway (HTTP errorcode " + httpConnection.getResponseCode() + ")");
            }
            filterInputStream = httpConnection.openDataInputStream();
            StringBuffer stringBuffer = new StringBuffer();
            this.readData((DataInputStream)filterInputStream);
            this.mSession = (String)this.vectorReceive.firstElement();
            this.vectorReceive.removeElementAt(0);
        }
        catch (IOException iOException) {
            throw new IOException("Could not connect: " + iOException.toString());
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
            filterInputStream = null;
            httpConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        HttpConnection httpConnection = null;
        FilterInputStream filterInputStream = null;
        try {
            httpConnection = (HttpConnection)Connector.open((String)(this.gateway + "?command=DISCONNECT&sessionid=" + Utils.URLencode(this.mSession)), (int)1);
            this.setConnection(httpConnection);
            if (this.mSession != null) {
                httpConnection.setRequestProperty("Cookie", "JSESSIONID=" + this.mSession.trim());
            }
            filterInputStream = httpConnection.openDataInputStream();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
            filterInputStream = null;
            httpConnection = null;
        }
    }

    public boolean isConnected() {
        return this.isconnected;
    }

    public void setConnected(boolean bl) {
        this.isconnected = bl;
    }

    public String readLine() throws IOException {
        if (!this.vectorReceive.isEmpty()) {
            return (String)Utils.popFifo(this.vectorReceive);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendReceive(boolean bl) throws IOException, GatewayException {
        HttpConnection httpConnection = null;
        String string = "";
        FilterInputStream filterInputStream = null;
        OutputStream outputStream = null;
        int n = this.db.polltime;
        if (this.erroroccured > 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            while (n > 0) {
                --n;
                if (!this.isconnected) {
                    return;
                }
                if (!this.vectorSend.isEmpty() && bl && !((String)this.vectorSend.firstElement()).startsWith("ISON")) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            String string2;
            int n2 = this.vectorSend.size();
            for (int i = 0; i < n2; ++i) {
                string2 = (String)Utils.popFifo(this.vectorSend);
                string = string + string2;
                string = string + "\n";
            }
            String string3 = ";jsessionid=" + this.mSession;
            httpConnection = (HttpConnection)Connector.open((String)this.gateway, (int)3);
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Configuration/CLDC-1.0");
            httpConnection.setRequestProperty("Connection", "close");
            if (this.mSession != null) {
                httpConnection.setRequestProperty("Cookie", "JSESSIONID=" + this.mSession.trim());
            }
            string2 = "SR\r\n";
            string2 = string2 + this.mSession + "\r\n";
            string2 = string2 + string;
            outputStream = httpConnection.openOutputStream();
            outputStream.write(Encoding.getBytes(string2, this.db.encoding));
            filterInputStream = httpConnection.openDataInputStream();
            this.readData((DataInputStream)filterInputStream);
            this.erroroccured = 0;
        }
        catch (IOException iOException) {
            this.vectorSend.addElement(string);
            ++this.erroroccured;
            if (this.erroroccured == 5) {
                throw new IOException("Could not connect to http server!");
            }
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
                if (httpConnection != null) {
                    outputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
                filterInputStream = null;
                httpConnection = null;
                outputStream = null;
            }
            catch (Exception exception) {}
        }
    }

    private void readData(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = dataInputStream.read()) != -1) {
            if (n != 10 && n != 13) {
                byteArrayOutputStream.write(n);
                continue;
            }
            String string = Encoding.toString(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), this.db.encoding);
            if (string == null || (string = string.trim()).equals("")) continue;
            if (string.equals("$ERROR$")) {
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = dataInputStream.read()) != -1) {
                    stringBuffer.append((char)n);
                }
                throw new GatewayException(stringBuffer.toString());
            }
            this.vectorReceive.addElement(string);
            byteArrayOutputStream.reset();
        }
    }

    public void writeLine(String string) throws IOException {
        if (string != null && !string.trim().equals("")) {
            this.vectorSend.addElement(string);
        }
    }

    private void setConnection(HttpConnection httpConnection) throws IOException {
        httpConnection.setRequestMethod("GET");
        httpConnection.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Configuration/CLDC-1.0");
        httpConnection.setRequestProperty("Connection", "close");
    }

    public Listener getListener() {
        return this.listener;
    }
}

