/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import wlirc2.Console;
import wlirc2.Database;
import wlirc2.Irc;
import wlirc2.Listener;
import wlirc2.Message;
import wlirc2.Profile;
import wlirc2.Utils;
import wlirc2.WLIrc2;
import wlirc2.WindowItem;

public class ScreenOutput
implements CommandListener,
ItemStateListener,
ItemCommandListener {
    protected Display display;
    protected Irc irc;
    protected Database db;
    protected Profile profile;
    private static final String CHANGE_NICK = "Change nick";
    private static final String JOIN_CHANNEL = "Join channel";
    private static final String QUERY = "Query";
    protected TextBox textbox;
    protected Command msgCommand;
    protected Command saveCommand;
    protected Command autoCompleteCommand;
    protected Command deleteCommand;
    protected Command sendCommand;
    protected Command cancelCommand;
    protected Command okCommand;
    protected Command colorCommand;
    protected Command boldCommand;
    protected Command underlineCommand;
    protected Command whoisCommand;
    protected Command ctcpCommand;
    protected Command dccCommand;
    protected Command controlCommand;
    protected Command namesCommand;
    protected Command closeCommand;
    protected Command topicCommand;
    protected Command backgroudCommand;
    private Command disconnectCommand;
    private Command windowsCommand;
    private Command mainMenuCommand;
    protected Form form;
    protected WindowItem witem;
    protected TextField wTextField;
    private String name;
    private List dynlist;
    private List favlist;
    private List delfavlist;
    protected Command nickCommand;
    protected Command joinCommand;
    protected Command queryCommand;
    protected String changenick = null;
    protected boolean showlist = false;
    protected Vector list;
    private static final String CTCP = "Ctcp";
    private static final String NAMES = "Names";
    private static final String VIEWTOPIC = "View topic";
    private static final String CLOSE = "Close";

    public ScreenOutput(Display display, Database database, Profile profile, Irc irc, String string) {
        if (database.debug != 0 || !(this instanceof Console)) {
            WLIrc2.allwindows.push(this);
        }
        this.profile = profile;
        this.display = display;
        this.name = string;
        this.db = database;
        this.irc = irc;
        this.autoCompleteCommand = new Command("Favorites", 1, 2);
        this.saveCommand = new Command("Save Fav", 1, 3);
        this.deleteCommand = new Command("Delete Fav", 1, 4);
        this.sendCommand = new Command("Send", 4, 1);
        this.cancelCommand = new Command("Cancel", 3, 2);
        this.okCommand = new Command("Ok", 4, 1);
        this.colorCommand = new Command("Insert color char", 1, 6);
        this.boldCommand = new Command("Insert bold char", 1, 6);
        this.underlineCommand = new Command("Insert Underline char", 1, 6);
        this.msgCommand = new Command("Msg", 4, 10);
        this.windowsCommand = new Command("Windows", 1, 20);
        this.joinCommand = new Command("Join", 1, 30);
        this.queryCommand = new Command(QUERY, 1, 40);
        this.nickCommand = new Command(CHANGE_NICK, 1, 50);
        this.disconnectCommand = new Command("Disconnect", 1, 70);
        this.backgroudCommand = new Command("Run in background", 1, 80);
        this.whoisCommand = new Command("Whois", 1, 80);
        this.ctcpCommand = new Command(CTCP, 1, 80);
        this.dccCommand = new Command("Dcc send", 1, 80);
        this.controlCommand = new Command("Control", 1, 80);
        this.mainMenuCommand = new Command("Main Menu", 1, 80);
        this.namesCommand = new Command(NAMES, 1, 500);
        this.topicCommand = new Command(VIEWTOPIC, 1, 15);
        this.closeCommand = new Command(CLOSE, 1, 100);
        this.ctcpCommand = new Command(CTCP, 1, 100);
        if (display.getCurrent() != null) {
            if (database.window_height < 1) {
                database.window_height = display.getCurrent().getHeight();
            }
            if (database.window_width < 1) {
                database.window_width = display.getCurrent().getWidth();
            }
        }
        this.form = new Form(null);
        this.form.setItemStateListener((ItemStateListener)this);
        int n = database.window_height;
        if (database.gui_show_textfield) {
            this.wTextField = new TextField(null, null, 255, 0);
            this.wTextField.setLayout(1);
            int n2 = this.wTextField.getPreferredHeight();
            if (n2 >= n) {
                n2 = 5;
            }
            n -= n2;
        }
        this.witem = new WindowItem(string, database, this, database.window_width, n);
        this.witem.setPreferredSize(database.window_width, n);
        this.witem.setItemCommandListener(this);
        this.witem.headerColor = 0xC8C8FF;
        this.addCommandsWitem();
        this.witem.setLayout(3);
        this.form.append((Item)this.witem);
        if (database.gui_show_textfield) {
            this.wTextField.addCommand(this.sendCommand);
            this.wTextField.addCommand(this.saveCommand);
            this.wTextField.addCommand(this.autoCompleteCommand);
            this.wTextField.addCommand(this.saveCommand);
            this.wTextField.addCommand(this.deleteCommand);
            this.wTextField.addCommand(this.cancelCommand);
            this.wTextField.addCommand(this.colorCommand);
            this.wTextField.addCommand(this.boldCommand);
            this.wTextField.addCommand(this.underlineCommand);
            this.wTextField.setDefaultCommand(this.sendCommand);
            this.wTextField.setItemCommandListener((ItemCommandListener)this);
            this.form.append((Item)this.wTextField);
        }
    }

    public void addCommandsWitem() {
        this.witem.removeCommand(this.whoisCommand);
        this.witem.removeCommand(this.controlCommand);
        this.witem.removeCommand(this.ctcpCommand);
        this.witem.removeCommand(this.dccCommand);
        this.witem.addCommand(this.msgCommand);
        this.witem.addCommand(this.windowsCommand);
        this.witem.addCommand(this.disconnectCommand);
        this.witem.addCommand(this.backgroudCommand);
        this.witem.addCommand(this.joinCommand);
        this.witem.addCommand(this.nickCommand);
        this.witem.addCommand(this.queryCommand);
        this.witem.addCommand(this.mainMenuCommand);
        this.witem.setDefaultCommand(this.msgCommand);
    }

    public void addWitemNamesCommand() {
        this.witem.removeCommand(this.msgCommand);
        this.witem.removeCommand(this.windowsCommand);
        this.witem.removeCommand(this.disconnectCommand);
        this.witem.removeCommand(this.backgroudCommand);
        this.witem.removeCommand(this.joinCommand);
        this.witem.removeCommand(this.nickCommand);
        this.witem.removeCommand(this.mainMenuCommand);
        this.witem.addCommand(this.whoisCommand);
        this.witem.addCommand(this.controlCommand);
        this.witem.addCommand(this.ctcpCommand);
        this.witem.addCommand(this.dccCommand);
        this.witem.setDefaultCommand(this.queryCommand);
    }

    public void write(String string, boolean bl) {
        this.write(new Message(string, bl ? 2 : 1));
    }

    public void write(Message message) {
        this.witem.windowstatus = this.getDisplayable().isShown() ? 0 : (message.getType() == 1 || message.getType() == 2 ? 1 : 3);
        if (this.db.gui_timestamp) {
            Calendar calendar = Calendar.getInstance();
            String string = Utils.addPrezedingZero(calendar.get(11)) + ":" + Utils.addPrezedingZero(calendar.get(12)) + ":" + Utils.addPrezedingZero(calendar.get(13));
            message.text = "[" + string + "] " + message.text;
        }
        this.witem.addText(message);
    }

    public void writeInfo(String string) {
        this.write(new Message("*** " + string, 3));
    }

    public Displayable getDisplayable() {
        return this.form;
    }

    public String getName() {
        return this.name;
    }

    public void show() {
        this.display.setCurrent((Displayable)this.form);
    }

    public void close() {
        WLIrc2.allwindows.removeElement(this);
        if (WLIrc2.allwindows.size() > 0) {
            ScreenOutput screenOutput = (ScreenOutput)WLIrc2.allwindows.lastElement();
            this.display.setCurrent((Displayable)screenOutput.form);
        } else {
            this.display.setCurrent((Displayable)this.irc.getListener().console.form);
        }
    }

    public void clear() {
        this.witem.v.removeAllElements();
    }

    protected void addTextBox() {
        if (this.db.gui_show_textfield) {
            this.display.setCurrentItem((Item)this.wTextField);
        } else {
            this.textbox = new TextBox("Write text", "", 1000, 0);
            this.textbox.setCommandListener((CommandListener)this);
            this.textbox.addCommand(this.sendCommand);
            this.textbox.addCommand(this.saveCommand);
            this.textbox.addCommand(this.autoCompleteCommand);
            this.textbox.addCommand(this.saveCommand);
            this.textbox.addCommand(this.deleteCommand);
            this.textbox.addCommand(this.cancelCommand);
            this.textbox.addCommand(this.colorCommand);
            this.textbox.addCommand(this.boldCommand);
            this.textbox.addCommand(this.underlineCommand);
            this.display.setCurrent((Displayable)this.textbox);
        }
    }

    protected void sendData(String string) throws IOException {
        this.show();
        this.textbox = null;
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '/') {
                if (string.toUpperCase().startsWith("/MSG")) {
                    String[] stringArray = Utils.splitString(string, " ");
                    if (stringArray.length > 1) {
                        String string2 = "";
                        for (int i = 2; i < stringArray.length; ++i) {
                            string2 = string2 + stringArray[i] + " ";
                        }
                        this.irc.writeLine("PRIVMSG " + stringArray[1] + " :" + string2);
                        this.write(new Message("Message to " + stringArray[1] + ": " + string2, 3));
                    }
                } else if (string.toUpperCase().startsWith("/ME")) {
                    this.irc.writeLine("PRIVMSG " + this.getName() + " :" + '\u0001' + "ACTION " + string + '\u0001');
                    this.write("* " + this.profile.nick + " " + string, true);
                } else if (string.toUpperCase().startsWith("/CLEAR")) {
                    this.clear();
                    this.write(new Message("window cleared!", 3));
                } else if (string.toUpperCase().startsWith("/SERVER")) {
                    Profile profile = new Profile();
                    profile.nick = this.profile.nick;
                    profile.realname = this.profile.realname;
                    String[] stringArray = Utils.splitString(string, " ");
                    int n = 6667;
                    if (stringArray.length == 3) {
                        try {
                            n = Integer.parseInt(stringArray[2]);
                        }
                        catch (Exception exception) {}
                    } else if (stringArray.length != 2) {
                        this.writeInfo("invalid input: /connect server [port]");
                        return;
                    }
                    profile.host = stringArray[1];
                    profile.port = n;
                    profile.profilename = profile.host;
                    WLIrc2.addServer(profile, this.display, this.db);
                } else {
                    this.irc.writeLine(string.substring(1));
                    new Message("RAW MESSAGE: " + string, 3);
                }
            } else {
                this.irc.writeLine("PRIVMSG " + this.getName() + " :" + string);
                this.write(this.profile.nick + "> " + string, false);
            }
        }
    }

    protected void saveData() {
        String string = this.getTextBoxData();
        this.db.messages.addElement(string);
        this.db.save(3);
        this.display.setCurrent((Displayable)new Alert("Saved", "Saved", null, AlertType.INFO));
    }

    protected void deleteData() {
        this.delfavlist = new List("Delete favorites", 3);
        for (int i = 0; i < this.db.messages.size(); ++i) {
            this.delfavlist.append(this.db.messages.elementAt(i).toString(), null);
        }
        this.delfavlist.addCommand(this.cancelCommand);
        this.delfavlist.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.delfavlist);
    }

    private String getTextBoxData() {
        if (this.textbox != null) {
            return this.textbox.getString();
        }
        return this.wTextField.getString();
    }

    private void setTextBoxData(String string) {
        if (this.textbox != null) {
            this.textbox.setString(string);
        } else {
            this.wTextField.setString(string);
        }
    }

    public void itemStateChanged(Item item) {
        TextField textField = (TextField)item;
        String string = textField.getString();
        if (textField.getCaretPosition() > 0) {
            System.err.println(string.charAt(textField.getCaretPosition() - 1));
        }
        if (textField.getCaretPosition() > 0 && string.charAt(textField.getCaretPosition() - 1) == '\\') {
            try {
                this.sendData(string.substring(0, string.length() - 1));
            }
            catch (IOException iOException) {
                WLIrc2.writeError(iOException, this.display, (Displayable)WLIrc2.mainForm);
            }
            textField.setString("");
        }
    }

    public void commandAction(Command command, Item item) {
        System.err.println("commandAction ITEM" + item);
        try {
            Object object;
            Object object2;
            Object object3;
            if (command == this.backgroudCommand) {
                WLIrc2.background_display = this.getDisplayable();
                WLIrc2.wlirc.pauseApp();
            }
            if (command == this.mainMenuCommand) {
                WLIrc2.mainForm.addCommand(WLIrc2.wlirc.resumeCommand);
                WLIrc2.mainForm.removeCommand(WLIrc2.wlirc.connectCommand);
                this.display.setCurrent((Displayable)WLIrc2.mainForm);
            }
            if (command == this.joinCommand) {
                this.textbox = new TextBox(JOIN_CHANNEL, "", 30, 0);
                this.textbox.setCommandListener((CommandListener)this);
                this.textbox.addCommand(this.okCommand);
                this.textbox.addCommand(this.cancelCommand);
                this.display.setCurrent((Displayable)this.textbox);
            } else if (command == this.nickCommand) {
                this.textbox = new TextBox(CHANGE_NICK, "", 30, 0);
                this.textbox.setCommandListener((CommandListener)this);
                this.textbox.addCommand(this.okCommand);
                this.textbox.addCommand(this.cancelCommand);
                this.display.setCurrent((Displayable)this.textbox);
            } else if (command == this.queryCommand && !this.witem.list_use) {
                this.textbox = new TextBox(QUERY, "", 30, 0);
                this.textbox.setCommandListener((CommandListener)this);
                this.textbox.addCommand(this.okCommand);
                this.textbox.addCommand(this.cancelCommand);
                this.display.setCurrent((Displayable)this.textbox);
            } else if (command == this.disconnectCommand) {
                object3 = WLIrc2.servers.elements();
                while (object3.hasMoreElements()) {
                    object2 = (Listener)object3.nextElement();
                    ((Listener)object2).irc.setConnected(false);
                    ((Listener)object2).irc.getListener().cleanup();
                }
                this.display.setCurrent((Displayable)WLIrc2.mainForm);
            } else if (command == this.msgCommand) {
                this.addTextBox();
            } else if (command == this.windowsCommand) {
                this.dynlist = new List("Windows", 3);
                object3 = WLIrc2.allwindows.elements();
                while (object3.hasMoreElements()) {
                    object2 = (ScreenOutput)object3.nextElement();
                    this.dynlist.append(((ScreenOutput)object2).getName(), null);
                }
                this.dynlist.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.dynlist);
            } else if (this.dynlist != null && command == List.SELECT_COMMAND) {
                object3 = this.dynlist.getString(this.dynlist.getSelectedIndex());
                object2 = WLIrc2.allwindows.elements();
                while (object2.hasMoreElements()) {
                    object = (ScreenOutput)object2.nextElement();
                    if (!((String)object3).equals(((ScreenOutput)object).getName())) continue;
                    ((ScreenOutput)object).show();
                }
            }
            if (this.favlist != null && command == List.SELECT_COMMAND) {
                if (this.wTextField != null) {
                    this.textbox.setString(this.favlist.getString(this.favlist.getSelectedIndex()));
                    this.display.setCurrent((Displayable)this.textbox);
                } else {
                    this.wTextField.setString(this.favlist.getString(this.favlist.getSelectedIndex()));
                    this.display.setCurrentItem((Item)this.wTextField);
                }
                this.favlist = null;
                return;
            }
            if (command == this.autoCompleteCommand) {
                int n;
                System.err.println("OK " + this.db.messages.size());
                object3 = this.getTextBoxData();
                this.favlist = new List("Favorites", 3);
                for (n = 0; n < this.db.messages.size(); ++n) {
                    object = this.db.messages.elementAt(n).toString();
                    if (!Utils.hasNoValue((String)object3) && !((String)object).startsWith((String)object3)) continue;
                    this.favlist.append((String)object, null);
                }
                if (this.favlist.size() == 1) {
                    this.setTextBoxData(this.favlist.getString(0));
                } else if (this.favlist.size() > 1) {
                    this.favlist.setCommandListener((CommandListener)this);
                    this.display.setCurrent((Displayable)this.favlist);
                } else {
                    for (n = 0; n < this.db.messages.size(); ++n) {
                        object = this.db.messages.elementAt(n).toString();
                        this.favlist.append((String)object, null);
                    }
                    if (this.favlist.size() > 0) {
                        this.favlist.setCommandListener((CommandListener)this);
                        this.display.setCurrent((Displayable)this.favlist);
                    } else {
                        this.display.setCurrent((Displayable)new Alert("No favorites exists"));
                    }
                }
            } else if (command == this.saveCommand) {
                this.saveData();
            } else if (command == this.deleteCommand) {
                this.deleteData();
            } else if (command == this.sendCommand) {
                if (item instanceof TextField) {
                    object2 = (TextField)item;
                    object3 = object2.getString();
                    object2.setString("");
                } else {
                    object3 = this.textbox.getString();
                }
                this.sendData((String)object3);
            } else if (command == this.cancelCommand) {
                if (this.delfavlist != null && this.textbox != null) {
                    this.display.setCurrent((Displayable)this.textbox);
                    this.delfavlist = null;
                } else {
                    this.show();
                    this.textbox = null;
                }
            } else if (command == this.okCommand) {
                if (this.textbox.getTitle().equals(JOIN_CHANNEL)) {
                    object3 = this.textbox.getString();
                    if (!((String)object3).startsWith("#")) {
                        object3 = "#" + (String)object3;
                    }
                    this.show();
                    this.irc.writeLine("JOIN " + (String)object3);
                    this.textbox = null;
                } else if (this.textbox.getTitle().equals(CHANGE_NICK)) {
                    object3 = this.textbox.getString();
                    this.irc.writeLine("NICK " + (String)object3);
                    this.changenick = object3;
                    this.show();
                    this.textbox = null;
                } else {
                    object3 = this.textbox.getString();
                    this.irc.getListener().getPrivate((String)object3, this.display, this.db, this.irc);
                    this.textbox = null;
                }
            } else if (command == this.colorCommand) {
                this.setTextBoxData(this.textbox.getString() + Utils.toString('\u0003'));
            } else if (command == this.underlineCommand) {
                this.setTextBoxData(this.textbox.getString() + Utils.toString('\u001f'));
            } else if (command == this.boldCommand) {
                this.setTextBoxData(this.textbox.getString() + Utils.toString('\u0002'));
            } else if (this.delfavlist != null && this.delfavlist.isShown() && command == List.SELECT_COMMAND) {
                this.db.messages.removeElementAt(this.delfavlist.getSelectedIndex());
                this.db.save(3);
                this.display.setCurrent(new Alert("Deleted", "Deleted", null, AlertType.INFO), (Displayable)this.textbox);
                this.delfavlist = null;
            }
        }
        catch (IOException iOException) {
            WLIrc2.writeError(iOException, this.display, (Displayable)WLIrc2.mainForm);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        this.commandAction(command, (Item)this.witem);
    }
}

