/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Display;
import wlirc2.Database;
import wlirc2.Encoding;
import wlirc2.Irc;
import wlirc2.Listener;
import wlirc2.Utils;

public class SocketIrc
implements Irc {
    private DataOutputStream out;
    private DataInputStream in;
    private StreamConnection c;
    private boolean isconnected = false;
    public Vector vectorSend;
    public Vector vectorReceive;
    private Display display;
    private Database db;
    private byte[] restbyte;
    private Listener listener;

    public SocketIrc(Database database, Display display, Listener listener) {
        this.db = database;
        this.vectorSend = new Vector();
        this.vectorReceive = new Vector();
        this.display = display;
        this.restbyte = null;
        this.listener = listener;
    }

    public boolean isConnected() {
        return this.isconnected;
    }

    public void setConnected(boolean bl) {
        this.isconnected = bl;
    }

    public void sendReceive(boolean bl) throws IOException {
        int n = this.in.available();
        if (n > 0) {
            int n2 = this.restbyte == null ? 0 : this.restbyte.length;
            byte[] byArray = new byte[n2 + n];
            if (this.restbyte != null) {
                System.arraycopy(this.restbyte, 0, byArray, 0, this.restbyte.length);
            }
            this.in.readFully(byArray, n2, n);
            int n3 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 13 && byArray[i] != 10) continue;
                String string = Encoding.toString(byArray, n3, i - n3, this.db.encoding);
                if (string != null && !(string = string.trim()).equals("")) {
                    System.out.println("IN> " + string);
                    this.vectorReceive.addElement(string);
                }
                n3 = i;
            }
            if (n3 != byArray.length) {
                this.restbyte = new byte[byArray.length - n3];
                System.arraycopy(byArray, n3, this.restbyte, 0, this.restbyte.length);
            }
        }
        if (!this.vectorSend.isEmpty()) {
            String string = (String)Utils.popFifo(this.vectorSend);
            string = string + "\r\n";
            this.out.write(Encoding.getBytes(string, this.db.encoding));
            this.out.flush();
            System.out.println("OUT> " + string);
        }
        if (n < 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void connect(String string, int n) throws IOException, ConnectionNotFoundException {
        String string2 = "socket://" + string + ":" + n;
        System.err.println("URL: " + string2);
        this.c = (StreamConnection)Connector.open((String)string2, (int)3);
        this.out = this.c.openDataOutputStream();
        this.in = this.c.openDataInputStream();
        this.isconnected = true;
    }

    public void disconnect() throws IOException {
        this.writeLine("Quit :used WLIrc 2.0 Beta 5 (" + System.getProperty("microedition.platform") + ")");
        this.sendReceive(false);
        try {
            this.out.close();
            this.in.close();
            this.c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String readLine() throws IOException {
        if (!this.vectorReceive.isEmpty()) {
            return (String)Utils.popFifo(this.vectorReceive);
        }
        return null;
    }

    public synchronized void writeLine(String string) throws IOException {
        if (string != null) {
            this.vectorSend.addElement(string);
        }
    }

    public Listener getListener() {
        return this.listener;
    }
}

