/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import wlirc2.Channel;
import wlirc2.Database;
import wlirc2.Message;
import wlirc2.ScreenOutput;
import wlirc2.WLIrc2;

public class WindowItem
extends CustomItem {
    protected String header;
    protected int position;
    private Database db;
    protected int windowstatus;
    private static final int BUTTON_POSITION_WINDOW_WIDTH = 10;
    private static final int SPACE_BETWEEN_WINDOWS = 10;
    private int height;
    private int width;
    private int screen_width;
    private int screen_height;
    protected Vector v;
    protected int headerColor;
    protected Font f;
    protected Font FONT_NAMELIST = Font.getFont((int)0, (int)0, (int)8);
    private int[] rgbdata_header;
    private int[] rgbdata_scroll;
    private ScreenOutput so;
    protected boolean IN = false;
    private int header_height = 15;
    private int info_height = 15;
    private static int SCROLL_WIDTH = 7;
    protected int list_position = 0;
    protected int list_selected = 0;
    protected boolean list_use = false;
    private static int BORDERWIDTH = 2;
    private static int OFFSETLEFT = BORDERWIDTH + 1;
    private int list_width = 62;

    public WindowItem(String string, Database database, ScreenOutput screenOutput, int n, int n2) {
        super(null);
        this.header = string;
        this.db = database;
        this.so = screenOutput;
        this.screen_height = n2;
        this.screen_width = n;
        this.width = n;
        this.f = database.getFont();
        this.v = new Vector();
        this.position = 0;
        this.windowstatus = 0;
        this.generategui(this.screen_width, this.screen_height);
    }

    private int getHeightoffset() {
        return this.header_height + this.info_height;
    }

    private int getWidthOffset() {
        int n = SCROLL_WIDTH;
        if (this.so != null && this.so.showlist) {
            n += this.list_width;
        }
        return n + 2;
    }

    private int getMaxElemsNameList() {
        int n = (this.height - this.getHeightoffset()) / this.FONT_NAMELIST.getHeight();
        return --n;
    }

    private void generategui(int n, int n2) {
        int n3;
        if (n2 < 1 || n < 1) {
            return;
        }
        this.header_height = this.db.getHeaderFont().getHeight() + 2;
        this.info_height = this.db.getInfoFont().getHeight() + 2;
        double d = n;
        this.rgbdata_header = new int[n * this.header_height];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < this.header_height; ++n3) {
            int n7 = (int)((double)n3 / (double)this.header_height * 15.0);
            System.err.println("POS: " + n7);
            int n8 = n3 * n;
            int n9 = (WLIrc2.PNG_HEADER_FADE_START[n7] & 0xFF0000) >> 16;
            int n10 = (WLIrc2.PNG_HEADER_FADE_START[n7] & 0xFF00) >> 8;
            n5 = WLIrc2.PNG_HEADER_FADE_START[n7] & 0xFF;
            int n11 = (WLIrc2.PNG_HEADER_FADE_END[n7] & 0xFF0000) >> 16;
            int n12 = (WLIrc2.PNG_HEADER_FADE_END[n7] & 0xFF00) >> 8;
            n6 = WLIrc2.PNG_HEADER_FADE_END[n7] & 0xFF;
            for (int i = 0; i < n; ++i) {
                int n13 = n9 + (int)((double)i / d * (double)(n11 - n9));
                int n14 = n10 + (int)((double)i / d * (double)(n12 - n10));
                n4 = n5 + (int)((double)i / d * (double)(n6 - n5));
                this.rgbdata_header[n8 + i] = 65536 * n13 + 256 * n14 + n4;
            }
        }
        System.err.println("HEADER_CALC OK");
        this.rgbdata_scroll = new int[SCROLL_WIDTH * (n2 - this.getHeightoffset())];
        for (n3 = 0; n3 < n2 - this.getHeightoffset(); ++n3) {
            System.arraycopy(WLIrc2.PNG_SCROLL, 0, this.rgbdata_scroll, n3 * SCROLL_WIDTH, SCROLL_WIDTH);
        }
    }

    protected void sizeChanged(int n, int n2) {
        System.err.println("SIZECHANGED: " + n + "- " + n2);
        if (n != this.width || this.height != this.width) {
            this.width = n;
            this.height = n2;
            this.refreshGuiParameters();
        }
        this.setWindowRightPosition(WLIrc2.getElementPosition(this.so));
    }

    protected int getMinContentHeight() {
        return 50;
    }

    protected int getMinContentWidth() {
        return 50;
    }

    protected int getPrefContentHeight(int n) {
        return this.screen_height;
    }

    protected int getPrefContentWidth(int n) {
        return this.screen_width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        Vector vector = this.v;
        synchronized (vector) {
            int n5;
            int n6;
            int n7;
            this.windowstatus = 0;
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, n, n2);
            graphics.drawRGB(this.rgbdata_header, 0, n, 0, 0, n, this.header_height, false);
            Font font = this.db.getHeaderFont();
            graphics.setFont(font);
            graphics.setColor(0xFFFFFF);
            n4 = (this.header_height - font.getHeight()) / 2;
            graphics.drawString(this.header, 3, (n4 += BORDERWIDTH) + BORDERWIDTH, 20);
            this.draw(graphics);
            graphics.setFont(this.f);
            graphics.setColor(0);
            int n8 = this.getMaxlinesScreen();
            if (this.v.size() > n8) {
                this.getHeightoffset();
                double d = (double)this.v.size() * 1.0 / (double)n8;
                n7 = (int)((double)(n2 - this.getHeightoffset()) / d) + 8;
                d = (double)(n2 - this.getHeightoffset()) / d;
                if (d < 20.0) {
                    d = 20.0;
                    n7 = 28;
                }
                int n9 = (int)((double)this.position * 1.0 / (double)(this.v.size() - n8) * (double)(n2 - this.getHeightoffset() - n7)) + this.getHeightoffset();
                n6 = n - this.getWidthOffset();
                graphics.drawRGB(this.rgbdata_scroll, 0, SCROLL_WIDTH, n6, this.getHeightoffset(), SCROLL_WIDTH, n2 - this.getHeightoffset(), false);
                n5 = ++n9;
                graphics.drawRGB(WLIrc2.PNG_SCROLLBUTTON_TOP, 0, SCROLL_WIDTH, n6, n5, SCROLL_WIDTH, 4, false);
                int[] nArray = new int[SCROLL_WIDTH * (int)d];
                for (int i = 0; i < (int)d; ++i) {
                    System.arraycopy(WLIrc2.PNG_SCROLLBUTTON_MIDDLE, 0, nArray, i * SCROLL_WIDTH, SCROLL_WIDTH);
                }
                graphics.drawRGB(nArray, 0, SCROLL_WIDTH, n6, n5 + 4, SCROLL_WIDTH, (int)d, false);
                graphics.drawRGB(WLIrc2.PNG_SCROLLBUTTON_BOTTOM, 0, SCROLL_WIDTH, n6, n5 + (int)d, SCROLL_WIDTH, 4, false);
            }
            Stack stack = WLIrc2.allwindows;
            graphics.setColor(15526360);
            graphics.fillRect(0, this.header_height + 1, n, this.info_height - 1);
            graphics.setColor(9474962);
            graphics.fillRect(0, this.header_height + this.info_height - 1, n, 1);
            n3 = 0;
            graphics.setFont(this.db.getInfoFont());
            n3 = OFFSETLEFT;
            if (WLIrc2.left_position_window > 0) {
                n3 += this.db.getInfoFont().stringWidth("<<") + 3;
                graphics.setColor(0);
                graphics.drawString("<<", BORDERWIDTH + 1, this.header_height + 2, 20);
            }
            for (n7 = WLIrc2.left_position_window; n7 < stack.size(); ++n7) {
                ScreenOutput screenOutput = (ScreenOutput)stack.elementAt(n7);
                n6 = this.f.stringWidth(screenOutput.getName());
                if (n3 + n6 > n - 10) {
                    graphics.setColor(0);
                    graphics.drawString(">>", n - this.db.getInfoFont().stringWidth(">>") + 1, this.header_height + 2, 20);
                    break;
                }
                if (((Object)((Object)screenOutput.witem)).equals((Object)this)) {
                    graphics.setColor(16762684);
                    graphics.drawLine(n3 - 3, this.header_height + 2, n3 + n6 + 5, this.header_height + 2);
                    graphics.setColor(15108908);
                    graphics.drawLine(n3 - 3, this.header_height + 1, n3 + n6 + 5, this.header_height + 1);
                    graphics.setColor(0);
                } else if (screenOutput.witem.windowstatus == 1) {
                    graphics.setColor(255, 0, 0);
                } else if (screenOutput.witem.windowstatus != 0) {
                    graphics.setColor(0, 0, 255);
                } else {
                    graphics.setColor(0, 0, 0);
                }
                graphics.setFont(this.db.getInfoFont());
                n4 = (this.info_height - this.db.getInfoFont().getHeight()) / 2;
                graphics.drawString(screenOutput.getName(), n3, n4 += this.header_height + BORDERWIDTH, 20);
                graphics.setColor(11315353);
                n5 = 5;
                graphics.drawLine((n3 += n6 + 10) - n5, this.header_height, n3 - n5, this.header_height + this.info_height - 1);
                graphics.setColor(0xFFFFFF);
                graphics.drawLine(n3 - n5 - 1, this.header_height, n3 - n5 - 1, this.header_height + this.info_height - 1);
            }
        }
        if (this.so != null && this.so.showlist) {
            graphics.setColor(0xCECECE);
            graphics.drawLine(n - this.list_width, this.header_height + this.info_height - 1, n - this.list_width, n2);
            graphics.setFont(this.FONT_NAMELIST);
            graphics.setColor(0);
            int n10 = this.FONT_NAMELIST.getHeight();
            int n11 = this.getMaxElemsNameList();
            for (n4 = this.list_position; n4 < n11 + this.list_position && n4 < this.so.list.size(); ++n4) {
                String string = (String)this.so.list.elementAt(n4);
                int n12 = n - this.list_width + 2;
                n3 = this.getHeightoffset() + (n4 - this.list_position) * n10;
                if (this.list_use) {
                    if (this.list_selected == n4) {
                        graphics.setColor(3238597);
                        graphics.fillRect(n12, n3, this.list_width, n10);
                        graphics.setColor(0xFFFFFF);
                    } else {
                        graphics.setColor(0);
                    }
                }
                graphics.drawString(string, n12, n3, 20);
            }
            graphics.setColor(12960696);
            if (this.list_position > 0) {
                graphics.drawString("<<", n - this.list_width + 2, n2 - BORDERWIDTH - n10, 20);
            }
            if (this.so.list.size() > this.list_position + n11) {
                graphics.drawString(">>", n - BORDERWIDTH, n2 - BORDERWIDTH - n10, 24);
            }
        }
        graphics.setColor(15526360);
        graphics.drawRect(1, 1, n - 3, n2 - 3);
        graphics.setColor(11315353);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
    }

    public void setFont(Font font) {
        this.f = font;
    }

    public synchronized void addText(Message message) {
        if (message != null && message.getText() != null) {
            int n = this.v.size();
            this.addTextTextArea(message);
            int n2 = this.position + this.getMaxlinesScreen();
            if (n2 >= n) {
                this.position = this.v.size() - this.getMaxlinesScreen();
            }
            if (this.position < 0) {
                this.position = 0;
            }
        }
        if (this.so != null && this.so.display.getCurrent().equals(this.so.form)) {
            this.repaint();
        }
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int n) {
        boolean bl = false;
        WindowItem windowItem = this;
        synchronized (windowItem) {
            if (!this.so.showlist && this.list_use) {
                this.list_use = false;
            }
            int n2 = this.v.size();
            if (n == 50) {
                if (this.list_use) {
                    if (this.list_selected > 0) {
                        --this.list_selected;
                        if (this.list_selected < this.list_position) {
                            --this.list_position;
                        }
                        bl = true;
                    }
                } else if (this.position > 0) {
                    --this.position;
                    bl = true;
                }
            } else if (n == 56) {
                if (this.list_use) {
                    if (this.list_selected < this.so.list.size() - 1) {
                        ++this.list_selected;
                        if (this.list_selected >= this.list_position + this.getMaxElemsNameList()) {
                            ++this.list_position;
                        }
                        bl = true;
                    }
                } else if (this.position + this.getMaxlinesScreen() < n2) {
                    ++this.position;
                    bl = true;
                }
            } else if (n == 52) {
                if (this.list_position > 0) {
                    this.list_position -= this.getMaxElemsNameList();
                    if (this.list_position < 0) {
                        this.list_position = 0;
                    }
                    if (this.list_selected >= this.list_position + this.getMaxElemsNameList()) {
                        this.list_selected = this.list_position;
                    }
                    bl = true;
                    this.list_use = true;
                } else {
                    this.so.addCommandsWitem();
                    this.list_use = false;
                    bl = true;
                }
            } else if (n == 53) {
                if (!this.so.showlist) {
                    this.list_use = false;
                } else {
                    boolean bl2 = this.list_use = !this.list_use;
                    if (this.list_use) {
                        this.so.addWitemNamesCommand();
                    } else {
                        this.so.addCommandsWitem();
                    }
                }
                bl = true;
            } else if (n == 54) {
                if (this.list_use) {
                    int n3 = this.getMaxElemsNameList();
                    if (this.list_position + n3 < this.so.list.size()) {
                        this.list_position += n3;
                        if (this.list_position + n3 > this.so.list.size()) {
                            this.list_position = this.so.list.size() - n3;
                        }
                        if (this.list_selected < this.list_position) {
                            this.list_selected = this.list_position;
                        }
                    }
                } else if (this.so.showlist) {
                    this.so.addWitemNamesCommand();
                }
                bl = true;
                this.list_use = true;
            } else if (n == 51) {
                if (this.position > 0) {
                    int n4 = this.getMaxlinesScreen();
                    this.position = this.position - n4 < 0 ? 0 : (this.position -= n4);
                    bl = true;
                }
            } else if (n == 57) {
                if (this.position + this.getMaxlinesScreen() < n2) {
                    int n5 = this.getMaxlinesScreen();
                    this.position = this.position + n5 > n2 - n5 ? n2 - n5 : (this.position += n5);
                    bl = true;
                }
            } else if (n == 49) {
                this.position = 0;
                bl = true;
            } else if (n == 55) {
                int n6 = n2 - this.getMaxlinesScreen();
                if (n6 >= 0) {
                    this.position = n6;
                }
                bl = true;
            } else if (n == 42) {
                for (int i = 0; i < WLIrc2.allwindows.size(); ++i) {
                    ScreenOutput screenOutput = (ScreenOutput)WLIrc2.allwindows.elementAt(i);
                    if (!screenOutput.getDisplayable().isShown()) continue;
                    screenOutput.addTextBox();
                }
            } else if (n == 35 && this.so instanceof Channel) {
                ((Channel)this.so).switchNameList();
            }
        }
        if (bl) {
            this.update();
        }
    }

    public int getMaxlinesScreen() {
        return (this.height - this.getHeightoffset()) / this.f.getHeight() - 1;
    }

    private void addElement(String[] stringArray) {
        if (this.v.size() >= this.db.maxLinesInWindow) {
            this.v.removeElementAt(0);
        }
        this.v.addElement(stringArray);
    }

    public void addTextTextArea(Message message) {
        int n;
        int n2;
        char[] cArray = message.text.toCharArray();
        int n3 = this.width - this.getWidthOffset() - OFFSETLEFT;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String[] stringArray = new String[1];
        int n7 = 0;
        int n8 = 0;
        boolean bl = true;
        int n9 = this.f.getStyle();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (message.type != 7) {
            n = n2 = this.getSolColor(message);
            stringBuffer.append((char)((n2 << 4) + (n9 << 1) + 1));
        } else {
            n = n2 = cArray[0] >> 4;
            stringBuffer.append(cArray[0]);
            cArray = message.text.substring(1).toCharArray();
        }
        Font font = Font.getFont((int)this.f.getFace(), (int)(this.f.getStyle() | 1), (int)this.f.getSize());
        for (int i = 0; i < cArray.length; ++i) {
            int n10;
            Object[] objectArray;
            boolean bl6 = i == cArray.length - 1;
            bl = true;
            char c = cArray[i];
            switch (c) {
                case '\u0002': {
                    if (!this.f.isBold()) {
                        n9 = bl2 ? --n9 : (n9 |= 1);
                        bl2 = !bl2;
                    }
                    ++n8;
                    break;
                }
                case '\u0003': 
                case '\u0004': {
                    objectArray = this.getColorCodeString(message.text.substring(i));
                    n2 = objectArray[0];
                    i += (n8 += objectArray[1]);
                    break;
                }
                case '\u0016': {
                    if (bl3) {
                        n2 = n;
                    } else {
                        n = n2;
                        n2 = 1;
                    }
                    bl3 = !bl3;
                    ++n8;
                    break;
                }
                case '\u001f': {
                    if (!this.f.isUnderlined()) {
                        n9 = bl4 ? (n9 -= 4) : (n9 |= 4);
                        bl4 = !bl4;
                    }
                    ++n8;
                    break;
                }
                case '\u0011': {
                    n9 = this.f.getStyle();
                    bl2 = false;
                    bl4 = false;
                    n2 = 16;
                    ++n8;
                    break;
                }
                case '\n': {
                    n10 = cArray[i + 1];
                    n9 = (n10 & 0xF) >> 1;
                    n2 = n10 >> 4;
                    n8 += 2;
                    break;
                }
                case ' ': {
                    n4 = i;
                    n5 = stringBuffer.length() + 1;
                }
                default: {
                    if (n9 != font.getStyle()) {
                        font = Font.getFont((int)this.f.getFace(), (int)n9, (int)this.f.getSize());
                    }
                    stringBuffer.append(c);
                    bl = false;
                    if (bl6 || (n6 += font.charWidth(c)) + this.f.charWidth(cArray[i + 1]) <= n3) break;
                    bl5 = true;
                    bl = true;
                }
            }
            if (bl6) {
                bl5 = true;
                bl = true;
                n4 = 0;
            }
            if (bl) {
                char c2 = (char)((n2 << 4) + (n9 << 1));
                if (bl5 && n4 > 0) {
                    n10 = stringBuffer.charAt(0);
                    n10 >>= 1;
                    c2 = (char)(n10 <<= 1);
                    i = n4 + n8;
                    stringBuffer.delete(n5, stringBuffer.length());
                }
                if (stringArray.length == n7) {
                    String[] stringArray2 = stringArray;
                    stringArray = new String[10 + stringArray.length];
                    System.arraycopy(stringArray2, 0, stringArray, 0, n7);
                }
                stringArray[n7] = stringBuffer.toString();
                stringBuffer = new StringBuffer();
                stringBuffer.append(c2);
                ++n7;
                n8 = 0;
                n4 = 0;
                bl = false;
            }
            if (!bl5) continue;
            if (stringArray.length > n7) {
                objectArray = stringArray;
                stringArray = new String[n7];
                System.arraycopy(objectArray, 0, stringArray, 0, n7);
            }
            if (!bl6 && cArray[i + 1] == ' ') {
                stringArray[stringArray.length - 1] = stringArray[stringArray.length - 1] + " ";
            }
            this.addElement(stringArray);
            if (bl6) continue;
            if (cArray[i + 1] == ' ') {
                ++i;
            }
            stringArray = new String[1];
            n7 = 0;
            n6 = 0;
            bl5 = false;
        }
    }

    public void draw(Graphics graphics) {
        int n = this.getMaxlinesScreen();
        int n2 = -1;
        for (int i = this.position; i < this.position + n; ++i) {
            int n3 = i - this.position;
            if (i >= this.v.size()) break;
            String[] stringArray = (String[])this.v.elementAt(i);
            int n4 = OFFSETLEFT;
            for (int j = 0; j < stringArray.length; ++j) {
                int n5;
                int n6;
                char c = stringArray[j].charAt(0);
                if (n2 >> 1 != c >> 1) {
                    n2 = c;
                    n6 = (c & 0xF) >> 1;
                    n5 = c >> 8;
                    graphics.setColor(this.getColor(n5));
                    graphics.setFont(Font.getFont((int)this.f.getFace(), (int)n6, (int)this.f.getSize()));
                }
                if ((n6 = (n2 & 0xFF) >> 4) > 0) {
                    n5 = graphics.getColor();
                    graphics.setColor(this.getColor(n6));
                    graphics.fillRect(n4, this.getHeightoffset() + n3 * this.f.getHeight(), this.f.stringWidth(stringArray[j].substring(1)), this.f.getHeight());
                    graphics.setColor(n5);
                }
                graphics.drawString(stringArray[j].substring(1), n4, this.getHeightoffset() + n3 * this.f.getHeight(), 20);
                n4 += graphics.getFont().stringWidth(stringArray[j].substring(1));
            }
        }
    }

    private int getSolColor(Message message) {
        int n = 1;
        switch (message.getType()) {
            case 2: {
                n = 13;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 6: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
            }
        }
        return n << 4;
    }

    private int getColor(int n) {
        switch (n) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 127;
            }
            case 3: {
                return 29440;
            }
            case 4: {
                return 0xFF0000;
            }
            case 5: {
                return 0x7F0000;
            }
            case 6: {
                return 0x9C009C;
            }
            case 7: {
                return 16547584;
            }
            case 8: {
                return 0xFFFF00;
            }
            case 9: {
                return 64512;
            }
            case 10: {
                return 37779;
            }
            case 11: {
                return 65535;
            }
            case 12: {
                return 252;
            }
            case 13: {
                return 0xFF00FF;
            }
            case 14: {
                return 0x7F7F7F;
            }
            case 15: {
                return 0xD2D2D2;
            }
        }
        return n;
    }

    private int[] getColorCodeString(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 1; n < cArray.length; ++n) {
            char c = cArray[n];
            if (c == ',') {
                n4 = Integer.parseInt(stringBuffer.toString());
                n2 = stringBuffer.length() + 1;
                stringBuffer = new StringBuffer();
                bl = true;
                continue;
            }
            if (!Character.isDigit(c)) break;
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            n = Integer.parseInt(stringBuffer.toString());
            if (bl) {
                n3 = n;
            } else {
                n4 = n;
            }
        }
        int[] nArray = new int[]{(n4 << 4) + n3, n2 + stringBuffer.length()};
        return nArray;
    }

    protected boolean traverse(int n, int n2, int n3, int[] nArray) {
        if (this.so == null) {
            return false;
        }
        if (!this.IN) {
            this.IN = true;
            if (n == 6) {
                return true;
            }
        }
        if (n == 6) {
            this.IN = false;
            return false;
        }
        if (n == 5) {
            Enumeration enumeration = WLIrc2.allwindows.elements();
            while (enumeration.hasMoreElements()) {
                ScreenOutput screenOutput = (ScreenOutput)enumeration.nextElement();
                if (!screenOutput.getDisplayable().isShown()) continue;
                if (enumeration.hasMoreElements()) {
                    screenOutput = (ScreenOutput)enumeration.nextElement();
                } else {
                    screenOutput = (ScreenOutput)WLIrc2.allwindows.firstElement();
                    WLIrc2.left_position_window = 0;
                }
                screenOutput.witem.IN = false;
                int n4 = WLIrc2.getElementPosition(screenOutput);
                this.setWindowRightPosition(n4);
                screenOutput.show();
                return true;
            }
            this.so.display.setCurrentItem((Item)this.so.witem);
        } else if (n == 2) {
            for (int i = 0; i < WLIrc2.allwindows.size(); ++i) {
                ScreenOutput screenOutput = (ScreenOutput)WLIrc2.allwindows.elementAt(i);
                if (!screenOutput.getDisplayable().isShown()) continue;
                if (i == 0) {
                    screenOutput = (ScreenOutput)WLIrc2.allwindows.lastElement();
                    this.setWindowRightPosition(WLIrc2.allwindows.size() - 1);
                } else {
                    screenOutput = (ScreenOutput)WLIrc2.allwindows.elementAt(i - 1);
                }
                screenOutput.witem.IN = false;
                int n5 = WLIrc2.getElementPosition(screenOutput);
                if (n5 < WLIrc2.left_position_window) {
                    WLIrc2.left_position_window = n5;
                }
                screenOutput.show();
                return true;
            }
            this.so.display.setCurrentItem((Item)this.so.witem);
        }
        return true;
    }

    protected void setWindowRightPosition(int n) {
        int n2 = WLIrc2.left_position_window;
        while (n2 < WLIrc2.allwindows.size() && !this.hasSpaceForWindow(n)) {
            ++WLIrc2.left_position_window;
            ++n2;
        }
    }

    private boolean hasSpaceForWindow(int n) {
        int n2 = 0;
        if (WLIrc2.left_position_window > 0) {
            n2 += 10;
        }
        for (int i = WLIrc2.left_position_window; i <= n; ++i) {
            ScreenOutput screenOutput = (ScreenOutput)WLIrc2.allwindows.elementAt(i);
            if ((n2 += this.f.stringWidth(screenOutput.getName()) + 10) <= this.width - 10) continue;
            return false;
        }
        return true;
    }

    protected void traverseOut() {
        this.IN = false;
        super.traverseOut();
    }

    public void update() {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGuiParameters() {
        Vector vector = this.v;
        synchronized (vector) {
            System.err.println("REFRESHGUI!");
            Object[] objectArray = new Object[this.v.size()];
            this.v.copyInto(objectArray);
            this.v.removeAllElements();
            StringBuffer stringBuffer = null;
            char c = '\u0000';
            for (int i = 0; i < objectArray.length; ++i) {
                String[] stringArray = (String[])objectArray[i];
                char c2 = stringArray[0].charAt(0);
                if ((c2 & '\u0001') == 1) {
                    System.err.println("BEGINNING OF LINE");
                    if (stringBuffer != null) {
                        System.err.println("MESSAGE:" + stringBuffer.toString());
                        this.addTextTextArea(new Message(stringBuffer.toString(), 7));
                    }
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(c2);
                    c = c2;
                }
                for (int j = 0; j < stringArray.length; ++j) {
                    c2 = stringArray[j].charAt(0);
                    System.err.println("F: [" + stringArray[j] + "]");
                    if (c2 >> 1 != c >> 1) {
                        stringBuffer.append('\n');
                        stringBuffer.append(stringArray[j]);
                        c = c2;
                        continue;
                    }
                    stringBuffer.append(stringArray[j].substring(1));
                }
            }
            if (stringBuffer != null) {
                System.err.println("MESSAGE: " + stringBuffer.toString());
                this.addTextTextArea(new Message(stringBuffer.toString(), 7));
            }
        }
        this.generategui(this.width, this.height);
    }

    public void setListWidth() {
        if (this.so.showlist) {
            Enumeration enumeration = this.so.list.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n2 = this.FONT_NAMELIST.stringWidth(string);
                if (n2 <= n) continue;
                n = n2;
            }
            if ((n += 5) != this.list_width) {
                this.list_width = n;
                this.refreshGuiParameters();
            }
        }
    }
}

