/*
 * Decompiled with CFR 0.152.
 */
package inettools;

import inettools.Images;
import inettools.Irc;
import inettools.Resources;
import inettools.TextArea;
import inettools.UIHandler;
import inettools.WindowListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import lib.GraphicControls.MessageBox;
import lib.Utils.Utils;

public class Window
extends Canvas
implements CommandListener {
    public static final int TYPE_CONSOLE = 0;
    public static final int TYPE_CHANNEL = 1;
    public static final int TYPE_PRIVATE = 2;
    public static final int STATE_NONE = 0;
    public static final int STATE_INFO = 1;
    public static final int STATE_MSG = 2;
    public static final int STATE_HILIGHT = 3;
    public static final int STATE_SELECTED = 4;
    public static final char MODE_NONE = '\u0000';
    public static final char MODE_VOICE = '\u0001';
    public static final char MODE_HALFOP = '\u0002';
    public static final char MODE_OP = '\u0004';
    private WindowListener wl;
    public MessageBox mb;
    private int type;
    private int state;
    private UIHandler uihandler;
    private Vector names;
    private Display display;
    public static TextBox textbox;
    private Form favform;
    private Form optionsform;
    private Form colmsgform;
    private Form stylesform;
    private Command cmd_msg;
    private Command cmd_join;
    private Command cmd_query;
    private Command cmd_favourites;
    private Command cmd_traffic;
    private Command cmd_disconnect;
    private Command cmd_saveoptions;
    public Command cmd_closeconsole;
    public Command cmd_closenamfav;
    public Command cmd_applystyle;
    public Command cmd_menu;
    public Command cmd_smiles;
    public Command cmd_textboxmenu;
    private Command cmd_delfav;
    private Command cmd_sendfav;
    private Command cmd_addnewfav;
    private Command cmd_options;
    private Command cmd_styles;
    private Command cmd_commands;
    private Command cmd_colmsg;
    private Command cmd_addcol;
    private Command cmd_textoptions;
    private Command cmd_addslap;
    private Command cmd_editslap;
    private Command cmd_delslap;
    private Command cmd_close;
    private Command cmd_whois;
    private Command cmd_names;
    private Command cmd_cancel;
    private Command cmd_send;
    private Command cmd_ok;
    private ChoiceGroup cg_favourites;
    private ChoiceGroup cg_options;
    private ChoiceGroup cg_colmsg;
    private ChoiceGroup cg_colmsgfone;
    private ChoiceGroup cg_styles;
    public String name;
    public String header;
    public String chansize;
    public String topic = " ";
    private long keylocktime;
    private int height_diff;
    private int buflines;
    private boolean timestamp;
    private TextArea textarea;
    private boolean showheader;
    private boolean usecol;
    private boolean smiles;
    private boolean vibra;
    private boolean sound;
    private int fontsize;
    private int width;
    private int height;
    private static final int MAX_LIST_PERSONS = 20;
    private int person_position = 0;
    private List nameslist;
    private List namecmdlist;
    private List commandslist;
    private List textoptionslist;
    private List menulist;
    private List textboxmenu;
    private List usermanagmentmenu;
    private List ctcpmenu;
    private List slapslist;
    String textstyle = "";
    private Command cmd_paste;
    private boolean[] notification;
    private Smiles sml;
    private boolean showtime;

    public Window(UIHandler uIHandler, String string, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, boolean[] blArray, boolean bl4, WindowListener windowListener) {
        this.setFullScreenMode(true);
        if (n == 0) {
            this.width = this.getWidth();
            this.height = this.getHeight() + n2;
        } else {
            this.width = uIHandler.getConsole().width;
            this.height = uIHandler.getConsole().height;
        }
        this.uihandler = uIHandler;
        this.name = string;
        this.header = string;
        this.chansize = "";
        this.type = n;
        this.timestamp = bl2;
        this.usecol = bl3;
        this.smiles = bl;
        this.height_diff = n2;
        this.buflines = n3;
        this.fontsize = n4;
        this.notification = blArray;
        this.showtime = bl4;
        this.wl = windowListener;
        if (uIHandler.ti == null) {
            uIHandler.ti = Image.createImage((int)this.width, (int)this.height);
            uIHandler.tg = uIHandler.ti.getGraphics();
        }
        this.state = 0;
        this.textarea = new TextArea(this.width - 2, this.height - 7 - Font.getFont((int)64, (int)0, (int)8).getHeight(), n4, 1, n3, uIHandler);
        this.names = new Vector();
        this.cmd_ok = new Command(Irc.language.get("ok"), 4, 10);
        this.cmd_send = new Command(Irc.language.get("send"), 4, 10);
        this.cmd_paste = new Command(Irc.language.get("paste"), 1, 20);
        this.cmd_smiles = new Command(Irc.language.get("smiles"), 1, 20);
        this.cmd_colmsg = new Command(Irc.language.get("colors"), 1, 30);
        this.cmd_styles = new Command(Irc.language.get("styles"), 1, 40);
        this.cmd_textboxmenu = new Command(Irc.language.get("menu"), 8, 100);
        this.cmd_cancel = new Command(Irc.language.get("cancel"), 1, 50);
        this.cmd_menu = new Command(Irc.language.get("menu"), 1, 20);
        this.cmd_applystyle = new Command(Irc.language.get("apply"), 4, 10);
        this.cmd_saveoptions = new Command(Irc.language.get("save"), 4, 10);
        this.cmd_msg = new Command(Irc.language.get("message"), 4, 10);
        this.cmd_favourites = new Command(Irc.language.get("favourites"), 1, 50);
        this.cmd_addslap = new Command(Irc.language.get("addslap"), 1, 50);
        this.cmd_editslap = new Command(Irc.language.get("editslap"), 1, 50);
        this.cmd_delslap = new Command(Irc.language.get("delslap"), 1, 50);
        this.cmd_traffic = new Command(Irc.language.get("traffic"), 1, 50);
        this.cmd_disconnect = new Command(Irc.language.get("disconnect"), 1, 90);
        this.cmd_close = new Command(Irc.language.get("close"), 1, 65);
        this.cmd_whois = new Command("Whois", 1, 35);
        this.cmd_names = new Command(Irc.language.get("userslist"), 1, 35);
        this.cmd_sendfav = new Command(Irc.language.get("send"), 4, 10);
        this.cmd_addnewfav = new Command(Irc.language.get("addfavourite"), 1, 30);
        this.cmd_delfav = new Command(Irc.language.get("deletefavourite"), 1, 40);
        this.cmd_closeconsole = new Command(Irc.language.get("close"), 3, 10);
        this.cmd_closenamfav = new Command(Irc.language.get("close"), 3, 90);
        this.cmd_addcol = new Command(Irc.language.get("addcolor"), 4, 10);
        this.cmd_options = new Command(Irc.language.get("settings"), 1, 30);
        this.cmd_commands = new Command(Irc.language.get("commands"), 1, 40);
        this.cmd_join = new Command(Irc.language.get("joinchannel"), 1, 20);
        this.cmd_query = new Command(Irc.language.get("query"), 1, 30);
        this.cmd_textoptions = new Command(Irc.language.get("textoptions"), 1, 30);
        this.setCommandListener(this);
        this.sml = new Smiles(this.width, this.height);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void nickChangeAction() {
        textbox = new TextBox(Irc.language.get("changenickaction"), "", 50, 0);
        textbox.setCommandListener((CommandListener)new TextboxListener());
        textbox.addCommand(this.cmd_ok);
        this.uihandler.setWinlock(true);
        this.uihandler.setDisplay((Displayable)textbox);
    }

    private void updateHeader() {
        this.chansize = " [" + this.names.size() + "]";
    }

    private void show() {
        this.setFullScreenMode(true);
        this.uihandler.setDisplay((Displayable)this);
        this.repaint();
        System.gc();
    }

    public void clear() {
        this.textarea.clear();
        System.gc();
    }

    public void enterExitMode() {
        this.addCommand(this.cmd_closeconsole);
    }

    public void close() {
        this.uihandler.deleteWindow(this);
    }

    public void handleMsg(String string) {
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '/') {
                String[] stringArray = Utils.splitString(string, " ");
                String string2 = stringArray[0].toUpperCase();
                if (string2.equals("/MSG")) {
                    if (stringArray.length > 2) {
                        Irc.writeLine("PRIVMSG " + stringArray[1] + " :" + string.substring(6 + stringArray[1].length()));
                        Window window = Utils.isChannel(stringArray[1]) ? this.uihandler.getChannel(stringArray[1]) : this.uihandler.getPrivate(stringArray[1]);
                        window.write(UIHandler.nick, string.substring(6 + stringArray[1].length()));
                        textbox = null;
                        window.show();
                        return;
                    }
                } else if (string2.equals("/ME")) {
                    Irc.writeLine("PRIVMSG " + this.name + " :\u0001ACTION " + string.substring(4) + "\u0001");
                    this.writeAction("* " + UIHandler.nick + " " + string.substring(4));
                    if (this.notification[6]) {
                        if (this.notification[1]) {
                            Resources.playAction();
                        }
                        if (this.notification[2]) {
                            Resources.LCDFlash();
                        }
                        if (this.notification[0]) {
                            Resources.vibrate();
                        }
                    }
                } else if (string2.equals("/LIST")) {
                    Irc.writeLine("LIST");
                    this.writeAction("* " + Irc.language.get("gettingchannelslist"));
                } else if (string2.equals("/RAW")) {
                    Irc.writeLine(string.substring(5));
                    this.uihandler.getConsole().write("rawcmd", string.substring(5));
                } else if (string2.equals("/WII")) {
                    Irc.writeLine("WHOIS " + stringArray[1] + " " + stringArray[1]);
                } else if (string2.equals("/NICK")) {
                    Irc.writeLine("NICK " + stringArray[1]);
                    UIHandler.nick = stringArray[1];
                } else if (string2.equals("/TOPIC")) {
                    if (this.type == 1) {
                        Irc.writeLine("TOPIC " + this.name + " :" + string.substring(7));
                    }
                } else if (string2.equals("/CTCP")) {
                    Irc.writeLine("PRIVMSG " + stringArray[1] + " :\u0001" + stringArray[2] + "\u0001");
                } else if (string2.equals("/PART")) {
                    if (Utils.isChannel(stringArray[1])) {
                        Irc.writeLine("PART " + stringArray[1] + " :" + string.substring(7 + stringArray[1].length()));
                    } else {
                        Irc.writeLine("PART " + this.name + " :" + string.substring(6));
                    }
                } else if (string2.equals("/QUIT")) {
                    Irc.disconnect("QUIT :" + string.substring(6));
                } else {
                    Irc.writeLine(string.substring(1));
                    this.uihandler.getConsole().writeInfo(string.substring(1));
                }
            } else if (this.type != 0) {
                Irc.writeLine("PRIVMSG " + this.name + " :" + string);
                this.write(UIHandler.nick, string);
            }
        }
        textbox = null;
        this.show();
    }

    public void write(String string, String string2) {
        int n;
        if (this.notification[3] && !this.name.startsWith("#")) {
            if (this.notification[1]) {
                Resources.playMsg();
            }
            if (this.notification[2]) {
                Resources.LCDFlash();
            }
            if (this.notification[0]) {
                Resources.vibrate();
            }
        }
        if (this.timestamp) {
            Calendar calendar = Calendar.getInstance();
            this.textarea.addText("[" + calendar.get(11) + ":" + (calendar.get(12) < 10 ? "0" : "") + calendar.get(12) + ":" + (calendar.get(13) < 10 ? "0" : "") + calendar.get(13) + "]", 0x999999, 0xFFFFFF, 0, 8);
            n = this.textarea.items.size() - 1;
        } else {
            n = this.textarea.items.size();
        }
        if (string2.indexOf(UIHandler.nick) > -1) {
            if (this.usecol) {
                this.textarea.addIRCText(string + "> " + string2, 170, 0xFFFFFF, 0, this.fontsize, n, this.smiles);
            } else if (this.smiles) {
                this.uihandler.emotions.addTextWithSmiles(this.textarea, string + "> " + string2, 170, 0xFFFFFF, 0, this.fontsize, n);
            } else {
                this.textarea.addTextWithURL(string + "> " + string2, 170, 0xFFFFFF, 0, this.fontsize, n);
            }
            if (this.textarea.currentItem >= this.textarea.items.size() - 4) {
                this.textarea.end();
            }
            if (this.state < 3) {
                this.state = 3;
            }
            if (this.uihandler.keylock) {
                this.uihandler.playAlarm(false);
            }
            if (this.notification[4]) {
                if (this.notification[1]) {
                    Resources.playInfo();
                }
                if (this.notification[2]) {
                    Resources.LCDFlash();
                }
                if (this.notification[0]) {
                    Resources.vibrate();
                }
            }
        } else {
            if (this.usecol) {
                this.textarea.addIRCText(string + "> ", 170, 0xFFFFFF, 0, this.fontsize, n, this.smiles);
                this.textarea.addIRCText(string2, n, this.smiles);
            } else if (this.smiles) {
                this.uihandler.emotions.addTextWithSmiles(this.textarea, string + "> ", 170, 0xFFFFFF, 0, this.fontsize, n);
                this.uihandler.emotions.addTextWithSmiles(this.textarea, string2, 0, 0xFFFFFF, 0, this.fontsize, n);
            } else {
                this.textarea.addText(string + "> ", 170, 0xFFFFFF, 0, this.fontsize, n);
                this.textarea.addTextWithURL(string2, 0, 0xFFFFFF, 0, this.fontsize, n);
            }
            if (this.textarea.currentItem >= this.textarea.items.size() - 4) {
                this.textarea.end();
            }
            this.state = 2;
        }
        this.textarea.buffer();
        this.repaint();
    }

    public void writeAction(String string) {
        int n;
        if (this.timestamp) {
            Calendar calendar = Calendar.getInstance();
            this.textarea.addText("[" + calendar.get(11) + ":" + (calendar.get(12) < 10 ? "0" : "") + calendar.get(12) + ":" + (calendar.get(13) < 10 ? "0" : "") + calendar.get(13) + "]", 0x999999, 0xFFFFFF, 0, 8);
            n = this.textarea.items.size() - 1;
        } else {
            n = this.textarea.items.size();
        }
        if (this.usecol) {
            this.textarea.addIRCText(string, 170, 0xFFFFFF, 0, this.fontsize, n, this.smiles);
        } else if (this.smiles) {
            this.uihandler.emotions.addTextWithSmiles(this.textarea, string, 170, 0xFFFFFF, 0, this.fontsize, n);
        } else {
            this.textarea.addTextWithURL(string, 170, 0xFFFFFF, 0, this.fontsize, n);
        }
        if (this.textarea.currentItem >= this.textarea.items.size() - 4) {
            this.textarea.end();
        }
        if (this.state < 1) {
            this.state = 1;
        }
        this.textarea.buffer();
        this.repaint();
    }

    public void writeInfo(String string) {
        int n;
        if (this.timestamp) {
            Calendar calendar = Calendar.getInstance();
            this.textarea.addText("[" + calendar.get(11) + ":" + (calendar.get(12) < 10 ? "0" : "") + calendar.get(12) + ":" + (calendar.get(13) < 10 ? "0" : "") + calendar.get(13) + "]", 0x999999, 0xFFFFFF, 0, 8);
            n = this.textarea.items.size() - 1;
        } else {
            n = this.textarea.items.size();
        }
        if (this.usecol) {
            this.textarea.addIRCText("*** " + string, 53760, 0xFFFFFF, 0, this.fontsize, n, this.smiles);
        } else if (this.smiles) {
            this.uihandler.emotions.addTextWithSmiles(this.textarea, "*** " + string, 53760, 0xFFFFFF, 0, this.fontsize, n);
        } else {
            this.textarea.addTextWithURL("*** " + string, 53760, 0xFFFFFF, 0, this.fontsize, n);
        }
        if (this.textarea.currentItem >= this.textarea.items.size() - 4) {
            this.textarea.end();
        }
        if (this.state < 1) {
            this.state = 1;
        }
        this.textarea.buffer();
        this.repaint();
    }

    public void addNick(char c, String string) {
        int n;
        int n2 = this.names.size();
        String string2 = string.toUpperCase();
        if (UIHandler.nick.toUpperCase().equals(string.toUpperCase())) {
            UIHandler.nickMode = c;
        }
        for (n = 0; n < n2; ++n) {
            String string3 = (String)this.names.elementAt(n);
            if (string3.charAt(0) > c || string2.compareTo(string3.substring(1).toUpperCase()) >= 1 && string3.charAt(0) >= c) continue;
            this.names.insertElementAt(c + string, n);
            break;
        }
        if (n == n2) {
            this.names.addElement(c + string);
        }
        this.updateHeader();
    }

    public boolean hasNick(String string) {
        return this.getNickIndex(string) >= 0;
    }

    public void changeNick(String string, String string2) {
        int n;
        if (this.name.equals(string)) {
            this.name = string2;
        }
        if ((n = this.getNickIndex(string)) >= 0) {
            char c = ((String)this.names.elementAt(n)).charAt(0);
            this.deleteNick(string);
            this.addNick(c, string2);
        }
    }

    public void changeMode(char c, String string, boolean bl) {
        int n = this.getNickIndex(string);
        if (n >= 0) {
            char c2 = ((String)this.names.elementAt(n)).charAt(0);
            this.deleteNick(string);
            if (bl) {
                this.addNick((char)(c2 | c), string);
            } else {
                this.addNick((char)(c2 & ~c), string);
            }
        }
    }

    public void deleteNick(String string) {
        int n = this.getNickIndex(string);
        if (n >= 0) {
            this.names.removeElementAt(n);
            this.updateHeader();
        }
    }

    public void deleteAllNicks() {
        this.names.removeAllElements();
    }

    public void printNicks() {
        if (this.names.size() > 10) {
            this.writeInfo(Irc.language.get("usersonchannel") + ": " + this.names.size());
        } else {
            String string = "";
            Enumeration enumeration = this.names.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                int n = string2.charAt(0) == '\u0004' ? 64 : (string2.charAt(0) == '\u0002' ? 37 : (string2.charAt(0) == '\u0001' ? 43 : 32));
                string = string + (char)n + string2.substring(1);
                if (!enumeration.hasMoreElements()) continue;
                string = string + ", ";
            }
            this.writeInfo(Irc.language.get("users") + ": " + string);
        }
    }

    private int getNickIndex(String string) {
        int n = this.names.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.names.elementAt(i);
            if (!string2.substring(1).equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void listnames(Command command, Displayable displayable) {
        this.nameslist = new List(Irc.language.get("users"), 3);
        if (this.name.equals(Irc.language.get("channelslist"))) {
            this.nameslist.setTitle(Irc.language.get("channelslist"));
        }
        int n = (this.person_position + 1) * 20;
        if (this.person_position > 0) {
            this.nameslist.append("[" + Irc.language.get("previous") + "]", Images.icons.getImage(0));
        }
        if (this.names.size() > n) {
            this.nameslist.append("[" + Irc.language.get("next") + "]", Images.icons.getImage(0));
        }
        for (int i = this.person_position * 20; i < n && i < this.names.size(); ++i) {
            String string = (String)this.names.elementAt(i);
            if (string.charAt(0) == '\u0004') {
                this.nameslist.append(string.substring(1), Images.icons.getImage(1));
                continue;
            }
            if (string.charAt(0) == '\u0002') {
                this.nameslist.append(string.substring(1), Images.icons.getImage(2));
                continue;
            }
            if (string.charAt(0) == '\u0001') {
                this.nameslist.append(string.substring(1), Images.icons.getImage(3));
                continue;
            }
            this.nameslist.append(string.substring(1), Images.icons.getImage(4));
        }
        this.nameslist.addCommand(this.cmd_closenamfav);
        this.nameslist.setCommandListener((CommandListener)this);
        this.uihandler.setDisplay((Displayable)this.nameslist);
    }

    private void paintAllOnGraphics(Graphics graphics) {
        int n;
        int n2;
        Font font = Font.getFont((int)0, (int)1, (int)8);
        graphics.setClip(0, 0, this.uihandler.ti.getWidth(), this.uihandler.ti.getHeight());
        graphics.setColor(100, 140, 100);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(10, 10, 10);
        graphics.drawLine(this.width - 10, this.height - 5, this.width - 4, this.height - 5);
        graphics.drawLine(this.width - 9, this.height - 4, this.width - 5, this.height - 4);
        graphics.drawLine(this.width - 8, this.height - 3, this.width - 6, this.height - 3);
        graphics.drawLine(this.width - 7, this.height - 2, this.width - 7, this.height - 2);
        graphics.drawLine(3, this.height - 6, 10, this.height - 6);
        graphics.drawLine(3, this.height - 2, 10, this.height - 2);
        graphics.drawLine(3, this.height - 6, 3, this.height - 2);
        graphics.drawLine(10, this.height - 6, 10, this.height - 2);
        graphics.drawLine(3, this.height - 6, 6, this.height - 3);
        graphics.drawLine(7, this.height - 3, 10, this.height - 6);
        int[] nArray = this.uihandler.getIndicators();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            switch (nArray[n2]) {
                case 0: {
                    graphics.setColor(255, 255, 255);
                    break;
                }
                case 1: {
                    graphics.setColor(170, 170, 170);
                    break;
                }
                case 2: {
                    graphics.setColor(170, 0, 170);
                    break;
                }
                case 3: {
                    graphics.setColor(170, 0, 0);
                    break;
                }
                case 4: {
                    graphics.setColor(0, 0, 0);
                }
            }
            graphics.fillRect(15 + n2 * 6, this.height - 6, 5, 5);
        }
        int n3 = 0;
        if (this.showtime) {
            Utils.drawFramedText(graphics, font, Utils.getTime(), 2, 0, 0xFFFFFF, 0);
            n3 = font.stringWidth(Utils.getTime()) + 4;
        }
        graphics.setFont(font);
        graphics.setColor(0);
        if (font.stringWidth(this.header + this.chansize + n3) < this.width - 5) {
            graphics.drawString(this.header + this.chansize, 2 + n3, 0, 20);
        } else {
            n = this.width - 5 - n3 - font.stringWidth(this.chansize);
            n -= font.stringWidth(".." + this.header.substring(this.header.length() - 2));
            for (n2 = this.header.length() - 3; n2 >= 0 && font.substringWidth(this.header, 0, n2) > n; --n2) {
            }
            graphics.drawString(this.header.substring(0, n2) + ".." + this.header.substring(this.header.length() - 2) + this.chansize, 2 + n3, 0, 20);
        }
        this.textarea.paint(graphics, 1, font.getHeight());
        if (this.uihandler.keylock) {
            Resources.LCDOff();
            graphics.setColor(80, 80, 80);
            for (n = 0; n < 2 * this.height; n += 2) {
                graphics.drawLine(n - this.height, 0, n, this.height);
            }
            graphics.drawImage(Images.icons.getImage(5), this.width - 15, this.height - 15, 20);
            Font font2 = Font.getFont((int)0, (int)1, (int)16);
            Utils.drawFramedText(graphics, font2, Utils.getTime(), this.width / 2 - font2.stringWidth(Utils.getTime()) / 2, this.height - 30 - (font2.getHeight() - Images.icons.getHeight()) / 2, 0xFFFFFF, 0);
        }
    }

    public void paint(Graphics graphics) {
        this.paintAllOnGraphics(this.uihandler.tg);
        graphics.drawImage(this.uihandler.ti, 0, 0, 20);
    }

    protected void keyReleased(int n) {
        if (n == 35) {
            if (System.currentTimeMillis() - this.keylocktime >= 1000L) {
                if (!this.uihandler.keylock) {
                    Alert alert = new Alert(Irc.language.get("info"), Irc.language.get("keyboardblocked"), null, AlertType.INFO);
                    alert.setTimeout(1000);
                    this.uihandler.setDisplay((Displayable)alert);
                    this.uihandler.setWinlock(true);
                } else {
                    Alert alert = new Alert(Irc.language.get("info"), Irc.language.get("keyboardunblocked"), null, AlertType.INFO);
                    alert.setTimeout(1000);
                    this.uihandler.setDisplay((Displayable)alert);
                    this.uihandler.setWinlock(false);
                }
                this.uihandler.keylock = !this.uihandler.keylock;
                this.keylocktime = 0L;
                this.repaint();
                return;
            }
            this.commandAction(this.cmd_menu, null);
        }
    }

    protected void keyPressed(int n) {
        if (n == 35) {
            this.keylocktime = System.currentTimeMillis();
            if (!this.uihandler.keylock) {
                Irc.forceUpdate();
            } else {
                Resources.LCDOff();
            }
            return;
        }
        this.keylocktime = 0L;
        if (this.uihandler.keylock) {
            Resources.LCDOff();
        } else if (n >= 97 && n <= 122 || n >= 65 && n <= 90) {
            textbox = new TextBox(Irc.language.get("message"), null, 512, 0);
            textbox.insert("" + (char)n, 0);
            textbox.setCommandListener((CommandListener)new TextboxListener());
            textbox.addCommand(this.cmd_send);
            if (UIHandler.message != null) {
                textbox.addCommand(this.cmd_paste);
            }
            textbox.addCommand(this.cmd_smiles);
            textbox.addCommand(this.cmd_colmsg);
            textbox.addCommand(this.cmd_styles);
            textbox.addCommand(this.cmd_cancel);
            this.uihandler.setWinlock(true);
            this.uihandler.setDisplay((Displayable)textbox);
        } else if (n == 137) {
            this.commandAction(this.cmd_msg, null);
        } else if (n == -13 || this.getGameAction(n) == 1 || n == 50) {
            this.textarea.up();
            this.repaint();
        } else if (n == -14 || this.getGameAction(n) == 6 || n == 56) {
            this.textarea.down();
            this.repaint();
        } else if (n == 52 || this.getGameAction(n) == 2) {
            this.uihandler.displayPreviousWindow();
        } else if (n == 54 || this.getGameAction(n) == 5) {
            this.uihandler.displayNextWindow();
        } else if (n == 49) {
            this.textarea.home();
            this.repaint();
        } else if (n == 55) {
            this.textarea.end();
            this.repaint();
        } else if (n == 51) {
            this.textarea.pageUp();
            this.repaint();
        } else if (n == 57) {
            this.textarea.pageDown();
            this.repaint();
        } else if (!this.uihandler.keylock && n == -7 || n == 35 || n == -4) {
            this.commandAction(this.cmd_menu, null);
        } else if (!this.uihandler.keylock && n == -6 || this.getGameAction(n) == 8 || n == 42 || n == -1) {
            this.commandAction(this.cmd_msg, null);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n >= this.width - 17 & n <= this.width & n2 >= this.height - 10 & n2 <= this.height) {
            this.commandAction(this.cmd_menu, null);
        } else if (n >= 0 & n <= 17 & n2 >= this.height - 10 & n2 <= this.height) {
            this.commandAction(this.cmd_msg, null);
        } else if (n >= 18 & n <= 28 & n2 >= this.height - 10 & n2 <= this.height) {
            this.uihandler.displayPreviousWindow();
        } else if (n >= this.width - 27 & n <= this.width - 18 & n2 >= this.height - 10 & n2 <= this.height) {
            this.uihandler.displayNextWindow();
        } else if (n >= this.width - 10 & n <= this.width & n2 >= 5 & n2 <= 20) {
            this.textarea.up();
            this.repaint();
        } else if (n >= this.width - 10 & n <= this.width & n2 >= this.height - 25 & n2 <= this.height - 11) {
            this.textarea.down();
            this.repaint();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmd_msg) {
            textbox = new TextBox(Irc.language.get("message"), null, 5000, 0);
            textbox.addCommand(this.cmd_send);
            if (UIHandler.message != null) {
                textbox.addCommand(this.cmd_paste);
            }
            textbox.addCommand(this.cmd_smiles);
            textbox.addCommand(this.cmd_colmsg);
            textbox.addCommand(this.cmd_styles);
            textbox.addCommand(this.cmd_cancel);
            textbox.setCommandListener((CommandListener)new TextboxListener());
            this.uihandler.setWinlock(true);
            this.uihandler.setDisplay((Displayable)textbox);
        } else if (command == this.cmd_menu) {
            this.setFullScreenMode(false);
            this.menulist = new List(Irc.language.get("menu"), 3);
            if (this.type == 2) {
                this.menulist.append("Whois", Images.icons.getImage(0));
            }
            if (this.type == 1) {
                if (this.name.indexOf(Irc.language.get("channelslist")) > -1) {
                    this.menulist.append(Irc.language.get("channelslist"), Images.icons.getImage(0));
                } else {
                    this.menulist.append(Irc.language.get("userslist"), Images.icons.getImage(0));
                }
            }
            this.menulist.append(Irc.language.get("textoptions"), Images.icons.getImage(0));
            this.menulist.append(Irc.language.get("commands"), Images.icons.getImage(0));
            this.menulist.append(Irc.language.get("favourite"), Images.icons.getImage(0));
            this.menulist.append(Irc.language.get("backgroundmode"), Images.icons.getImage(0));
            this.menulist.append(Irc.language.get("traffic"), Images.icons.getImage(0));
            if (this.type == 2 || this.type == 1) {
                this.menulist.append(Irc.language.get("wndclear"), Images.icons.getImage(0));
                this.menulist.append(Irc.language.get("wndclose"), Images.icons.getImage(0));
            }
            this.menulist.append(Irc.language.get("disconnect"), Images.icons.getImage(0));
            this.menulist.addCommand(this.cmd_closenamfav);
            this.menulist.setCommandListener((CommandListener)this);
            this.uihandler.setDisplay((Displayable)this.menulist);
        } else if (this.menulist != null && command == List.SELECT_COMMAND) {
            String string = this.menulist.getString(this.menulist.getSelectedIndex());
            if (string.equals("Whois")) {
                this.commandAction(this.cmd_whois, null);
                this.menulist = null;
            } else if (string.equals(Irc.language.get("userslist")) | string.indexOf(Irc.language.get("channelslist")) > -1) {
                this.commandAction(this.cmd_names, null);
                this.menulist = null;
            } else if (string.equals(Irc.language.get("textoptions"))) {
                this.commandAction(this.cmd_textoptions, null);
                this.menulist = null;
            } else if (string.equals(Irc.language.get("backgroundmode"))) {
                Irc.lastDisplay = this;
                Irc.minimized = true;
                this.uihandler.setDisplay(null);
            } else if (string.equals(Irc.language.get("wndoptions"))) {
                this.commandAction(this.cmd_options, null);
                this.menulist = null;
            } else if (string.equals(Irc.language.get("favourite"))) {
                this.commandAction(this.cmd_favourites, null);
                this.menulist = null;
            } else if (string.equals(Irc.language.get("traffic"))) {
                this.commandAction(this.cmd_traffic, null);
                this.menulist = null;
            } else if (string.equals(Irc.language.get("commands"))) {
                this.commandAction(this.cmd_commands, null);
                this.menulist = null;
            } else if (string.equals(Irc.language.get("wndclear"))) {
                this.menulist = null;
                this.clear();
                this.show();
            } else if (string.equals(Irc.language.get("wndclose"))) {
                this.commandAction(this.cmd_close, null);
                this.menulist = null;
            } else if (string.equals(Irc.language.get("disconnect"))) {
                this.commandAction(this.cmd_disconnect, null);
                this.menulist = null;
            }
        } else if (command == this.cmd_disconnect) {
            Irc.disconnect("QUIT : " + Irc.QUIT_MESSAGE);
            this.uihandler.clearChanPriv();
            this.uihandler.cleanup();
        } else if (command == this.cmd_closeconsole) {
            this.uihandler.cleanup();
        } else if (command == this.cmd_traffic) {
            String string = Irc.language.get("input") + Utils.getKBytes(Irc.getBytesIn()) + " " + Irc.language.get("kb") + "\n";
            string = string + Irc.language.get("output") + Utils.getKBytes(Irc.getBytesOut()) + " " + Irc.language.get("kb") + "\n";
            string = string + Irc.language.get("common") + Utils.getKBytes(Irc.getBytesOut() + Irc.getBytesIn()) + " " + Irc.language.get("kb");
            this.commandAction(this.cmd_closenamfav, null);
            this.mb = new MessageBox(this.uihandler.getDisplay(), (Displayable)this, Irc.language.get("traffic"), string, 1, this.fontsize, this.height_diff);
            this.mb.show();
        } else if (command == this.cmd_textoptions) {
            this.textoptionslist = new List(Irc.language.get("textoptions"), 3);
            if (this.textarea.getItemType(this.textarea.currentItem) == 1) {
                this.textoptionslist.append(Irc.language.get("openURL"), Images.icons.getImage(0));
            }
            this.textoptionslist.append(Irc.language.get("quote"), Images.icons.getImage(0));
            this.textoptionslist.append(Irc.language.get("copy"), Images.icons.getImage(0));
            this.textoptionslist.append(Irc.language.get("addtocopyed"), Images.icons.getImage(0));
            this.textoptionslist.append(Irc.language.get("savetofavourite"), Images.icons.getImage(0));
            this.textoptionslist.append(Irc.language.get("clearbuffer"), Images.icons.getImage(0));
            this.textoptionslist.addCommand(this.cmd_closenamfav);
            this.textoptionslist.setCommandListener((CommandListener)this);
            this.uihandler.setDisplay((Displayable)this.textoptionslist);
        } else if (this.textoptionslist != null && command == List.SELECT_COMMAND) {
            String string = this.textoptionslist.getString(this.textoptionslist.getSelectedIndex());
            if (string.equals(Irc.language.get("quote"))) {
                textbox = new TextBox(Irc.language.get("message"), "\"\u000315,0\u0002 " + this.textarea.getSelectedMessage() + "\u0003\u0002\"  ", 1000, 0);
                textbox.addCommand(this.cmd_send);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)textbox);
            } else if (string.equals(Irc.language.get("openURL"))) {
                this.wl.onUrlSelect(this, this.textarea.getSelectedMessage());
                this.show();
            } else if (string.equals(Irc.language.get("copy"))) {
                UIHandler.message = this.textarea.getSelectedMessage();
                this.show();
            } else if (string.equals(Irc.language.get("addtocopyed"))) {
                UIHandler.message = UIHandler.message + this.textarea.getSelectedMessage();
                this.show();
            } else if (string.equals(Irc.language.get("savetofavourite"))) {
                this.uihandler.addFav(this.textarea.getSelectedMessage());
                this.uihandler.saveFavs();
                this.show();
            } else if (string.equals(Irc.language.get("clearbuffer"))) {
                UIHandler.message = "";
                this.show();
            }
            this.textoptionslist = null;
        } else if (command == this.cmd_commands) {
            this.commandslist = new List(Irc.language.get("commands"), 3);
            this.commandslist.append(Irc.language.get("action"), Images.icons.getImage(0));
            this.commandslist.append(Irc.language.get("allaction"), Images.icons.getImage(0));
            this.commandslist.append(Irc.language.get("joinchannel"), Images.icons.getImage(0));
            this.commandslist.append(Irc.language.get("query"), Images.icons.getImage(0));
            this.commandslist.append(Irc.language.get("changenickaction"), Images.icons.getImage(0));
            this.commandslist.append(Irc.language.get("channelslist"), Images.icons.getImage(0));
            this.commandslist.append(Irc.language.get("changetopicaction"), Images.icons.getImage(0));
            this.commandslist.addCommand(this.cmd_closenamfav);
            this.commandslist.setCommandListener((CommandListener)this);
            this.uihandler.setDisplay((Displayable)this.commandslist);
        } else if (this.commandslist != null && command == List.SELECT_COMMAND) {
            String string = this.commandslist.getString(this.commandslist.getSelectedIndex());
            if (string.equals(Irc.language.get("joinchannel"))) {
                textbox = new TextBox(Irc.language.get("joinchannel"), "", 50, 0);
                textbox.addCommand(this.cmd_ok);
                textbox.addCommand(this.cmd_cancel);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)textbox);
            } else if (string.equals(Irc.language.get("query"))) {
                textbox = new TextBox(Irc.language.get("query"), "", 50, 0);
                textbox.addCommand(this.cmd_ok);
                textbox.addCommand(this.cmd_cancel);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)textbox);
            } else if (string.equals(Irc.language.get("action"))) {
                textbox = new TextBox(Irc.language.get("action"), "", 1000, 0);
                textbox.addCommand(this.cmd_ok);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)textbox);
            } else if (string.equals(Irc.language.get("allaction"))) {
                textbox = new TextBox(Irc.language.get("allaction"), "", 1000, 0);
                textbox.addCommand(this.cmd_ok);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)textbox);
            } else if (string.equals(Irc.language.get("channelslist"))) {
                Irc.writeLine("LIST");
                this.show();
            } else if (string.equals(Irc.language.get("changenickaction"))) {
                textbox = new TextBox(Irc.language.get("changenickaction"), "", 50, 0);
                textbox.addCommand(this.cmd_ok);
                textbox.addCommand(this.cmd_cancel);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)textbox);
            } else if (string.equals(Irc.language.get("changetopicaction"))) {
                textbox = new TextBox(Irc.language.get("changetopicaction"), this.topic, 1000, 0);
                textbox.addCommand(this.cmd_ok);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)textbox);
            }
            this.commandslist = null;
        } else if (command == this.cmd_options) {
            this.cg_options = new ChoiceGroup(null, 2);
            this.cg_options.append(Irc.language.get("vibra"), null);
            this.cg_options.append(Irc.language.get("sounds"), null);
            this.cg_options.append(Irc.language.get("timestamp"), null);
            this.cg_options.append(Irc.language.get("colors") + ", " + Irc.language.get("styles"), null);
            this.cg_options.setSelectedIndex(0, this.vibra);
            this.cg_options.setSelectedIndex(1, this.sound);
            this.cg_options.setSelectedIndex(2, this.timestamp);
            this.cg_options.setSelectedIndex(3, this.usecol);
            this.optionsform = new Form(Irc.language.get("wndoptions"));
            this.optionsform.append((Item)this.cg_options);
            this.optionsform.addCommand(this.cmd_saveoptions);
            this.optionsform.setCommandListener((CommandListener)this);
            this.uihandler.setWinlock(false);
            this.uihandler.setDisplay((Displayable)this.optionsform);
        } else if (command == this.cmd_saveoptions) {
            this.vibra = this.cg_options.isSelected(0);
            this.sound = this.cg_options.isSelected(1);
            this.timestamp = this.cg_options.isSelected(2);
            this.usecol = this.cg_options.isSelected(3);
            this.optionsform = null;
            this.show();
        } else if (command == this.cmd_names) {
            this.listnames(command, displayable);
        } else if (command == this.cmd_whois) {
            Irc.writeLine("WHOIS " + this.name);
            this.namecmdlist = null;
            this.show();
        } else if (command == this.cmd_close) {
            if (this.type == 1) {
                Irc.writeLine("PART " + this.name);
            }
            this.close();
        } else if (command == this.cmd_closenamfav) {
            this.nameslist = null;
            this.cg_favourites = null;
            this.menulist = null;
            this.textoptionslist = null;
            this.commandslist = null;
            this.favform = null;
            this.uihandler.setWinlock(false);
            this.show();
        } else if (command == this.cmd_favourites) {
            this.favform = new Form(Irc.language.get("favourite"));
            Vector vector = this.uihandler.getFavs();
            this.cg_favourites = new ChoiceGroup(Irc.language.get("favourite"), 2);
            for (int i = 0; i < vector.size(); ++i) {
                this.cg_favourites.append((String)vector.elementAt(i), null);
            }
            this.favform.append((Item)this.cg_favourites);
            this.favform.addCommand(this.cmd_sendfav);
            this.favform.addCommand(this.cmd_addnewfav);
            this.favform.addCommand(this.cmd_delfav);
            this.favform.addCommand(this.cmd_closenamfav);
            this.favform.setCommandListener((CommandListener)this);
            this.uihandler.setWinlock(true);
            this.uihandler.setDisplay((Displayable)this.favform);
        } else if (command == this.cmd_sendfav) {
            boolean[] blArray = new boolean[this.cg_favourites.size()];
            this.cg_favourites.getSelectedFlags(blArray);
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                String string = this.cg_favourites.getString(i);
                this.handleMsg(string);
            }
            this.uihandler.setWinlock(false);
            this.show();
        } else if (command == this.cmd_addslap) {
            textbox = new TextBox(Irc.language.get("addslap"), "", 1000, 0);
            textbox.setCommandListener((CommandListener)new TextboxListener());
            textbox.addCommand(this.cmd_ok);
            if (UIHandler.message != null) {
                textbox.addCommand(this.cmd_paste);
            }
            textbox.addCommand(this.cmd_smiles);
            textbox.addCommand(this.cmd_colmsg);
            textbox.addCommand(this.cmd_styles);
            textbox.addCommand(this.cmd_cancel);
            this.uihandler.setDisplay((Displayable)textbox);
        } else if (command == this.cmd_editslap) {
            if (this.slapslist.getSelectedIndex() > 0) {
                textbox = new TextBox(Irc.language.get("editslap"), this.slapslist.getString(this.slapslist.getSelectedIndex()), 1000, 0);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                textbox.addCommand(this.cmd_ok);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                this.uihandler.setDisplay((Displayable)textbox);
            }
        } else if (command == this.cmd_delslap) {
            if (this.slapslist.getSelectedIndex() > 0) {
                this.uihandler.removeSlap(this.slapslist.getString(this.slapslist.getSelectedIndex()));
                this.slapslist.delete(this.slapslist.getSelectedIndex());
                this.uihandler.saveSlaps();
            }
            this.uihandler.setDisplay((Displayable)this.slapslist);
        } else if (command == this.cmd_addnewfav) {
            textbox = new TextBox(Irc.language.get("addfavourite"), "", 1000, 0);
            textbox.setCommandListener((CommandListener)new TextboxListener());
            textbox.addCommand(this.cmd_ok);
            if (UIHandler.message != null) {
                textbox.addCommand(this.cmd_paste);
            }
            textbox.addCommand(this.cmd_smiles);
            textbox.addCommand(this.cmd_colmsg);
            textbox.addCommand(this.cmd_styles);
            textbox.addCommand(this.cmd_cancel);
            this.uihandler.setDisplay((Displayable)textbox);
        } else if (command == this.cmd_delfav) {
            boolean[] blArray = new boolean[this.cg_favourites.size()];
            this.cg_favourites.getSelectedFlags(blArray);
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                this.uihandler.removeFav(this.cg_favourites.getString(i));
            }
            Vector vector = this.uihandler.getFavs();
            while (this.cg_favourites.size() > 0) {
                this.cg_favourites.delete(0);
            }
            for (int i = 0; i < vector.size(); ++i) {
                this.cg_favourites.append((String)vector.elementAt(i), null);
            }
            this.uihandler.saveFavs();
        } else if (this.slapslist != null && command == List.SELECT_COMMAND) {
            String string = this.slapslist.getString(this.slapslist.getSelectedIndex());
            String string2 = this.slapslist.getTitle();
            if (string.equals("[" + Irc.language.get("back") + "]")) {
                this.namecmdlist = new List(string2, 3);
                this.namecmdlist.append("[" + Irc.language.get("back") + "]", Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("address"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("notice"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("invite"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("query"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("slaps"), Images.icons.getImage(0));
                this.namecmdlist.append("Whois", Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("info") + " CTCP", Images.icons.getImage(0));
                if (UIHandler.nickMode == '\u0004' || UIHandler.nickMode == '\u0002') {
                    this.namecmdlist.append(Irc.language.get("managing"), Images.icons.getImage(0));
                }
                this.namecmdlist.setCommandListener((CommandListener)this);
                this.uihandler.setDisplay((Displayable)this.namecmdlist);
                this.slapslist = null;
            } else {
                String string3 = Utils.replace(string, "%nick%", string2);
                string3 = Utils.replace(string3, "%channel%", this.header);
                this.handleMsg("/ME " + string3);
                this.slapslist = null;
                this.show();
            }
        } else if (this.nameslist != null && command == List.SELECT_COMMAND) {
            String string = this.nameslist.getString(this.nameslist.getSelectedIndex());
            if (string.equals("[" + Irc.language.get("next") + "]")) {
                ++this.person_position;
                this.listnames(command, displayable);
            } else if (string.equals("[" + Irc.language.get("previous") + "]")) {
                --this.person_position;
                this.listnames(command, displayable);
            } else if (this.name == Irc.language.get("channelslist")) {
                Irc.writeLine("JOIN " + string);
                this.namecmdlist = null;
                this.show();
            } else {
                this.namecmdlist = new List(string, 3);
                this.namecmdlist.append("[" + Irc.language.get("back") + "]", Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("address"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("notice"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("invite"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("query"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("slaps"), Images.icons.getImage(0));
                this.namecmdlist.append("Whois", Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("info") + " CTCP", Images.icons.getImage(0));
                if (UIHandler.nickMode == '\u0004' || UIHandler.nickMode == '\u0002') {
                    this.namecmdlist.append(Irc.language.get("managing"), Images.icons.getImage(0));
                }
                this.namecmdlist.setCommandListener((CommandListener)this);
                this.uihandler.setDisplay((Displayable)this.namecmdlist);
                this.nameslist = null;
            }
        } else if (this.namecmdlist != null && command == List.SELECT_COMMAND) {
            String string = this.namecmdlist.getString(this.namecmdlist.getSelectedIndex());
            String string4 = this.namecmdlist.getTitle();
            if (string.equals("[" + Irc.language.get("back") + "]")) {
                this.listnames(command, displayable);
                this.namecmdlist = null;
            } else if (string.equals(Irc.language.get("address"))) {
                String string5 = this.uihandler.template_query;
                string5 = Utils.replace(string5, "%nick%", string4);
                string5 = Utils.replace(string5, "%ctcp%", "\u0001");
                string5 = Utils.replace(string5, "%color%", "\u0003");
                string5 = Utils.replace(string5, "%bold%", "\u0002");
                string5 = Utils.replace(string5, "%italic%", "\u001f");
                string5 = Utils.replace(string5, "%underline%", "\u0016");
                textbox = new TextBox(Irc.language.get("address"), string5, 10000, 0);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                textbox.addCommand(this.cmd_send);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                this.uihandler.setDisplay((Displayable)textbox);
                this.namecmdlist = null;
            } else if (string.equals(Irc.language.get("notice"))) {
                textbox = new TextBox(Irc.language.get("notice") + " " + string4, "", 10000, 0);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                textbox.addCommand(this.cmd_ok);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                this.uihandler.setDisplay((Displayable)textbox);
                this.namecmdlist = null;
            } else if (string.equals(Irc.language.get("invite"))) {
                textbox = new TextBox(Irc.language.get("invite") + " " + string4, "", 100, 0);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                textbox.addCommand(this.cmd_ok);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                this.uihandler.setDisplay((Displayable)textbox);
                this.namecmdlist = null;
            } else if (string.equals(Irc.language.get("query"))) {
                Window window = this.uihandler.getPrivate(string4);
                this.state = 0;
                this.namecmdlist = null;
                window.show();
            } else if (string.equals(Irc.language.get("slaps"))) {
                this.slapslist = new List(string4, 3);
                Vector vector = this.uihandler.getSlaps();
                this.slapslist.append("[" + Irc.language.get("back") + "]", Images.icons.getImage(0));
                for (int i = 0; i < vector.size(); ++i) {
                    this.slapslist.append((String)vector.elementAt(i), Images.icons.getImage(0));
                }
                this.slapslist.addCommand(this.cmd_addslap);
                this.slapslist.addCommand(this.cmd_editslap);
                this.slapslist.addCommand(this.cmd_delslap);
                this.slapslist.setCommandListener((CommandListener)this);
                this.uihandler.setDisplay((Displayable)this.slapslist);
                this.namecmdlist = null;
            } else if (string.equals(Irc.language.get("info") + " CTCP")) {
                this.ctcpmenu = new List(string4, 3);
                this.ctcpmenu.append("[" + Irc.language.get("back") + "]", Images.icons.getImage(0));
                this.ctcpmenu.append("VERSION", Images.icons.getImage(0));
                this.ctcpmenu.append("USERINFO", Images.icons.getImage(0));
                this.ctcpmenu.append("PING", Images.icons.getImage(0));
                this.ctcpmenu.append("TIME", Images.icons.getImage(0));
                this.ctcpmenu.setCommandListener((CommandListener)this);
                this.uihandler.setDisplay((Displayable)this.ctcpmenu);
                this.namecmdlist = null;
            } else if (string.equals(Irc.language.get("managing"))) {
                this.usermanagmentmenu = new List(string4, 3);
                this.usermanagmentmenu.append("[" + Irc.language.get("back") + "]", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Kick(" + Irc.language.get("reason") + ")", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Kick", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Kick+Ban", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Kick+Ban(" + Irc.language.get("reason") + ")", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Ban", Images.icons.getImage(0));
                this.usermanagmentmenu.append("UnBan", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Hop", Images.icons.getImage(0));
                this.usermanagmentmenu.append("DeHop", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Op", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Deop", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Voice", Images.icons.getImage(0));
                this.usermanagmentmenu.append("Devoice", Images.icons.getImage(0));
                this.usermanagmentmenu.setCommandListener((CommandListener)this);
                this.uihandler.setDisplay((Displayable)this.usermanagmentmenu);
                this.namecmdlist = null;
            } else if (string.equals("Whois")) {
                Irc.writeLine("WHOIS " + string4);
                this.namecmdlist = null;
                this.show();
            }
        } else if (this.ctcpmenu != null && command == List.SELECT_COMMAND) {
            String string = this.ctcpmenu.getString(this.ctcpmenu.getSelectedIndex());
            String string6 = this.ctcpmenu.getTitle();
            if (string.equals("[" + Irc.language.get("back") + "]")) {
                this.namecmdlist = new List(string6, 3);
                this.namecmdlist.append("[" + Irc.language.get("back") + "]", Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("address"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("notice"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("invite"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("query"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("slaps"), Images.icons.getImage(0));
                this.namecmdlist.append("Whois", Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("info") + " CTCP", Images.icons.getImage(0));
                if (UIHandler.nickMode == '\u0004' || UIHandler.nickMode == '\u0002') {
                    this.namecmdlist.append(Irc.language.get("managing"), Images.icons.getImage(0));
                }
                this.namecmdlist.setCommandListener((CommandListener)this);
                this.uihandler.setDisplay((Displayable)this.namecmdlist);
                this.ctcpmenu = null;
            } else if (string.equals("USERINFO")) {
                Irc.writeLine("PRIVMSG " + string6 + " :" + "\u0001USERINFO\u0001");
                this.ctcpmenu = null;
                this.show();
            } else if (string.equals("VERSION")) {
                Irc.writeLine("PRIVMSG " + string6 + " :\u0001VERSION\u0001");
                this.ctcpmenu = null;
                this.show();
            } else if (string.equals("TIME")) {
                Irc.writeLine("PRIVMSG " + string6 + " :\u0001TIME\u0001");
                this.ctcpmenu = null;
                this.show();
            } else if (string.equals("PING")) {
                Irc.writeLine("PRIVMSG " + string6 + " :\u0001PING " + System.currentTimeMillis() + "\u0001");
                this.ctcpmenu = null;
                this.show();
            }
        } else if (this.usermanagmentmenu != null && command == List.SELECT_COMMAND) {
            String string = this.usermanagmentmenu.getString(this.usermanagmentmenu.getSelectedIndex());
            String string7 = this.usermanagmentmenu.getTitle();
            if (string.equals("[" + Irc.language.get("back") + "]")) {
                this.uihandler.setDisplay((Displayable)this.namecmdlist);
                this.namecmdlist = new List(string7, 3);
                this.namecmdlist.append("[" + Irc.language.get("back") + "]", Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("address"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("notice"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("invite"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("query"), Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("slaps"), Images.icons.getImage(0));
                this.namecmdlist.append("Whois", Images.icons.getImage(0));
                this.namecmdlist.append(Irc.language.get("info") + " CTCP", Images.icons.getImage(0));
                if (UIHandler.nickMode == '\u0004' || UIHandler.nickMode == '\u0002') {
                    this.namecmdlist.append(Irc.language.get("managing"), Images.icons.getImage(0));
                }
                this.namecmdlist.setCommandListener((CommandListener)this);
                this.uihandler.setDisplay((Displayable)this.namecmdlist);
                this.usermanagmentmenu = null;
            } else if (string.equals("Kick")) {
                Irc.writeLine("KICK " + this.name + " " + string7 + " :" + UIHandler.nick);
                this.usermanagmentmenu = null;
                this.show();
            } else if (string.equals("Kick+Ban")) {
                Irc.writeLine("MODE " + this.name + " +b " + string7);
                Irc.writeLine("KICK " + this.name + " " + string7 + " :" + UIHandler.nick);
                this.usermanagmentmenu = null;
                this.show();
            } else if (string.equals("Kick(" + Irc.language.get("reason") + ")")) {
                textbox = new TextBox("Kick(" + Irc.language.get("reason") + ") " + string7, "", 1000, 0);
                textbox.addCommand(this.cmd_ok);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)textbox);
                this.usermanagmentmenu = null;
            } else if (string.equals("Kick+Ban(" + Irc.language.get("reason") + ")")) {
                textbox = new TextBox("Kick+Ban(" + Irc.language.get("reason") + ") " + string7, "", 1000, 0);
                textbox.addCommand(this.cmd_ok);
                if (UIHandler.message != null) {
                    textbox.addCommand(this.cmd_paste);
                }
                textbox.addCommand(this.cmd_smiles);
                textbox.addCommand(this.cmd_colmsg);
                textbox.addCommand(this.cmd_styles);
                textbox.addCommand(this.cmd_cancel);
                textbox.setCommandListener((CommandListener)new TextboxListener());
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)textbox);
                this.usermanagmentmenu = null;
            } else {
                String string8 = "";
                if (string.equals("Op")) {
                    string8 = "+o";
                } else if (string.equals("Deop")) {
                    string8 = "-o";
                } else if (string.equals("Hop")) {
                    string8 = "+h";
                } else if (string.equals("DeHop")) {
                    string8 = "-h";
                } else if (string.equals("Voice")) {
                    string8 = "+v";
                } else if (string.equals("Devoice")) {
                    string8 = "-v";
                } else if (string.equals("Ban")) {
                    string8 = "+b";
                } else if (string.equals("UnBan")) {
                    string8 = "-b";
                }
                Irc.writeLine("MODE " + this.name + " " + string8 + " " + string7);
                this.usermanagmentmenu = null;
                this.show();
            }
        }
    }

    private class TextboxListener
    implements CommandListener {
        private TextboxListener() {
        }

        public void commandAction(Command command, Displayable displayable) {
            Window.this.uihandler.setWinlock(false);
            if (command == Window.this.cmd_send) {
                if (!textbox.getString().equals("")) {
                    Window.this.handleMsg(textbox.getString());
                    Window.this.show();
                    textbox = null;
                } else {
                    Window.this.show();
                    textbox = null;
                }
            } else if (command == Window.this.cmd_cancel) {
                if (textbox.getTitle().equals(Irc.language.get("addfavourite"))) {
                    textbox = null;
                    Window.this.uihandler.setDisplay((Displayable)Window.this.favform);
                } else if (textbox.getTitle().equals(Irc.language.get("addslap")) || textbox.getTitle().equals(Irc.language.get("editslap"))) {
                    textbox = null;
                    Window.this.uihandler.setDisplay((Displayable)Window.this.slapslist);
                } else {
                    textbox = null;
                    Window.this.show();
                }
            } else if (command == Window.this.cmd_textboxmenu) {
                Window.this.textboxmenu = new List(Irc.language.get("menu"), 3);
                Window.this.textboxmenu.append(Irc.language.get("paste"), Images.icons.getImage(0));
                Window.this.textboxmenu.append(Irc.language.get("smiles"), Images.icons.getImage(0));
                Window.this.textboxmenu.append(Irc.language.get("colors"), Images.icons.getImage(0));
                Window.this.textboxmenu.append(Irc.language.get("styles"), Images.icons.getImage(0));
                Window.this.textboxmenu.append(Irc.language.get("cancel"), Images.icons.getImage(0));
                Window.this.textboxmenu.setCommandListener((CommandListener)this);
                Window.this.uihandler.setDisplay((Displayable)Window.this.textboxmenu);
            } else if (Window.this.textboxmenu != null && command == List.SELECT_COMMAND) {
                String string = Window.this.textboxmenu.getString(Window.this.textboxmenu.getSelectedIndex());
                if (string.equals(Irc.language.get("smiles"))) {
                    this.commandAction(Window.this.cmd_smiles, null);
                } else if (string.equals(Irc.language.get("paste"))) {
                    this.commandAction(Window.this.cmd_paste, null);
                } else if (string.equals(Irc.language.get("colors"))) {
                    this.commandAction(Window.this.cmd_colmsg, null);
                } else if (string.equals(Irc.language.get("styles"))) {
                    this.commandAction(Window.this.cmd_styles, null);
                } else if (string.equals(Irc.language.get("cancel"))) {
                    this.commandAction(Window.this.cmd_cancel, null);
                    Window.this.textboxmenu = null;
                }
            } else if (command == Window.this.cmd_colmsg) {
                Window.this.cg_colmsg = new ChoiceGroup(Irc.language.get("fontcolor"), 1);
                Window.this.cg_colmsg.append(Irc.language.get("white"), null);
                Window.this.cg_colmsg.append(Irc.language.get("black"), null);
                Window.this.cg_colmsg.append(Irc.language.get("blue"), null);
                Window.this.cg_colmsg.append(Irc.language.get("green"), null);
                Window.this.cg_colmsg.append(Irc.language.get("darkred"), null);
                Window.this.cg_colmsg.append(Irc.language.get("brown"), null);
                Window.this.cg_colmsg.append(Irc.language.get("purple"), null);
                Window.this.cg_colmsg.append(Irc.language.get("orange"), null);
                Window.this.cg_colmsg.append(Irc.language.get("yellow"), null);
                Window.this.cg_colmsg.append(Irc.language.get("lightgreen"), null);
                Window.this.cg_colmsg.append(Irc.language.get("darkgreen"), null);
                Window.this.cg_colmsg.append(Irc.language.get("lightblue"), null);
                Window.this.cg_colmsg.append(Irc.language.get("darkblue"), null);
                Window.this.cg_colmsg.append(Irc.language.get("pink"), null);
                Window.this.cg_colmsg.append(Irc.language.get("darkgray"), null);
                Window.this.cg_colmsg.append(Irc.language.get("gray"), null);
                Window.this.cg_colmsg.setSelectedIndex(1, true);
                Window.this.cg_colmsgfone = new ChoiceGroup(Irc.language.get("bgcolor"), 1);
                Window.this.cg_colmsgfone.append(Irc.language.get("white"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("black"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("blue"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("green"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("darkred"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("brown"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("purple"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("orange"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("yellow"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("lightgreen"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("darkgreen"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("lightblue"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("darkblue"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("pink"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("darkgray"), null);
                Window.this.cg_colmsgfone.append(Irc.language.get("gray"), null);
                Window.this.cg_colmsgfone.setSelectedIndex(0, true);
                Window.this.colmsgform = new Form(Irc.language.get("colors"));
                Window.this.colmsgform.append((Item)Window.this.cg_colmsg);
                Window.this.colmsgform.append((Item)Window.this.cg_colmsgfone);
                Window.this.colmsgform.addCommand(Window.this.cmd_addcol);
                Window.this.colmsgform.setCommandListener((CommandListener)this);
                Window.this.uihandler.setWinlock(true);
                Window.this.uihandler.setDisplay((Displayable)Window.this.colmsgform);
            } else if (command == Window.this.cmd_addcol) {
                textbox.insert("\u0003" + Window.this.cg_colmsg.getSelectedIndex() + "," + Window.this.cg_colmsgfone.getSelectedIndex(), textbox.getCaretPosition());
                Window.this.uihandler.setDisplay((Displayable)textbox);
                Window.this.colmsgform = null;
            } else if (command == Window.this.cmd_smiles) {
                Window.this.uihandler.setDisplay((Displayable)Window.this.sml);
            } else if (command == Window.this.cmd_paste) {
                if (UIHandler.message != null) {
                    textbox.insert(UIHandler.message, textbox.getCaretPosition());
                }
                Window.this.uihandler.setDisplay((Displayable)textbox);
            } else if (command == Window.this.cmd_styles) {
                Window.this.cg_styles = new ChoiceGroup(Irc.language.get("styles"), 2);
                Window.this.cg_styles.append(Irc.language.get("bold"), null);
                Window.this.cg_styles.append(Irc.language.get("underlined"), null);
                Window.this.cg_styles.append(Irc.language.get("italic"), null);
                Window.this.cg_styles.setSelectedIndex(0, false);
                Window.this.cg_styles.setSelectedIndex(1, false);
                Window.this.cg_styles.setSelectedIndex(2, false);
                Window.this.stylesform = new Form(Irc.language.get("styles"));
                Window.this.stylesform.append((Item)Window.this.cg_styles);
                Window.this.stylesform.addCommand(Window.this.cmd_applystyle);
                Window.this.stylesform.setCommandListener((CommandListener)this);
                Window.this.uihandler.setWinlock(true);
                Window.this.uihandler.setDisplay((Displayable)Window.this.stylesform);
            } else if (command == Window.this.cmd_applystyle) {
                if (Window.this.cg_styles.isSelected(0)) {
                    Window.this.textstyle = Window.this.textstyle + '\u0002';
                }
                if (Window.this.cg_styles.isSelected(1)) {
                    Window.this.textstyle = Window.this.textstyle + '\u001f';
                }
                if (Window.this.cg_styles.isSelected(2)) {
                    Window.this.textstyle = Window.this.textstyle + '\u0016';
                }
                textbox.insert(Window.this.textstyle, textbox.getCaretPosition());
                Window.this.uihandler.setDisplay((Displayable)textbox);
                Window.this.textstyle = "";
                Window.this.stylesform = null;
            } else if (command == Window.this.cmd_ok) {
                if (textbox.getString().trim().equals("")) {
                    return;
                }
                String string = textbox.getTitle();
                if (string.equals(Irc.language.get("joinchannel"))) {
                    String string2 = textbox.getString();
                    if (!Utils.isChannel(string2)) {
                        string2 = "#" + string2;
                    }
                    Window.this.show();
                    Irc.writeLine("JOIN " + string2);
                    textbox = null;
                } else if (string.equals(Irc.language.get("editslap"))) {
                    String string3 = textbox.getString();
                    if (!Window.this.slapslist.getString(Window.this.slapslist.getSelectedIndex()).equals(string3)) {
                        Window.this.uihandler.removeSlap(Window.this.slapslist.getString(Window.this.slapslist.getSelectedIndex()));
                        Window.this.slapslist.set(Window.this.slapslist.getSelectedIndex(), string3, Images.icons.getImage(0));
                        Window.this.uihandler.addSlap(string3);
                        Window.this.uihandler.saveSlaps();
                    }
                    Window.this.uihandler.setDisplay((Displayable)Window.this.slapslist);
                    textbox = null;
                } else if (string.equals(Irc.language.get("addslap"))) {
                    String string4 = textbox.getString();
                    Window.this.uihandler.addSlap(string4);
                    Window.this.slapslist.append(string4, Images.icons.getImage(0));
                    Window.this.uihandler.setDisplay((Displayable)Window.this.slapslist);
                    Window.this.uihandler.saveSlaps();
                    textbox = null;
                } else if (string.equals(Irc.language.get("changenickaction"))) {
                    String string5 = textbox.getString();
                    Irc.writeLine("NICK " + string5);
                    UIHandler.nick = string5;
                    textbox = null;
                    Window.this.show();
                } else if (string.indexOf("Kick(" + Irc.language.get("reason") + ")") > -1) {
                    String string6 = textbox.getString();
                    String string7 = textbox.getTitle().substring(textbox.getTitle().indexOf(32) + 1);
                    Irc.writeLine("KICK " + Window.this.name + " " + string7 + " :" + string6);
                    textbox = null;
                    Window.this.show();
                } else if (string.indexOf("Kick+Ban(" + Irc.language.get("reason") + ")") > -1) {
                    String string8 = textbox.getString();
                    String string9 = textbox.getTitle().substring(textbox.getTitle().indexOf(32) + 1);
                    Irc.writeLine("MODE " + Window.this.name + " +b " + string9);
                    Irc.writeLine("KICK " + Window.this.name + " " + string9 + " :" + string8);
                    textbox = null;
                    Window.this.show();
                } else if (string.equals(Irc.language.get("action"))) {
                    String string10 = textbox.getString();
                    Window.this.handleMsg("/ME " + string10);
                    textbox = null;
                    Window.this.show();
                } else if (string.equals(Irc.language.get("allaction"))) {
                    String string11 = textbox.getString();
                    Window.this.uihandler.globalHandleMsg("/ME " + string11);
                    textbox = null;
                    Window.this.show();
                } else if (string.equals(Irc.language.get("address"))) {
                    Window.this.handleMsg(textbox.getString());
                    textbox = null;
                    Window.this.show();
                } else if (string.indexOf(Irc.language.get("notice")) > -1) {
                    String string12 = textbox.getString();
                    String string13 = textbox.getTitle().substring(textbox.getTitle().indexOf(" ") + 1);
                    Window.this.handleMsg("/NOTICE " + string13 + " " + string12);
                    textbox = null;
                    Window.this.show();
                } else if (string.indexOf(Irc.language.get("invite")) > -1) {
                    String string14 = textbox.getString();
                    String string15 = textbox.getTitle().substring(textbox.getTitle().indexOf(" ") + 1);
                    Window.this.handleMsg("/invite " + string15 + " " + string14);
                    textbox = null;
                    Window.this.show();
                } else if (string.equals(Irc.language.get("changetopicaction"))) {
                    String string16 = textbox.getString();
                    Window.this.handleMsg("/TOPIC " + string16);
                    textbox = null;
                    Window.this.show();
                } else if (string.equals(Irc.language.get("query"))) {
                    String string17 = textbox.getString();
                    Window.this.uihandler.setDisplay((Displayable)Window.this.uihandler.getPrivate(string17));
                    textbox = null;
                } else if (string.equals(Irc.language.get("addfavourite"))) {
                    String string18 = textbox.getString();
                    Window.this.uihandler.addFav(string18);
                    Window.this.uihandler.saveFavs();
                    Vector vector = Window.this.uihandler.getFavs();
                    while (Window.this.cg_favourites.size() > 0) {
                        Window.this.cg_favourites.delete(0);
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        Window.this.cg_favourites.append((String)vector.elementAt(i), null);
                    }
                    Window.this.uihandler.setDisplay((Displayable)Window.this.favform);
                }
            }
        }
    }

    private class Smiles
    extends Canvas {
        private int width;
        private int height;
        private int smiles_on_horizontal;
        private int smiles_on_vertical;
        private int width_of_smile;
        private Image ti;
        private Graphics tg;
        private int cursor_x = 0;
        private int cursor_y = 0;

        public Smiles(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.smiles_on_horizontal = n / ((Window)Window.this).uihandler.emotions.smilesList.getHeight();
            this.smiles_on_vertical = UIHandler.SMILES.length / this.smiles_on_horizontal;
            this.width_of_smile = n / this.smiles_on_horizontal;
            this.ti = Image.createImage((int)n, (int)n2);
            this.tg = this.ti.getGraphics();
            this.draw_smiles(this.tg);
        }

        public void draw_smiles(Graphics graphics) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.width, this.height);
            int n = 0;
            int n2 = UIHandler.SMILES.length;
            for (int i = 0; i <= this.smiles_on_vertical; ++i) {
                int n3 = 0;
                while (n3 < n2 & n3 < this.smiles_on_horizontal) {
                    graphics.drawImage(((Window)Window.this).uihandler.emotions.smilesList.getImage(n), n3 * this.width_of_smile, i * this.width_of_smile, 0);
                    ++n;
                    ++n3;
                }
                n2 -= this.smiles_on_horizontal;
            }
        }

        public void draw_cursor(Graphics graphics) {
            graphics.setColor(0, 0, 0);
            graphics.drawRect(this.cursor_x * this.width_of_smile, this.cursor_y * this.width_of_smile, ((Window)Window.this).uihandler.emotions.smilesList.getHeight(), ((Window)Window.this).uihandler.emotions.smilesList.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.drawImage(this.ti, 0, 0, 0);
            this.draw_cursor(graphics);
        }

        public void keyPressed(int n) {
            switch (this.getGameAction(n)) {
                case 1: {
                    this.cursor_y = this.cursor_y == 0 ? this.smiles_on_vertical : --this.cursor_y;
                    if (this.cursor_y * this.smiles_on_horizontal + this.cursor_x > UIHandler.SMILES.length - 1) {
                        this.cursor_x = UIHandler.SMILES.length - 1 - this.cursor_y * this.smiles_on_horizontal;
                    }
                    this.repaint();
                    break;
                }
                case 6: {
                    this.cursor_y = this.cursor_y == this.smiles_on_vertical ? 0 : ++this.cursor_y;
                    if (this.cursor_y * this.smiles_on_horizontal + this.cursor_x > UIHandler.SMILES.length - 1) {
                        this.cursor_x = UIHandler.SMILES.length - 1 - this.cursor_y * this.smiles_on_horizontal;
                    }
                    this.repaint();
                    break;
                }
                case 2: {
                    this.cursor_x = this.cursor_x == 0 ? this.smiles_on_horizontal - 1 : --this.cursor_x;
                    if (this.cursor_y * this.smiles_on_horizontal + this.cursor_x > UIHandler.SMILES.length - 1) {
                        this.cursor_x = UIHandler.SMILES.length - 1 - this.cursor_y * this.smiles_on_horizontal;
                    }
                    this.repaint();
                    break;
                }
                case 5: {
                    this.cursor_x = this.cursor_x == this.smiles_on_horizontal - 1 ? 0 : ++this.cursor_x;
                    if (this.cursor_y * this.smiles_on_horizontal + this.cursor_x > UIHandler.SMILES.length - 1) {
                        this.cursor_x = UIHandler.SMILES.length - 1 - this.cursor_y * this.smiles_on_horizontal;
                    }
                    this.repaint();
                    break;
                }
                case 8: {
                    textbox.insert(UIHandler.SMILES[this.cursor_y * this.smiles_on_horizontal + this.cursor_x][0], textbox.getCaretPosition());
                    Window.this.uihandler.setDisplay((Displayable)textbox);
                    this.cursor_y = 0;
                    this.cursor_x = 0;
                }
            }
        }
    }
}

