/*
 * Decompiled with CFR 0.152.
 */
package inettools;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public abstract class IrcConnection {
    protected char[] koi8rmap = "\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c\u2580\u2584\u2588\u258c\u2590\u2591\u2592\u2593\u2320\u25a0\u2219\u221a\u2248\u2264\u2265\u00a0\u2321\u00b0\u00b2\u00b7\u00f7\u2550\u2551\u2552\u0451\u2553\u2554\u2555\u2556\u2557\u2558\u2559\u255a\u255b\u255c\u255d\u255e\u255f\u2560\u2561\u0401\u2562\u2563\u2564\u2565\u2566\u2567\u2568\u2569\u256a\u256b\u256c\u00a9\u044e\u0430\u0431\u0446\u0434\u0435\u0444\u0433\u0445\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u044f\u0440\u0441\u0442\u0443\u0436\u0432\u044c\u044b\u0437\u0448\u044d\u0449\u0447\u044a\u042e\u0410\u0411\u0426\u0414\u0415\u0424\u0413\u0425\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u042f\u0420\u0421\u0422\u0423\u0416\u0412\u042c\u042b\u0417\u0428\u042d\u0429\u0427\u042a".toCharArray();
    protected char[] cp1251map = "\u0402\u0403\u201a\u0453\u201e\u2026\u2020\u2021\u20ac\u2030\u0409\u2039\u040a\u040c\u040b\u040f\u0452\u2018\u2019\u201c\u201d\u2022\u2013\u2014\ufffd\u2122\u0459\u203a\u045a\u045c\u045b\u045f\u00a0\u040e\u045e\u0408\u00a4\u0490\u00a6\u00a7\u0401\u00a9\u0404\u00ab\u00ac\u00ad\u00ae\u0407\u00b0\u00b1\u0406\u0456\u0491\u00b5\u00b6\u00b7\u0451\u2116\u0454\u00bb\u0458\u0405\u0455\u0457\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f".toCharArray();
    protected Hashtable hashmap = null;

    public abstract String connect(String var1, int var2, String var3);

    public abstract void disconnect();

    public abstract String updateConnection();

    public abstract String readLine();

    public abstract String writeData(String var1);

    public abstract boolean hasDataInBuffer();

    public abstract boolean isConnected();

    public abstract int getBytesIn();

    public abstract int getBytesOut();

    protected String byteArrayToString(byte[] byArray, String string) {
        String string2;
        char[] cArray = null;
        if (string.equals("KOI8-R")) {
            cArray = this.koi8rmap;
        } else if (string.equals("Windows-1251")) {
            cArray = this.cp1251map;
        }
        if (cArray != null) {
            char[] cArray2 = new char[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                cArray2[i] = by >= 0 ? (char)by : cArray[by + 128];
            }
            string2 = new String(cArray2);
        } else {
            try {
                string2 = new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = new String(byArray);
            }
        }
        return string2;
    }

    protected byte[] stringToByteArray(String string, String string2) {
        byte[] byArray;
        if (string2.equals("KOI8-R") || string2.equals("Windows-1251")) {
            if (this.hashmap == null || !string2.equals((String)this.hashmap.get("encoding"))) {
                if (string2.equals("KOI8-R")) {
                    this.hashmap = this.generateHashmap(this.koi8rmap);
                } else if (string2.equals("Windows-1251")) {
                    this.hashmap = this.generateHashmap(this.cp1251map);
                }
                this.hashmap.put("encoding", string2);
            }
            char[] cArray = string.toCharArray();
            byte[] byArray2 = new byte[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                Byte by;
                byArray2[i] = cArray[i] < '\u0080' ? (int)cArray[i] : ((by = (Byte)this.hashmap.get(new Character(cArray[i]))) == null ? 63 : (int)by.byteValue());
            }
            byArray = byArray2;
        } else {
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
        }
        return byArray;
    }

    private Hashtable generateHashmap(char[] cArray) {
        Hashtable<Character, Byte> hashtable = new Hashtable<Character, Byte>();
        for (int i = 0; i < cArray.length; ++i) {
            hashtable.put(new Character(cArray[i]), new Byte((byte)(128 + i)));
        }
        return hashtable;
    }
}

