/*
 * Decompiled with CFR 0.152.
 */
package inettools;

import inettools.Database;
import inettools.Irc;
import inettools.IrcConnection;
import inettools.Resources;
import inettools.UIHandler;
import inettools.Window;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import lib.GraphicControls.MessageBox;
import lib.Utils.Utils;

public class Listener
extends Thread {
    private IrcConnection irc;
    private UIHandler uihandler;
    private String whois = "";
    private Display display;
    private MessageBox mb;
    private boolean needupdate;
    private boolean nicktried;
    private boolean showinput;
    private boolean showhosts;
    private boolean ajoinkick;
    private boolean poolmode;
    private boolean vibra;
    private boolean sound;
    private boolean light;
    private boolean onnotice;
    private String altnick;
    private String host;
    private String idpass;
    private String password;
    private String username;
    private String realname;
    private String info;
    private int port;
    private int pooltime;
    private String[] channels;
    private String[] start_commands;

    public Listener(Database database, IrcConnection ircConnection, UIHandler uIHandler) {
        this.irc = ircConnection;
        this.uihandler = uIHandler;
        this.altnick = database.altnick;
        this.host = database.host;
        this.password = database.passwd;
        this.username = database.username;
        this.realname = database.realname;
        this.port = database.port;
        this.showinput = database.showinput;
        this.showhosts = database.showhosts;
        this.ajoinkick = database.ajoinkick;
        this.channels = database.getChannels();
        this.start_commands = database.getStartCommands();
        this.info = database.ctcp_info;
        this.vibra = database.vibra;
        this.sound = database.sound;
        this.light = database.light;
        this.onnotice = database.onnotice;
        this.poolmode = database.poolmode;
        this.pooltime = database.pooltime;
        this.needupdate = false;
        this.nicktried = false;
    }

    public void run() {
        String string;
        String string2 = "";
        String string3 = this.host;
        int n = this.port;
        this.uihandler.getConsole().writeInfo(Irc.language.get("connectto") + " " + string3 + ":" + n);
        String string4 = UIHandler.nick.equals("") ? "Irc_usr" : UIHandler.nick;
        String string5 = this.username.equals("") ? string4 : this.username;
        String string6 = string = this.realname.equals("") ? "Irc user" : this.realname;
        if (!Utils.hasNoValue(this.password)) {
            string2 = string2 + "PASS " + this.password + "\r\n";
        }
        string2 = string2 + "NICK " + string4 + "\r\n";
        String string7 = this.irc.connect(string3, n, string2 = string2 + "USER " + string5 + " 8 * :" + string + "\r\n");
        if (string7 == null) {
            this.listen();
        } else {
            this.uihandler.getConsole().writeInfo(string7);
        }
        this.uihandler.clearChanPriv();
    }

    private void listen() {
        String string = null;
        int n = 0;
        while (this.irc.isConnected()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.poolmode && ++n >= this.pooltime * 2) {
                this.needupdate = true;
            }
            if (this.needupdate) {
                string = this.irc.updateConnection();
                this.needupdate = false;
                n = 0;
            }
            if (string == null) {
                while (this.irc.hasDataInBuffer()) {
                    String string2 = this.irc.readLine();
                    if (string2 == null || string2.trim().equals("")) continue;
                    this.checkMessage(string2);
                }
            }
            if (string == null) continue;
            this.uihandler.getConsole().writeInfo(string);
            string = null;
        }
        this.uihandler.getConsole().writeInfo(Irc.language.get("disconnecting"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkMessage(String string) {
        try {
            int n;
            String[] stringArray = this.parseLine(string);
            if (stringArray[1] == null) {
                return;
            }
            String[] stringArray2 = Utils.splitString(stringArray[1], " ");
            if (stringArray2[0].equals("PING")) {
                Irc.writeLine("PONG :" + stringArray[2]);
                return;
            }
            if (stringArray[0] == null) {
                return;
            }
            String string2 = stringArray[0].indexOf(33) >= 0 ? stringArray[0].substring(0, stringArray[0].indexOf(33)) : stringArray[0];
            String string3 = stringArray[2] == null ? "" : (stringArray[2].indexOf(" ") != -1 ? stringArray[2].substring(0, stringArray[2].indexOf(" ")) : stringArray[2]);
            try {
                n = Integer.parseInt(stringArray2[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n == 0) {
                if (stringArray2[0].equals("MODE")) {
                    int n2;
                    if (!Utils.isChannel(stringArray2[1]) || stringArray2.length < 3) return;
                    String[] stringArray3 = new String[3];
                    int n3 = 0;
                    boolean bl = true;
                    Window window = this.uihandler.getChannel(stringArray2[1]);
                    stringArray3[2] = stringArray2.length == 5 ? stringArray[2] : null;
                    stringArray3[1] = stringArray2.length == 5 ? stringArray2[4] : null;
                    stringArray3[1] = stringArray2.length == 4 ? stringArray[2] : stringArray3[1];
                    stringArray3[0] = stringArray2.length >= 4 ? stringArray2[3] : stringArray[2];
                    for (n2 = 0; n2 < stringArray2[2].length(); ++n2) {
                        switch (stringArray2[2].charAt(n2)) {
                            case '+': {
                                bl = true;
                                break;
                            }
                            case '-': {
                                bl = false;
                                break;
                            }
                            case 'o': {
                                window.changeMode('\u0004', stringArray3[n3], bl);
                                ++n3;
                                break;
                            }
                            case 'h': {
                                window.changeMode('\u0002', stringArray3[n3], bl);
                                ++n3;
                                break;
                            }
                            case 'v': {
                                window.changeMode('\u0001', stringArray3[n3], bl);
                                ++n3;
                            }
                        }
                        if (n3 > 2 || stringArray3[n3] == null) break;
                    }
                    String string4 = "* " + string2 + " " + Irc.language.get("changemode") + " '" + stringArray2[2] + "' ";
                    for (n2 = 0; n2 < 3 && stringArray3[n2] != null; ++n2) {
                        string4 = string4 + " " + stringArray3[n2];
                    }
                    window.writeAction(string4);
                    return;
                } else if (stringArray2[0].equals("PRIVMSG")) {
                    char c = stringArray2[1].charAt(0);
                    if (stringArray[2].indexOf(1) != -1) {
                        int n4;
                        int n5 = -1;
                        while ((n4 = stringArray[2].indexOf(1, n5 + 1)) != -1 && (n5 = stringArray[2].indexOf(1, n4 + 1)) != -1) {
                            Object object;
                            String string5;
                            String string6 = stringArray[2].substring(n4 + 1, n5);
                            if (string6.indexOf(32) != -1) {
                                string5 = string6.substring(0, string6.indexOf(32)).toUpperCase();
                                string6 = string6.substring(string6.indexOf(32));
                            } else {
                                string5 = string6.toUpperCase();
                                string6 = "";
                            }
                            if (string5.equals("ACTION")) {
                                if (c == '#' || c == '&' || c == '!') {
                                    this.uihandler.getChannel(stringArray2[1]).writeAction("* " + string2 + " " + string6);
                                    continue;
                                }
                                this.uihandler.getPrivate(string2).writeAction("* " + string2 + " " + string6);
                                continue;
                            }
                            if (string5.equals("PING")) {
                                Irc.writeLine("NOTICE " + string2 + " :\u0001PING" + string6 + "\u0001");
                                this.uihandler.getConsole().writeAction("-" + string2 + "- " + Irc.language.get("pingingyou"));
                                continue;
                            }
                            if (string5.equals("TIME")) {
                                object = Calendar.getInstance();
                                Irc.writeLine("NOTICE " + string2 + " :\u0001TIME " + "[" + ((Calendar)object).get(11) + ":" + (((Calendar)object).get(12) < 10 ? "0" : "") + ((Calendar)object).get(12) + "]" + "\u0001");
                                this.uihandler.getConsole().writeAction("-" + string2 + "- " + Irc.language.get("checkyoutime"));
                                continue;
                            }
                            if (string5.equals("USERINFO")) {
                                Irc.writeLine("NOTICE " + string2 + " :\u0001USERINFO " + this.info + "\u0001");
                                this.uihandler.getConsole().writeAction("-" + string2 + "- " + Irc.language.get("checkyouinfo"));
                                continue;
                            }
                            if (string5.equals("VERSION")) {
                                object = System.getProperty("microedition.platform");
                                if (object == null) {
                                    object = "J2ME device";
                                }
                                Irc.writeLine("NOTICE " + string2 + " :\u0001VERSION InetTools v" + "1.7 beta 6 mod sniper (1.0)" + " on " + (String)object + "\u0001");
                                this.uihandler.getConsole().writeAction("-" + string2 + "- " + Irc.language.get("checkyouversion"));
                                continue;
                            }
                            this.uihandler.getConsole().writeInfo("* " + Irc.language.get("unknownctcp") + " '" + string5 + "' " + Irc.language.get("from") + " " + string2 + ":" + string6);
                        }
                        return;
                    } else if (c == '#' || c == '&' || c == '!') {
                        this.uihandler.getChannel(stringArray2[1]).write(string2, stringArray[2]);
                        return;
                    } else {
                        this.uihandler.getPrivate(string2).write(string2, stringArray[2]);
                    }
                    return;
                } else if (stringArray2[0].equals("NOTICE")) {
                    if (stringArray[2].indexOf("\u0001PING") > -1) {
                        this.uihandler.getConsole().writeAction("-" + string2 + "- PING " + (System.currentTimeMillis() - Long.parseLong(stringArray[2].substring(stringArray[2].indexOf("PING") + 5, stringArray[2].length() - 1))) / 1000L + " " + Irc.language.get("seconds"));
                    } else if (stringArray[2].indexOf("\u0001") > -1) {
                        this.uihandler.getConsole().writeAction("-" + string2 + "- " + stringArray[2].substring(stringArray[2].indexOf("\u0001") + 1, stringArray[2].substring(stringArray[2].indexOf("\u0001") + 1).indexOf("\u0001") + 1));
                    } else {
                        this.uihandler.getConsole().writeAction("-" + string2 + "- " + stringArray[2]);
                    }
                    if (!this.onnotice) return;
                    if (this.sound) {
                        Resources.playAction();
                    }
                    if (this.light) {
                        Resources.LCDFlash();
                    }
                    if (!this.vibra) return;
                    Resources.vibrate();
                    return;
                } else if (stringArray2[0].equals("NICK")) {
                    String string7 = string2 + " " + Irc.language.get("changenick") + " " + string3;
                    Hashtable hashtable = this.uihandler.getChannels();
                    Enumeration enumeration = hashtable.elements();
                    while (enumeration.hasMoreElements()) {
                        Window window = (Window)((Object)enumeration.nextElement());
                        if (!window.hasNick(string2)) continue;
                        window.writeInfo(string7);
                        window.changeNick(string2, string3);
                    }
                    if (this.uihandler.privates.get(string2) == null) return;
                    Window window = (Window)((Object)this.uihandler.privates.get(string2));
                    this.uihandler.privates.remove(string2);
                    window.header = string3;
                    this.uihandler.privates.put(window.header, window);
                    this.uihandler.setDisplay((Displayable)window);
                    window.repaint();
                    return;
                } else if (stringArray2[0].equals("QUIT")) {
                    Hashtable hashtable = this.uihandler.getChannels();
                    Enumeration enumeration = hashtable.elements();
                    while (enumeration.hasMoreElements()) {
                        Window window = (Window)((Object)enumeration.nextElement());
                        if (!window.hasNick(string2)) continue;
                        if (this.showhosts) {
                            window.writeInfo(string2 + " (" + stringArray[0].substring(stringArray[0].indexOf(33) + 1) + ") " + Irc.language.get("quit") + " (" + stringArray[2] + ")");
                        } else {
                            window.writeInfo(string2 + " " + Irc.language.get("quit") + " (" + stringArray[2] + ")");
                        }
                        window.deleteNick(string2);
                    }
                    return;
                } else if (stringArray2[0].equals("JOIN")) {
                    Window window = this.uihandler.getChannel(string3);
                    if (this.showhosts) {
                        window.writeInfo(string2 + " (" + stringArray[0].substring(stringArray[0].indexOf(33) + 1) + ") " + Irc.language.get("join") + " " + string3);
                    } else {
                        window.writeInfo(string2 + " " + Irc.language.get("join") + " " + string3);
                    }
                    if (string2.equals(UIHandler.nick)) return;
                    window.addNick('\u0000', string2);
                    return;
                } else if (stringArray2[0].equals("PART")) {
                    Window window;
                    if (string2.equals(UIHandler.nick)) return;
                    if (stringArray2.length == 1) {
                        window = this.uihandler.getChannel(stringArray[2]);
                        if (this.showhosts) {
                            window.writeInfo(string2 + " (" + stringArray[0].substring(stringArray[0].indexOf(33) + 1) + ") " + Irc.language.get("part") + " " + stringArray[2]);
                        } else {
                            window.writeInfo(string2 + " " + Irc.language.get("part") + " " + stringArray[2]);
                        }
                    } else {
                        window = this.uihandler.getChannel(stringArray2[1]);
                        window.writeInfo(string2 + " " + Irc.language.get("part") + " " + stringArray2[1] + " (" + stringArray[2] + ")");
                    }
                    window.deleteNick(string2);
                    return;
                } else if (stringArray2[0].equals("KICK")) {
                    if (stringArray2[2].equals(UIHandler.nick)) {
                        this.uihandler.getConsole().writeInfo(Irc.language.get("youkicked") + "  " + string2 + " (" + stringArray[2] + ")");
                        if (this.ajoinkick) {
                            this.uihandler.getChannel(stringArray2[1]).deleteAllNicks();
                            Irc.writeLine("JOIN " + stringArray2[1]);
                            return;
                        } else {
                            this.uihandler.getChannel(stringArray2[1]).close();
                        }
                        return;
                    } else {
                        Window window = this.uihandler.getChannel(stringArray2[1]);
                        window.writeInfo(string2 + " " + Irc.language.get("kick") + " " + stringArray2[2] + " (" + stringArray[2] + ")");
                        window.deleteNick(stringArray2[2]);
                    }
                    return;
                } else {
                    if (!stringArray2[0].equals("TOPIC")) return;
                    Window window = this.uihandler.getChannel(stringArray2[1]);
                    window.writeInfo(string2 + " " + Irc.language.get("changetopic") + " '" + stringArray[2] + "'");
                    window.topic = stringArray[2];
                }
                return;
            }
            switch (n) {
                case 1: {
                    String[] stringArray4;
                    this.uihandler.getConsole().writeInfo(Irc.language.get("connected"));
                    this.uihandler.getConsole().writeAction("-" + string);
                    String[] stringArray5 = this.start_commands;
                    if (stringArray5 != null) {
                        for (int i = 0; i < stringArray5.length; ++i) {
                            this.uihandler.getConsole().handleMsg(stringArray5[i]);
                        }
                    }
                    if ((stringArray4 = this.channels) != null) {
                        for (int i = 0; i < stringArray4.length; ++i) {
                            Irc.writeLine("JOIN " + stringArray4[i]);
                        }
                    }
                    this.needupdate = true;
                    return;
                }
                case 301: {
                    this.addWhois(stringArray2[2].toUpperCase(), Irc.language.get("awaystatus") + ": " + stringArray[2] + "\n");
                    return;
                }
                case 305: {
                    this.addWhois(stringArray2[2].toUpperCase(), Irc.language.get("awaystatus") + ": " + stringArray[2] + "\n");
                    return;
                }
                case 306: {
                    this.addWhois(stringArray2[2].toUpperCase(), Irc.language.get("awaystatus") + ": " + stringArray[2] + "\n");
                    return;
                }
                case 311: {
                    String string8 = Irc.language.get("nick") + ": " + stringArray2[2] + "\n";
                    string8 = string8 + Irc.language.get("name") + ": " + stringArray2[3].substring(0) + "\n";
                    string8 = string8 + Irc.language.get("host") + ": " + stringArray2[4] + "\n";
                    this.addWhois(stringArray2[2].toUpperCase(), string8);
                    this.uihandler.getConsole().writeAction("-" + string);
                    return;
                }
                case 312: {
                    this.addWhois(stringArray2[2].toUpperCase(), Irc.language.get("whoisoperator") + ": " + stringArray[2] + "\n");
                    this.uihandler.getConsole().writeAction("-" + string);
                    return;
                }
                case 307: {
                    this.addWhois(stringArray2[2].toUpperCase(), stringArray2[2] + ": " + stringArray[2] + "\n");
                    this.uihandler.getConsole().writeAction("-" + string);
                    return;
                }
                case 313: {
                    this.addWhois(stringArray2[2].toUpperCase(), Irc.language.get("whoisoperator") + ": " + stringArray[2] + "\n");
                    this.uihandler.getConsole().writeAction("-" + string);
                    return;
                }
                case 314: {
                    this.addWhois(stringArray2[2].toUpperCase(), Irc.language.get("realname") + ": " + stringArray2[5] + " \n");
                    this.uihandler.getConsole().writeAction("-" + string);
                    return;
                }
                case 317: {
                    this.addWhois(stringArray2[2].toUpperCase(), Irc.language.get("idle") + ": " + this.parseTime(stringArray2[3]) + " \n");
                    this.uihandler.getConsole().writeAction("-" + string);
                    return;
                }
                case 319: {
                    System.out.println("=" + n + "=" + stringArray2[2] + "=" + stringArray[2]);
                    this.addWhois(stringArray2[2], Irc.language.get("whoischannels") + ": " + stringArray[2] + "\n");
                    this.uihandler.getConsole().writeAction("-" + string);
                    return;
                }
                case 318: {
                    this.mb = new MessageBox(this.display, this.uihandler.getCurrentWindow(), null, null, this.uihandler.getCurrentWindow().cmd_closenamfav, "WHOIS", this.whois, 1, 8, 0);
                    this.uihandler.setDisplay((Displayable)this.mb);
                    this.whois = "";
                    this.uihandler.getConsole().writeAction("-" + string);
                    return;
                }
                case 323: {
                    Window window = this.uihandler.getChannel(Irc.language.get("channelslist"));
                    String string9 = stringArray[1].substring(stringArray[1].indexOf("#"));
                    window.writeAction(string9.substring(0, string9.indexOf(" ")) + "[" + string9.substring(string9.indexOf(" ") + 1, string9.length() - 1) + "]");
                    window.addNick('\u0000', string9.substring(0, string9.indexOf(" ")));
                    window.writeInfo(stringArray[2]);
                }
                case 324: {
                    this.uihandler.getConsole().writeAction("-" + string);
                    return;
                }
                case 331: {
                    this.uihandler.getChannel(stringArray2[2]).writeInfo(Irc.language.get("notopic"));
                    return;
                }
                case 332: {
                    this.uihandler.getChannel(stringArray2[2]).writeInfo(Irc.language.get("topic") + ": '" + stringArray[2] + "'");
                    this.uihandler.getChannel((String)stringArray2[2]).topic = stringArray[2];
                    return;
                }
                case 333: {
                    String string10 = "";
                    string10 = string10 + Irc.language.get("topicwho") + " '" + stringArray2[3].substring(0, stringArray2[3].indexOf(33)) + "'";
                    this.uihandler.getChannel(stringArray2[2]).writeInfo(string10);
                    return;
                }
                case 341: {
                    this.uihandler.getChannel(stringArray2[2]).writeAction(Irc.language.get("inviteonchannel") + " " + stringArray2[3]);
                    return;
                }
                case 351: {
                    this.uihandler.getConsole().writeInfo(stringArray[2]);
                }
                case 315: {
                    return;
                }
                case 353: {
                    Window window = this.uihandler.getChannel(stringArray2[3]);
                    String[] stringArray6 = Utils.splitString(stringArray[2].trim(), " ");
                    for (int i = 0; i < stringArray6.length; ++i) {
                        char c = '\u0000';
                        if (stringArray6[i].charAt(0) == '@') {
                            c = '\u0004';
                        } else if (stringArray6[i].charAt(0) == '%') {
                            c = '\u0002';
                        } else if (stringArray6[i].charAt(0) == '+') {
                            c = '\u0001';
                        }
                        String string11 = c != '\u0000' ? stringArray6[i].substring(1) : stringArray6[i];
                        window.addNick(c, string11);
                    }
                    return;
                }
                case 366: {
                    this.uihandler.getChannel(stringArray2[2]).printNicks();
                    return;
                }
                case 368: {
                    this.uihandler.getConsole().writeInfo("Ban = " + stringArray2[3]);
                    return;
                }
                case 374: {
                    this.uihandler.getConsole().writeInfo(stringArray[2]);
                    return;
                }
                case 372: {
                    if (!this.showinput) return;
                    this.uihandler.getConsole().writeAction(stringArray[2]);
                    return;
                }
                case 376: {
                    return;
                }
                case 433: {
                    if (!this.nicktried && !this.altnick.trim().equals("")) {
                        this.uihandler.getConsole().writeInfo(Irc.language.get("nickinuse") + " '" + this.altnick + "'");
                        Irc.writeLine("NICK " + this.altnick);
                        UIHandler.nick = this.altnick;
                        this.nicktried = true;
                        return;
                    }
                    Window window = this.uihandler.getConsole();
                    window.nickChangeAction();
                    return;
                }
                case 475: {
                    this.uihandler.getConsole().writeInfo(stringArray[2] + " " + Irc.language.get("badchannelkey") + " " + stringArray2[2]);
                    return;
                }
                default: {
                    if (!this.showinput) return;
                    this.uihandler.getConsole().writeAction("-" + string);
                }
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setNeedUpdate(boolean bl) {
        this.needupdate = bl;
    }

    private void addWhois(String string, String string2) {
        this.uihandler.getConsole().writeAction("* " + string + " " + string2);
        this.whois = this.whois + string2;
    }

    private String[] parseLine(String string) {
        int n;
        String[] stringArray = new String[3];
        if (string.charAt(0) == ':') {
            stringArray[0] = string.substring(1, string.indexOf(32));
            n = string.indexOf(" ") + 1;
        } else {
            stringArray[0] = null;
            n = 0;
        }
        int n2 = string.indexOf(":", n);
        if (n2 != -1) {
            stringArray[1] = string.substring(n, n2);
            stringArray[2] = string.substring(n2 + 1);
        } else {
            n2 = string.lastIndexOf(32);
            if (n2 != -1) {
                stringArray[1] = string.substring(n, n2);
                stringArray[2] = string.substring(n2 + 1);
            } else {
                stringArray[1] = string.substring(n);
                stringArray[2] = null;
            }
        }
        return stringArray;
    }

    private String parseTime(String string) {
        String string2 = "";
        try {
            int n = Integer.parseInt(string);
            int n2 = n / 86400;
            int n3 = (n -= n2 * 86400) / 3600;
            int n4 = (n -= n3 * 3600) / 60;
            string2 = new String(n2 + Irc.language.get("day") + " " + n3 + Irc.language.get("hour") + " " + n4 + Irc.language.get("min") + " " + (n -= n4 * 60) + Irc.language.get("sec"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string2;
    }
}

