/*
 * Decompiled with CFR 0.152.
 */
package inettools;

import inettools.Irc;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;
import lib.Utils.Utils;

public class Database {
    String profilename;
    String nick;
    String altnick;
    String host;
    int port;
    String channels;
    String username;
    String realname;
    String passwd;
    String start_commands;
    String quit_message;
    int[] idxarray;
    int profileidx = -1;
    boolean smiles = true;
    boolean timestamp = false;
    boolean showtime = true;
    boolean usecolor = true;
    boolean showinput = false;
    boolean showhosts = false;
    boolean ajoinkick = true;
    boolean poolmode = true;
    int pooltime = 20;
    int clockpos = 0;
    boolean vibra = false;
    boolean sound = false;
    boolean light = false;
    boolean onquery = false;
    boolean onaddress = false;
    boolean onnotice = false;
    boolean onaction = false;
    int userId = 0;
    int fontsize = 8;
    String encoding = "Windows-1251";
    String ctcp_info = Irc.language.get("userinfovalue");
    String template_query = "%bold%%color%8,2%nick%%color%%bold%, ";
    int buflines = 15;
    int height_diff = 0;
    private static final String STORE_CONFIG = "irccfg";
    private static final String STORE_PROFILE = "ircprof";

    public void load() {
        try {
            String string;
            byte[] byArray;
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
            int n = recordStore.getNumRecords();
            try {
                byArray = recordStore.getRecord(1);
                string = new DataInputStream(new ByteArrayInputStream(byArray)).readUTF();
            }
            catch (Exception exception) {
                string = "";
            }
            if (!string.equals("1.7 beta 6 mod sniper (1.0)")) {
                recordStore.closeRecordStore();
                try {
                    RecordStore.deleteRecordStore((String)STORE_CONFIG);
                    RecordStore.deleteRecordStore((String)STORE_PROFILE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeUTF("1.7 beta 6 mod sniper (1.0)");
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                recordStore.addRecord(byArray, 0, byArray.length);
                byArray = new byte[]{};
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray, 0, byArray.length);
                this.save_profile();
                this.save_advanced();
                this.profileidx = 0;
            } else {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(2)));
                this.profileidx = dataInputStream.readInt();
                dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(3)));
                this.timestamp = dataInputStream.readBoolean();
                this.usecolor = dataInputStream.readBoolean();
                this.smiles = dataInputStream.readBoolean();
                this.showinput = dataInputStream.readBoolean();
                this.showhosts = dataInputStream.readBoolean();
                this.ajoinkick = dataInputStream.readBoolean();
                this.userId = dataInputStream.readInt();
                this.vibra = dataInputStream.readBoolean();
                this.sound = dataInputStream.readBoolean();
                this.light = dataInputStream.readBoolean();
                this.onquery = dataInputStream.readBoolean();
                this.onaddress = dataInputStream.readBoolean();
                this.onnotice = dataInputStream.readBoolean();
                this.onaction = dataInputStream.readBoolean();
                this.fontsize = dataInputStream.readInt();
                this.encoding = dataInputStream.readUTF();
                this.height_diff = dataInputStream.readInt();
                this.buflines = dataInputStream.readInt();
                this.ctcp_info = dataInputStream.readUTF();
                this.template_query = dataInputStream.readUTF();
                this.showtime = dataInputStream.readBoolean();
                this.poolmode = dataInputStream.readBoolean();
                this.pooltime = dataInputStream.readInt();
                this.clockpos = dataInputStream.readInt();
                dataInputStream.close();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getProfiles();
        this.setProfile(this.profileidx);
    }

    public String[] getProfiles() {
        String[] stringArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_PROFILE, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(new byte[4], 0, 4);
                this.idxarray = new int[0];
                stringArray = new String[]{};
            } else {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(1)));
                recordStore.closeRecordStore();
                int n = dataInputStream.readInt();
                stringArray = new String[n];
                this.idxarray = new int[n];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = dataInputStream.readUTF();
                    this.idxarray[i] = dataInputStream.readInt();
                }
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    public void setProfile(int n) {
        if (n < 0) {
            this.profilename = "Default";
            this.nick = "";
            this.altnick = "";
            this.host = "irc.senet.ru";
            this.port = 6667;
            this.channels = "#senet";
            this.username = "";
            this.realname = "";
            this.passwd = "";
            this.start_commands = "";
            this.quit_message = "InetTools IRC 1.7 beta 6 mod sniper (1.0)  \u043e\u0442 \u0425\u0410\u041e\u0421\u0430 mod sniper.";
        } else if (n < this.idxarray.length) {
            try {
                int n2 = this.idxarray[n];
                RecordStore recordStore = RecordStore.openRecordStore((String)STORE_PROFILE, (boolean)false);
                if (n2 > 0) {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(n2)));
                    this.profilename = dataInputStream.readUTF();
                    this.nick = dataInputStream.readUTF();
                    this.altnick = dataInputStream.readUTF();
                    this.host = dataInputStream.readUTF();
                    this.port = dataInputStream.readInt();
                    this.channels = dataInputStream.readUTF();
                    this.username = dataInputStream.readUTF();
                    this.realname = dataInputStream.readUTF();
                    this.passwd = dataInputStream.readUTF();
                    this.start_commands = dataInputStream.readUTF();
                    this.quit_message = dataInputStream.readUTF();
                }
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addProfile() {
        this.editProfile(this.idxarray.length);
    }

    public void editProfile(int n) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_PROFILE, (boolean)false);
            this.editProfileName(recordStore, n, this.profilename);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this.profilename);
            dataOutputStream.writeUTF(this.nick);
            dataOutputStream.writeUTF(this.altnick);
            dataOutputStream.writeUTF(this.host);
            dataOutputStream.writeInt(this.port);
            dataOutputStream.writeUTF(this.channels);
            dataOutputStream.writeUTF(this.username);
            dataOutputStream.writeUTF(this.realname);
            dataOutputStream.writeUTF(this.passwd);
            dataOutputStream.writeUTF(this.start_commands);
            dataOutputStream.writeUTF(this.quit_message);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            recordStore.setRecord(this.idxarray[n], byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deleteProfile(int n) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_PROFILE, (boolean)false);
            recordStore.deleteRecord(this.idxarray[n]);
            this.editProfileName(recordStore, n, null);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void editProfileName(RecordStore recordStore, int n, String string) throws Exception {
        int n2;
        boolean bl = false;
        byte[] byArray = recordStore.getRecord(1);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n3 = dataInputStream.readInt();
        if (string == null && n >= 0 && n < n3) {
            this.idxarray = new int[--n3];
        } else if (n < 0 || n >= n3) {
            this.idxarray = new int[++n3];
            bl = true;
        } else if (string == null) {
            return;
        }
        dataOutputStream.writeInt(n3);
        for (n2 = 0; !(n2 >= n3 || n2 == n3 - 1 && bl); ++n2) {
            if (n2 == n) {
                if (string != null) {
                    dataInputStream.readUTF();
                    dataOutputStream.writeUTF(string);
                    this.idxarray[n2] = dataInputStream.readInt();
                    dataOutputStream.writeInt(this.idxarray[n2]);
                    continue;
                }
                dataInputStream.readUTF();
                dataInputStream.readInt();
            }
            dataOutputStream.writeUTF(dataInputStream.readUTF());
            this.idxarray[n2] = dataInputStream.readInt();
            dataOutputStream.writeInt(this.idxarray[n2]);
        }
        if (bl) {
            dataOutputStream.writeUTF(string);
            this.idxarray[n2] = recordStore.getNextRecordID();
            dataOutputStream.writeInt(this.idxarray[n2]);
            recordStore.addRecord(new byte[0], 0, 0);
        }
        byArray = byteArrayOutputStream.toByteArray();
        dataInputStream.close();
        dataOutputStream.close();
        recordStore.setRecord(1, byArray, 0, byArray.length);
        if (this.profileidx >= this.idxarray.length) {
            this.profileidx = this.idxarray.length - 1;
        }
    }

    public String[] getChannels() {
        return Utils.hasNoValue(this.channels) ? null : Utils.splitString(this.channels, ";");
    }

    public String[] getStartCommands() {
        return Utils.hasNoValue(this.start_commands) ? null : Utils.splitString(this.start_commands, ";");
    }

    public void save_profile() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.profileidx);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
            recordStore.setRecord(2, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save_advanced() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(this.timestamp);
            dataOutputStream.writeBoolean(this.usecolor);
            dataOutputStream.writeBoolean(this.smiles);
            dataOutputStream.writeBoolean(this.showinput);
            dataOutputStream.writeBoolean(this.showhosts);
            dataOutputStream.writeBoolean(this.ajoinkick);
            dataOutputStream.writeInt(this.userId);
            dataOutputStream.writeBoolean(this.vibra);
            dataOutputStream.writeBoolean(this.sound);
            dataOutputStream.writeBoolean(this.light);
            dataOutputStream.writeBoolean(this.onquery);
            dataOutputStream.writeBoolean(this.onaddress);
            dataOutputStream.writeBoolean(this.onnotice);
            dataOutputStream.writeBoolean(this.onaction);
            dataOutputStream.writeInt(this.fontsize);
            dataOutputStream.writeUTF(this.encoding);
            dataOutputStream.writeInt(this.height_diff);
            dataOutputStream.writeInt(this.buflines);
            dataOutputStream.writeUTF(this.ctcp_info);
            dataOutputStream.writeUTF(this.template_query);
            dataOutputStream.writeBoolean(this.showtime);
            dataOutputStream.writeBoolean(this.poolmode);
            dataOutputStream.writeInt(this.pooltime);
            dataOutputStream.writeInt(this.clockpos);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
            recordStore.setRecord(3, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

