/*
 * Decompiled with CFR 0.152.
 */
package inettools;

import inettools.Database;
import inettools.Images;
import inettools.IrcConnection;
import inettools.Listener;
import inettools.Resources;
import inettools.SocketIrc;
import inettools.UIHandler;
import inettools.Window;
import inettools.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import lib.GraphicControls.MessageBox;
import lib.Resources.ResourcesUTF8;

public class Irc
extends MIDlet
implements CommandListener,
WindowListener {
    public static final String VERSION = "1.7 beta 6 mod sniper (1.0)";
    private static final int MAIN_MENU = 0;
    private static final int FORM_PROFILES = 1;
    private static final int FORM_CONFIG = 2;
    private static final int FORM_CONFIG_EDIT = 3;
    private static final int FORM_SETTINGS = 4;
    public static boolean minimized = false;
    public static Displayable lastDisplay;
    public static ResourcesUTF8 language;
    private boolean isLanguage;
    public static Display display;
    protected static List mainmenu;
    private MessageBox mb;
    private int currentform;
    private boolean running;
    private static IrcConnection irc;
    private static Listener listener;
    private static UIHandler uihandler;
    private static Database db;
    private Command cmd_connect;
    private Command cmd_profiles;
    private Command cmd_settings;
    private Command cmd_exit;
    private Command cmd_profile_add;
    private Command cmd_profile_edit;
    private Command cmd_profile_delete;
    private Command cmd_ok;
    private Command cmd_cancel;
    private Command cmd_back;
    private TextField tf_profilename;
    private TextField tf_nick;
    private TextField tf_altnick;
    private TextField tf_host;
    private TextField tf_port;
    private TextField tf_channels;
    private TextField tf_username;
    private TextField tf_realname;
    private TextField tf_start_commands;
    private TextField tf_quit_message;
    private TextField tf_passwd;
    private TextField tf_buflines;
    private TextField tf_height_diff;
    private TextField tf_pooltime;
    private ChoiceGroup cg_misc;
    private ChoiceGroup cg_font;
    private ChoiceGroup cg_encoding;
    private ChoiceGroup cg_notification;
    private ChoiceGroup cg_notificationtypes;
    private ChoiceGroup cg_;
    private TextBox tb;
    public static String QUIT_MESSAGE;
    private List list_profile;
    private TextField tf_ctcp_info;
    private TextField tf_template_query;

    public Irc() {
        display = Display.getDisplay((MIDlet)this);
        new Images();
        new Resources();
        language = new ResourcesUTF8("/language.dat");
        this.isLanguage = language.load();
        mainmenu = new List("InetTools IRC 1.7 beta 6 mod sniper (1.0)", 3);
        mainmenu.append(language.get("connect"), Images.icons.getImage(0));
        mainmenu.append(language.get("profiles"), Images.icons.getImage(0));
        mainmenu.append(language.get("settings"), Images.icons.getImage(0));
        mainmenu.append(language.get("about"), Images.icons.getImage(0));
        mainmenu.append(language.get("exit"), Images.icons.getImage(0));
        mainmenu.setCommandListener((CommandListener)this);
        this.cmd_connect = new Command(language.get("connect"), 4, 1);
        this.cmd_profiles = new Command(language.get("profiles"), 1, 2);
        this.cmd_settings = new Command(language.get("settings"), 1, 3);
        this.cmd_exit = new Command(language.get("exit"), 7, 6);
        this.cmd_profile_add = new Command(language.get("profileadd"), 1, 2);
        this.cmd_profile_edit = new Command(language.get("profileedit"), 1, 3);
        this.cmd_profile_delete = new Command(language.get("profiledelete"), 1, 4);
        this.cmd_ok = new Command(language.get("ok"), 4, 1);
        this.cmd_cancel = new Command(language.get("cancel"), 7, 10);
        this.cmd_back = new Command(language.get("back"), 7, 10);
        db = new Database();
        this.running = false;
    }

    public void startApp() {
        if (this.isLanguage) {
            if (minimized) {
                display.setCurrent(lastDisplay);
            } else if (!this.running) {
                db.load();
                display.setCurrent((Displayable)mainmenu);
                this.currentform = 0;
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getViaHttpConnection(String string) throws IOException {
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        String string2 = null;
        try {
            httpConnection = (HttpConnection)Connector.open((String)string);
            inputStream = httpConnection.openInputStream();
            int n = (int)httpConnection.getLength();
            if (n <= 0) {
                int n2;
                while ((n2 = inputStream.read()) != -1) {
                    if (string2 == null) {
                        string2 = "" + (char)n2;
                        continue;
                    }
                    string2 = string2 + (char)n2;
                }
                Irc.db.userId = this.parseInt(string2);
                db.save_advanced();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmd_connect) {
            QUIT_MESSAGE = Irc.db.quit_message;
            irc = new SocketIrc(Irc.db.encoding);
            uihandler = new UIHandler(this, db, display);
            uihandler.setDisplay((Displayable)uihandler.getConsole());
            listener = new Listener(db, irc, uihandler);
            listener.start();
            System.gc();
        } else if (command == this.cmd_exit) {
            try {
                this.destroyApp(true);
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {
                // empty catch block
            }
            this.notifyDestroyed();
            System.gc();
        } else if (command == List.SELECT_COMMAND && this.currentform == 0) {
            String string = mainmenu.getString(mainmenu.getSelectedIndex());
            if (string.equals(language.get("connect"))) {
                this.commandAction(this.cmd_connect, null);
            }
            if (string.equals(language.get("profiles"))) {
                this.commandAction(this.cmd_profiles, null);
            }
            if (string.equals(language.get("settings"))) {
                this.commandAction(this.cmd_settings, null);
            }
            if (string.equals(language.get("about"))) {
                this.mb = new MessageBox(display, this, null, null, this.cmd_back, language.get("about"), language.get("aboutvalue1") + '\n' + language.get("aboutvalue2") + '\n' + language.get("aboutvalue3"), 1, 8, Irc.db.height_diff);
                display.setCurrent((Displayable)this.mb);
            }
            if (string.equals(language.get("exit"))) {
                this.commandAction(this.cmd_exit, null);
            }
        } else if (command == this.cmd_back) {
            display.setCurrent((Displayable)mainmenu);
        } else if ((command == this.cmd_ok || command == this.cmd_cancel || command == List.SELECT_COMMAND) && this.currentform != 0) {
            if (this.currentform == 1) {
                this.currentform = 0;
                Irc.db.profileidx = this.list_profile.getSelectedIndex();
                db.save_profile();
                this.list_profile = null;
                db.setProfile(Irc.db.profileidx);
                display.setCurrent((Displayable)mainmenu);
            } else if (this.currentform == 2 || this.currentform == 3) {
                boolean bl;
                boolean bl2 = bl = this.currentform == 3;
                if (command == this.cmd_ok) {
                    if (this.tf_nick.getString().equals("")) {
                        Alert alert = new Alert(language.get("error"), language.get("nonickerror"), null, AlertType.WARNING);
                        alert.setTimeout(-2);
                        display.setCurrent((Displayable)alert);
                        return;
                    }
                    if (this.tf_realname.getString().equals("")) {
                        Alert alert = new Alert(language.get("error"), language.get("noidenterror"), null, AlertType.WARNING);
                        alert.setTimeout(-2);
                        display.setCurrent((Displayable)alert);
                        return;
                    }
                    if (this.tf_username.getString().equals("")) {
                        Alert alert = new Alert(language.get("meerror"), language.get("nonameerror"), null, AlertType.WARNING);
                        alert.setTimeout(-2);
                        display.setCurrent((Displayable)alert);
                        return;
                    }
                    this.currentform = 1;
                    Irc.db.profilename = this.tf_profilename.getString();
                    Irc.db.nick = this.tf_nick.getString();
                    Irc.db.altnick = this.tf_altnick.getString();
                    Irc.db.host = this.tf_host.getString();
                    Irc.db.port = this.parseInt(this.tf_port.getString());
                    Irc.db.channels = this.tf_channels.getString();
                    Irc.db.username = this.tf_username.getString();
                    Irc.db.realname = this.tf_realname.getString();
                    Irc.db.passwd = this.tf_passwd.getString();
                    Irc.db.start_commands = this.tf_start_commands.getString();
                    Irc.db.quit_message = this.tf_quit_message.getString();
                    if (bl) {
                        db.editProfile(this.list_profile.getSelectedIndex());
                    } else {
                        db.addProfile();
                    }
                }
                this.currentform = 1;
                this.tf_profilename = null;
                this.tf_nick = null;
                this.tf_altnick = null;
                this.tf_host = null;
                this.tf_port = null;
                this.tf_channels = null;
                this.tf_username = null;
                this.tf_realname = null;
                this.tf_passwd = null;
                this.tf_start_commands = null;
                this.tf_quit_message = null;
                if (command == this.cmd_ok) {
                    this.commandAction(this.cmd_profiles, null);
                } else {
                    display.setCurrent((Displayable)this.list_profile);
                }
            } else if (this.currentform == 4) {
                this.currentform = 0;
                if (command == this.cmd_ok) {
                    Irc.db.timestamp = this.cg_misc.isSelected(0);
                    Irc.db.usecolor = this.cg_misc.isSelected(1);
                    Irc.db.smiles = this.cg_misc.isSelected(2);
                    Irc.db.showinput = this.cg_misc.isSelected(3);
                    Irc.db.showhosts = this.cg_misc.isSelected(4);
                    Irc.db.ajoinkick = this.cg_misc.isSelected(5);
                    Irc.db.showtime = this.cg_misc.isSelected(6);
                    Irc.db.poolmode = this.cg_misc.isSelected(7);
                    Irc.db.vibra = this.cg_notificationtypes.isSelected(0);
                    Irc.db.sound = this.cg_notificationtypes.isSelected(1);
                    Irc.db.light = this.cg_notificationtypes.isSelected(2);
                    Irc.db.onquery = this.cg_notification.isSelected(0);
                    Irc.db.onaddress = this.cg_notification.isSelected(1);
                    Irc.db.onnotice = this.cg_notification.isSelected(2);
                    Irc.db.onaction = this.cg_notification.isSelected(3);
                    if (this.cg_font.getSelectedIndex() == 0) {
                        Irc.db.fontsize = 8;
                    } else if (this.cg_font.getSelectedIndex() == 1) {
                        Irc.db.fontsize = 0;
                    } else if (this.cg_font.getSelectedIndex() == 2) {
                        Irc.db.fontsize = 16;
                    }
                    Irc.db.encoding = this.cg_encoding.getString(this.cg_encoding.getSelectedIndex());
                    Irc.db.height_diff = this.parseInt(this.tf_height_diff.getString());
                    Irc.db.pooltime = this.parseInt(this.tf_pooltime.getString());
                    Irc.db.buflines = this.parseInt(this.tf_buflines.getString());
                    Irc.db.ctcp_info = this.tf_ctcp_info.getString();
                    Irc.db.template_query = this.tf_template_query.getString();
                    db.save_advanced();
                }
                this.cg_misc = null;
                this.cg_notificationtypes = null;
                this.cg_notification = null;
                this.cg_font = null;
                this.cg_encoding = null;
                this.tf_height_diff = null;
                this.tf_pooltime = null;
                this.tf_buflines = null;
                this.tf_ctcp_info = null;
                this.tf_template_query = null;
                display.setCurrent((Displayable)mainmenu);
            }
        } else {
            Form form;
            if (command == this.cmd_profiles) {
                String[] stringArray = db.getProfiles();
                this.list_profile = new List(language.get("profiles"), 3);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.list_profile.append(stringArray[i], null);
                }
                if (Irc.db.profileidx > 0) {
                    this.list_profile.setSelectedIndex(Irc.db.profileidx, true);
                }
                this.list_profile.addCommand(this.cmd_profile_add);
                this.list_profile.addCommand(this.cmd_profile_edit);
                this.list_profile.addCommand(this.cmd_profile_delete);
                this.list_profile.addCommand(this.cmd_ok);
                this.list_profile.setCommandListener((CommandListener)this);
                display.setCurrent((Displayable)this.list_profile);
                this.currentform = 1;
                if (stringArray.length == 0) {
                    this.commandAction(this.cmd_profile_add, null);
                }
                return;
            }
            if (command == this.cmd_profile_add || command == this.cmd_profile_edit) {
                if (command == this.cmd_profile_edit) {
                    db.setProfile(this.list_profile.getSelectedIndex());
                } else {
                    db.setProfile(-1);
                }
                this.tf_profilename = new TextField(language.get("profilename"), Irc.db.profilename, 50, 0);
                this.tf_nick = new TextField(language.get("nick"), Irc.db.nick, 50, 0);
                this.tf_altnick = new TextField(language.get("altnick"), Irc.db.altnick, 50, 0);
                this.tf_host = new TextField(language.get("server"), Irc.db.host, 200, 4);
                this.tf_port = new TextField(language.get("port"), new Integer(Irc.db.port).toString(), 5, 2);
                this.tf_channels = new TextField(language.get("channels"), Irc.db.channels, 600, 0);
                this.tf_username = new TextField(language.get("username"), Irc.db.username, 50, 0);
                this.tf_realname = new TextField(language.get("realname"), Irc.db.realname, 50, 0);
                this.tf_passwd = new TextField(language.get("serverpassword"), Irc.db.passwd, 50, 65536);
                this.tf_start_commands = new TextField(language.get("startcommands"), Irc.db.start_commands, 1000, 0);
                this.tf_quit_message = new TextField(language.get("quitmessage"), Irc.db.quit_message, 1000, 0);
                form = new Form(language.get("profiles"));
                form.append((Item)this.tf_profilename);
                form.append((Item)this.tf_nick);
                form.append((Item)this.tf_altnick);
                form.append((Item)this.tf_host);
                form.append((Item)this.tf_port);
                form.append((Item)this.tf_channels);
                form.append((Item)this.tf_username);
                form.append((Item)this.tf_realname);
                form.append((Item)this.tf_passwd);
                form.append((Item)this.tf_start_commands);
                form.append((Item)this.tf_quit_message);
                this.currentform = command == this.cmd_profile_edit ? 3 : 2;
            } else {
                if (command == this.cmd_profile_delete) {
                    db.deleteProfile(this.list_profile.getSelectedIndex());
                    this.commandAction(this.cmd_profiles, null);
                    return;
                }
                if (command == this.cmd_settings) {
                    this.cg_misc = new ChoiceGroup(language.get("miscoptions"), 2);
                    this.cg_misc.append(language.get("timestamp"), null);
                    this.cg_misc.append(language.get("colors") + ", " + language.get("styles"), null);
                    this.cg_misc.append(language.get("smiles"), null);
                    this.cg_misc.append(language.get("servermessages"), null);
                    this.cg_misc.append(language.get("showhosts"), null);
                    this.cg_misc.append(language.get("autojoinafterkick"), null);
                    this.cg_misc.append(language.get("showtime"), null);
                    this.cg_misc.append(language.get("socketping"), null);
                    this.cg_misc.setSelectedIndex(0, Irc.db.timestamp);
                    this.cg_misc.setSelectedIndex(1, Irc.db.usecolor);
                    this.cg_misc.setSelectedIndex(2, Irc.db.smiles);
                    this.cg_misc.setSelectedIndex(3, Irc.db.showinput);
                    this.cg_misc.setSelectedIndex(4, Irc.db.showhosts);
                    this.cg_misc.setSelectedIndex(5, Irc.db.ajoinkick);
                    this.cg_misc.setSelectedIndex(6, Irc.db.showtime);
                    this.cg_misc.setSelectedIndex(7, Irc.db.poolmode);
                    this.cg_notificationtypes = new ChoiceGroup(language.get("notificationtypes"), 2);
                    this.cg_notificationtypes.append(language.get("vibra"), null);
                    this.cg_notificationtypes.append(language.get("sounds"), null);
                    this.cg_notificationtypes.append(language.get("light"), null);
                    this.cg_notificationtypes.setSelectedIndex(0, Irc.db.vibra);
                    this.cg_notificationtypes.setSelectedIndex(1, Irc.db.sound);
                    this.cg_notificationtypes.setSelectedIndex(2, Irc.db.light);
                    this.cg_notification = new ChoiceGroup(language.get("notification"), 2);
                    this.cg_notification.append(language.get("query"), null);
                    this.cg_notification.append(language.get("address"), null);
                    this.cg_notification.append(language.get("notice"), null);
                    this.cg_notification.append(language.get("action"), null);
                    this.cg_notification.setSelectedIndex(0, Irc.db.onquery);
                    this.cg_notification.setSelectedIndex(1, Irc.db.onaddress);
                    this.cg_notification.setSelectedIndex(2, Irc.db.onnotice);
                    this.cg_notification.setSelectedIndex(3, Irc.db.onaction);
                    this.cg_font = new ChoiceGroup(language.get("font"), 1);
                    this.cg_font.append(language.get("smallphonefont"), null);
                    this.cg_font.append(language.get("mediumphonefont"), null);
                    this.cg_font.append(language.get("largephonefont"), null);
                    if (Irc.db.fontsize == 8) {
                        this.cg_font.setSelectedIndex(0, true);
                    } else if (Irc.db.fontsize == 0) {
                        this.cg_font.setSelectedIndex(1, true);
                    } else if (Irc.db.fontsize == 16) {
                        this.cg_font.setSelectedIndex(2, true);
                    } else {
                        this.cg_font.setSelectedIndex(0, true);
                    }
                    this.cg_encoding = new ChoiceGroup(language.get("encoding"), 1);
                    this.cg_encoding.append("ISO-8859-1", null);
                    this.cg_encoding.append("ISO-8859-2", null);
                    this.cg_encoding.append("UTF-8", null);
                    this.cg_encoding.append("KOI8-R", null);
                    this.cg_encoding.append("Windows-1251", null);
                    if (Irc.db.encoding.equals("ISO-8859-1")) {
                        this.cg_encoding.setSelectedIndex(0, true);
                    } else if (Irc.db.encoding.equals("ISO-8859-2")) {
                        this.cg_encoding.setSelectedIndex(1, true);
                    } else if (Irc.db.encoding.equals("UTF-8")) {
                        this.cg_encoding.setSelectedIndex(2, true);
                    } else if (Irc.db.encoding.equals("KOI8-R")) {
                        this.cg_encoding.setSelectedIndex(3, true);
                    } else if (Irc.db.encoding.equals("Windows-1251")) {
                        this.cg_encoding.setSelectedIndex(4, true);
                    } else {
                        this.cg_encoding.setSelectedIndex(0, true);
                    }
                    this.tf_height_diff = new TextField(language.get("displayheightincrease"), new Integer(Irc.db.height_diff).toString(), 3, 2);
                    this.tf_pooltime = new TextField(language.get("socketpingtime"), new Integer(Irc.db.pooltime).toString(), 5, 2);
                    this.tf_buflines = new TextField(language.get("buffer"), new Integer(Irc.db.buflines).toString(), 3, 2);
                    this.tf_ctcp_info = new TextField(language.get("userinfolabel"), Irc.db.ctcp_info, 1000, 0);
                    this.tf_template_query = new TextField(language.get("templatequery"), Irc.db.template_query, 1000, 0);
                    form = new Form(language.get("settings"));
                    form.append((Item)this.cg_misc);
                    form.append((Item)this.tf_pooltime);
                    form.append((Item)this.cg_notificationtypes);
                    form.append((Item)this.cg_notification);
                    form.append((Item)this.cg_font);
                    form.append((Item)this.cg_encoding);
                    form.append((Item)this.tf_height_diff);
                    form.append((Item)this.tf_buflines);
                    form.append((Item)this.tf_ctcp_info);
                    form.append((Item)this.tf_template_query);
                    this.currentform = 4;
                } else {
                    return;
                }
            }
            form.addCommand(this.cmd_ok);
            form.addCommand(this.cmd_cancel);
            form.setCommandListener((CommandListener)this);
            display.setCurrent((Displayable)form);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
        if (irc != null && irc.isConnected()) {
            if (!bl) {
                throw new MIDletStateChangeException(language.get("error"));
            }
            Irc.disconnect("QUIT : " + Irc.db.quit_message);
        }
    }

    private int parseInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static void writeLine(String string) {
        if (irc.isConnected()) {
            String string2 = irc.writeData(string + "\r\n");
            if (string2 != null) {
                uihandler.getConsole().writeInfo(string2);
            }
            listener.setNeedUpdate(true);
        }
    }

    public static void forceUpdate() {
        listener.setNeedUpdate(true);
    }

    public static void disconnect(String string) {
        if (irc.isConnected()) {
            String string2 = irc.writeData(string + "\r\n");
            if (string2 != null) {
                uihandler.getConsole().writeInfo(string2);
            }
            listener.setNeedUpdate(true);
            listener = null;
            uihandler = null;
            irc.disconnect();
        }
    }

    public static int getBytesIn() {
        return irc.getBytesIn();
    }

    public static int getBytesOut() {
        return irc.getBytesOut();
    }

    public void openUrl(String string) {
        try {
            this.platformRequest(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onUrlSelect(Window window, String string) {
        this.openUrl(string);
    }
}

