/*
 * Decompiled with CFR 0.152.
 */
package inettools;

import inettools.Irc;
import inettools.IrcConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import lib.Utils.Utils;

public class SocketIrc
extends IrcConnection {
    private StreamConnection connector;
    private DataInputStream in;
    private DataOutputStream out;
    private String encoding;
    private String outbuf;
    private boolean connected;
    private int bytein;
    private int byteout;

    public SocketIrc(String string) {
        this.encoding = string;
        this.bytein = 0;
        this.byteout = 0;
        this.connected = false;
    }

    public String connect(String string, int n, String string2) {
        String string3 = null;
        try {
            this.connector = (StreamConnection)Connector.open((String)("socket://" + string + ":" + n), (int)3);
            this.in = this.connector.openDataInputStream();
            this.out = this.connector.openDataOutputStream();
            this.outbuf = null;
            this.connected = true;
            string3 = this.writeData(string2);
        }
        catch (Exception exception) {
            string3 = Irc.language.get("errorconnecting");
            string3 = string3 + Irc.language.get("exception") + ": " + exception.getMessage();
            return string3;
        }
        return null;
    }

    public void disconnect() {
        if (this.connected) {
            try {
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
                if (this.in != null) {
                    this.in.close();
                }
                this.connected = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String updateConnection() {
        if (this.outbuf != null && this.connected) {
            try {
                byte[] byArray = this.stringToByteArray(this.outbuf, this.encoding);
                this.outbuf = null;
                this.out.write(byArray);
                this.out.flush();
                this.byteout += byArray.length;
            }
            catch (Exception exception) {
                String string = Irc.language.get("socketioerror");
                string = string + Irc.language.get("Exception") + ": " + exception.getMessage();
                this.connected = false;
                return string;
            }
        }
        return null;
    }

    public String readLine() {
        String string = null;
        try {
            byte[] byArray = Utils.readLine(this.in);
            if (byArray == null) {
                return null;
            }
            this.bytein += byArray.length + 40;
            string = this.byteArrayToString(byArray, this.encoding);
        }
        catch (Exception exception) {
            this.connected = false;
        }
        return string;
    }

    public String writeData(String string) {
        this.outbuf = this.outbuf == null ? string : this.outbuf + string;
        return this.updateConnection();
    }

    public boolean hasDataInBuffer() {
        try {
            return this.in.available() > 0;
        }
        catch (IOException iOException) {
            return this.connected;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getBytesIn() {
        return this.bytein;
    }

    public int getBytesOut() {
        return this.byteout;
    }
}

