/*
 * Decompiled with CFR 0.152.
 */
package lib.Font;

import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class CopyOfSampleFont {
    public static final int STYLE_BOLD = 0;
    public static final int STYLE_PLAIN = 1;
    public static final int STYLE_UNDERLINED = 2;
    private String[][] fontData;
    private InputStream in;
    public int size;
    public int style = 1;
    public int bgColor = 0xFFFFFF;
    public int fontColor = 0;
    public int height;
    public int[] width;

    public CopyOfSampleFont(String string) {
        this.in = this.getClass().getResourceAsStream(string);
        try {
            int n;
            this.size = this.in.read() + 1;
            this.height = this.in.read();
            this.width = new int[this.size];
            for (n = 0; n < this.size; ++n) {
                this.width[n] = this.in.read();
            }
            this.fontData = new String[this.size][this.height];
            for (n = 0; n < this.size; ++n) {
                for (int i = 0; i < this.height; ++i) {
                    this.fontData[n][i] = "";
                    for (int j = 0; j < this.bytesPerSymbol(this.width[n]); ++j) {
                        String[] stringArray = this.fontData[n];
                        int n2 = i;
                        stringArray[n2] = stringArray[n2] + this.DecToBin(this.in.read());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String DecToBin(int n) {
        String string = Integer.toBinaryString(n);
        if (string.length() < 8) {
            string = "00000000".substring(string.length()) + string;
        }
        return string;
    }

    public void setBgColor(int n, int n2, int n3) {
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.bgColor = n << 16 | n2 << 8 | n3;
    }

    public void setBgColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        this.bgColor = n & 0xFFFFFF;
    }

    public void setFontColor(int n, int n2, int n3) {
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.fontColor = n << 16 | n2 << 8 | n3;
    }

    public void setFontColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        this.fontColor = n & 0xFFFFFF;
    }

    public void setStyle(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.style = n;
    }

    private int getStyle() {
        return this.style;
    }

    private int getBgColor() {
        return this.bgColor;
    }

    private int getFontColor() {
        return this.fontColor;
    }

    public int substringWidth(String string, int n) {
        int n2 = 0;
        for (int i = n; i < string.length(); ++i) {
            int n3 = string.charAt(i);
            if (n3 >= 1040 && n3 <= 1103) {
                n3 -= 848;
            }
            n2 += this.width[n3];
        }
        return n2;
    }

    public int substringWidth(String string, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            int n4 = string.charAt(i);
            if (n4 >= 1040 && n4 <= 1103) {
                n4 -= 848;
            }
            n3 += this.width[n4];
        }
        return n3;
    }

    public int stringWidth(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (n2 >= 1040 && n2 <= 1103) {
                n2 -= 848;
            }
            n += this.width[n2];
        }
        return n;
    }

    public void drawString(Graphics graphics, String string, int n, int n2) {
        for (int i = 0; i < string.length(); ++i) {
            int n3 = string.charAt(i);
            if (n3 >= 1040 && n3 <= 1103) {
                n3 -= 848;
            }
            this.drawChar(graphics, n3, n, n2);
            n += this.width[n3];
        }
    }

    public void drawChar(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = 0;
        if (this.style == 0 || this.style == 2) {
            n5 = 1;
        }
        if (this.bgColor != 0xFFFFFF) {
            graphics.setColor(this.bgColor);
            graphics.fillRect(n2, n3, this.width[n] + n5, this.height);
        }
        graphics.setColor(this.fontColor);
        if (this.style == 2 || this.style == 2) {
            graphics.drawLine(n4, n3 + this.height, n4 + this.width[n] + n5, n3 + this.height);
        }
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width[n] && j < this.fontData[n][i].length(); ++j) {
                if (this.fontData[n][i].charAt(j) == '0') {
                    graphics.drawLine(n4, n3, n4 + n5, n3);
                }
                ++n4;
            }
            ++n3;
            n4 = n2;
        }
    }

    private int bytesPerSymbol(int n) {
        if (n <= 8) {
            return 1;
        }
        if (n - n / 8 * 8 == 0) {
            return n / 8;
        }
        return n / 8 + 1;
    }
}

