/*
 * Decompiled with CFR 0.152.
 */
package inettools;

import inettools.Database;
import inettools.Images;
import inettools.IrcConnection;
import inettools.Listener;
import inettools.Resources;
import inettools.SocketIrc;
import inettools.UIHandler;
import inettools.Window;
import inettools.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import lib.GraphicControls.MessageBox;
import lib.Resources.ResourcesUTF8;

public class Irc
extends MIDlet
implements CommandListener,
WindowListener {
    private static final int FORM_CONFIG = 2;
    private static final int FORM_CONFIG_EDIT = 3;
    private static final int FORM_PROFILES = 1;
    private static final int FORM_SETTINGS = 4;
    private static final int MAIN_MENU = 0;
    public static String QUIT_MESSAGE;
    public static final String VERSION = "5.3.1 \u043e\u0442 _DeaD_'a";
    public static final String VERSIONSHORT = "5.3.1";
    private static Player action;
    private ChoiceGroup cg_;
    private ChoiceGroup cg_encoding;
    private ChoiceGroup cg_font;
    private ChoiceGroup cg_misc;
    private ChoiceGroup cg_notification;
    private ChoiceGroup cg_notificationtypes;
    private Command cmd_back;
    private Command cmd_cancel;
    private Command cmd_connect;
    private Command cmd_exit;
    private Command cmd_ok;
    private Command cmd_profile_add;
    private Command cmd_profile_delete;
    private Command cmd_profile_edit;
    private Command cmd_profiles;
    private Command cmd_settings;
    private int currentform;
    private static Database db;
    public static Display display;
    private static Player info;
    private static IrcConnection irc;
    private boolean isLanguage;
    private boolean isStyle;
    public static ResourcesUTF8 language;
    public static Displayable lastDisplay;
    private List list_profile;
    private static Listener listener;
    protected static List mainmenu;
    private MessageBox mb;
    private static Player message;
    public static boolean minimized;
    private boolean running;
    public static ResourcesUTF8 style;
    private TextBox tb;
    private TextField tf_BACKGROUND;
    private TextField tf_altnick;
    private TextField tf_buflines;
    private TextField tf_channels;
    private TextField tf_ctcp_info;
    private TextField tf_exitchan;
    private TextField tf_finger;
    private TextField tf_height_diff;
    private TextField tf_host;
    private TextField tf_msgo;
    private TextField tf_nick;
    private TextField tf_passwd;
    private TextField tf_pooltime;
    private TextField tf_port;
    private TextField tf_profilename;
    private TextField tf_quit_message;
    private TextField tf_realname;
    private TextField tf_smile2;
    private TextField tf_start_commands;
    private TextField tf_template_query;
    private TextField tf_textaway;
    private TextField tf_username;
    private static UIHandler uihandler;

    static {
        minimized = false;
    }

    public Irc() {
        display = Display.getDisplay((MIDlet)this);
        new Images();
        new Resources();
        language = new ResourcesUTF8("/language.dat");
        this.isLanguage = language.load();
        mainmenu = new List("m'IRC 5.3.1 \u043e\u0442 _DeaD_'a", 3);
        mainmenu.append(language.get("connect"), Images.icons.getImage(6));
        mainmenu.append(language.get("profiles"), Images.icons.getImage(7));
        mainmenu.append(language.get("settings"), Images.icons.getImage(8));
        mainmenu.append(language.get("about"), Images.icons.getImage(9));
        mainmenu.append(language.get("exit"), Images.icons.getImage(10));
        mainmenu.setCommandListener((CommandListener)this);
        this.cmd_connect = new Command(language.get("connect"), 4, 1);
        this.cmd_profiles = new Command(language.get("profiles"), 1, 2);
        this.cmd_settings = new Command(language.get("settings"), 1, 3);
        this.cmd_exit = new Command(language.get("exit"), 7, 6);
        this.cmd_profile_add = new Command(language.get("profileadd"), 1, 2);
        this.cmd_profile_edit = new Command(language.get("profileedit"), 1, 3);
        this.cmd_profile_delete = new Command(language.get("profiledelete"), 1, 4);
        this.cmd_ok = new Command(language.get("ok"), 4, 1);
        this.cmd_cancel = new Command(language.get("cancel"), 7, 10);
        this.cmd_back = new Command(language.get("back"), 7, 10);
        db = new Database();
        this.running = false;
    }

    public void commandAction(Command cmd, Displayable disp) {
        if (cmd == this.cmd_connect) {
            QUIT_MESSAGE = Irc.db.quit_message + " \u000314\u2022\u000313\u2022\u000312\u2022 \u042f \u0437\u0430\u044e\u0437\u0430\u043b Dmirc " + VERSIONSHORT + " \u000312\u2022\u000313\u2022\u000314\u2022\u00031 ";
            irc = new SocketIrc(Irc.db.encoding);
            uihandler = new UIHandler(this, db, display);
            uihandler.setDisplay((Displayable)uihandler.getConsole());
            listener = new Listener(db, irc, uihandler);
            listener.start();
            System.gc();
        } else if (cmd == this.cmd_exit) {
            try {
                this.destroyApp(true);
            }
            catch (MIDletStateChangeException msce) {
            }
            this.notifyDestroyed();
            System.gc();
        } else if (cmd == List.SELECT_COMMAND && this.currentform == 0) {
            String menuitem = mainmenu.getString(mainmenu.getSelectedIndex());
            if (menuitem.equals(language.get("connect"))) {
                this.commandAction(this.cmd_connect, null);
            }
            if (menuitem.equals(language.get("profiles"))) {
                this.commandAction(this.cmd_profiles, null);
            }
            if (menuitem.equals(language.get("settings"))) {
                this.commandAction(this.cmd_settings, null);
            }
            if (menuitem.equals(language.get("about"))) {
                this.mb = new MessageBox(display, this, null, null, this.cmd_back, language.get("about"), "\u042d\u0442\u043e \u0441\u0438\u043b\u044c\u043d\u043e\u043c\u043e\u0434\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b InetTools IRC \u043e\u0442 \u0425\u0410\u041e\u0421\u0430\r \u0415\u0441\u043b\u0438 \u0443 \u0432\u0430\u0441 \u0440\u0443\u043a\u0438 \u0440\u0430\u0441\u0442\u0443\u0442 \u0438\u0437 (_0_) \u0442\u043e \u0432\u0430\u043c \u0434\u043e\u0440\u043e\u0433\u0430 \u0432 dmenu - \u0441\u043f\u0440\u0430\u0432\u043a\u0430, \u0442\u0430\u043c \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0437\u043d\u0430\u043a\u043e\u043c\u0438\u0442\u044c\u0441\u044f \u0441 \u043d\u043e\u0432\u044b\u043c\u0438 \u0444\u0443\u043d\u043a\u0446\u0438\u044f\u043c\u0438 \n \u0421 \u0443\u0432\u0430\u0436\u0435\u043d\u0438\u0435\u043c _DeaD_\r\u00a9 \u0432\u0435\u0440\u0441\u0438\u044f 5.3.1 \u043e\u0442 DeaD'a///\u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043b\u043e\u0441\u044c \u043d\u0430 Nokia6230i, \u0432\u0441\u0435 \u0442\u0435\u0441\u0442\u044b \u043f\u0440\u043e\u0448\u043b\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e!", 1, 8, Irc.db.height_diff);
                display.setCurrent((Displayable)this.mb);
            }
            if (menuitem.equals(language.get("exit"))) {
                this.commandAction(this.cmd_exit, null);
            }
        } else if (cmd == this.cmd_back) {
            display.setCurrent((Displayable)mainmenu);
        } else if ((cmd == this.cmd_ok || cmd == this.cmd_cancel || cmd == List.SELECT_COMMAND) && this.currentform != 0) {
            if (this.currentform == 1) {
                this.currentform = 0;
                Irc.db.profileidx = this.list_profile.getSelectedIndex();
                db.save_profile();
                this.list_profile = null;
                db.setProfile(Irc.db.profileidx);
                display.setCurrent((Displayable)mainmenu);
            } else if (this.currentform == 2 || this.currentform == 3) {
                boolean editing;
                boolean bl = editing = this.currentform == 3;
                if (cmd == this.cmd_ok) {
                    if (this.tf_nick.getString().equals("")) {
                        Alert a = new Alert(language.get("error"), language.get("nonickerror"), null, AlertType.WARNING);
                        a.setTimeout(-2);
                        display.setCurrent((Displayable)a);
                        return;
                    }
                    if (this.tf_realname.getString().equals("")) {
                        Alert a = new Alert(language.get("error"), language.get("noidenterror"), null, AlertType.WARNING);
                        a.setTimeout(-2);
                        display.setCurrent((Displayable)a);
                        return;
                    }
                    if (this.tf_username.getString().equals("")) {
                        Alert a = new Alert(language.get("meerror"), language.get("nonameerror"), null, AlertType.WARNING);
                        a.setTimeout(-2);
                        display.setCurrent((Displayable)a);
                        return;
                    }
                    this.currentform = 1;
                    Irc.db.profilename = this.tf_profilename.getString();
                    Irc.db.nick = this.tf_nick.getString();
                    Irc.db.altnick = this.tf_altnick.getString();
                    Irc.db.host = this.tf_host.getString();
                    Irc.db.port = this.parseInt(this.tf_port.getString());
                    Irc.db.channels = this.tf_channels.getString();
                    Irc.db.username = this.tf_username.getString();
                    Irc.db.realname = this.tf_realname.getString();
                    Irc.db.passwd = this.tf_passwd.getString();
                    Irc.db.start_commands = this.tf_start_commands.getString();
                    Irc.db.quit_message = this.tf_quit_message.getString();
                    Irc.db.msgo = this.tf_msgo.getString();
                    Irc.db.textaway = this.tf_textaway.getString();
                    Irc.db.finger = this.tf_finger.getString();
                    Irc.db.exitchan = this.tf_exitchan.getString();
                    Irc.db.smile2 = this.tf_smile2.getString();
                    if (editing) {
                        db.editProfile(this.list_profile.getSelectedIndex());
                    } else {
                        db.addProfile();
                    }
                }
                this.currentform = 1;
                this.tf_profilename = null;
                this.tf_nick = null;
                this.tf_altnick = null;
                this.tf_host = null;
                this.tf_port = null;
                this.tf_channels = null;
                this.tf_username = null;
                this.tf_realname = null;
                this.tf_passwd = null;
                this.tf_start_commands = null;
                this.tf_quit_message = null;
                this.tf_msgo = null;
                this.tf_textaway = null;
                this.tf_finger = null;
                this.tf_exitchan = null;
                this.tf_smile2 = null;
                if (cmd == this.cmd_ok) {
                    this.commandAction(this.cmd_profiles, null);
                } else {
                    display.setCurrent((Displayable)this.list_profile);
                }
            } else if (this.currentform == 4) {
                this.currentform = 0;
                if (cmd == this.cmd_ok) {
                    Irc.db.timestamp = this.cg_misc.isSelected(0);
                    Irc.db.usecolor = this.cg_misc.isSelected(1);
                    Irc.db.smiles = this.cg_misc.isSelected(2);
                    Irc.db.backcground = this.cg_misc.isSelected(8);
                    Irc.db.eltheme = this.cg_misc.isSelected(9);
                    Irc.db.closepriv = this.cg_misc.isSelected(10);
                    Irc.db.showinput = this.cg_misc.isSelected(3);
                    Irc.db.showhosts = this.cg_misc.isSelected(4);
                    Irc.db.ajoinkick = this.cg_misc.isSelected(5);
                    Irc.db.showtime = this.cg_misc.isSelected(6);
                    Irc.db.poolmode = this.cg_misc.isSelected(7);
                    Irc.db.vibra = this.cg_notificationtypes.isSelected(0);
                    Irc.db.sound = this.cg_notificationtypes.isSelected(1);
                    Irc.db.light = this.cg_notificationtypes.isSelected(2);
                    Irc.db.onquery = this.cg_notification.isSelected(0);
                    Irc.db.onaddress = this.cg_notification.isSelected(1);
                    Irc.db.onnotice = this.cg_notification.isSelected(2);
                    Irc.db.onaction = this.cg_notification.isSelected(3);
                    if (this.cg_font.getSelectedIndex() == 0) {
                        Irc.db.fontsize = 8;
                    } else if (this.cg_font.getSelectedIndex() == 1) {
                        Irc.db.fontsize = 0;
                    } else if (this.cg_font.getSelectedIndex() == 2) {
                        Irc.db.fontsize = 16;
                    }
                    Irc.db.encoding = this.cg_encoding.getString(this.cg_encoding.getSelectedIndex());
                    Irc.db.height_diff = this.parseInt(this.tf_height_diff.getString());
                    Irc.db.pooltime = this.parseInt(this.tf_pooltime.getString());
                    Irc.db.buflines = this.parseInt(this.tf_buflines.getString());
                    Irc.db.ctcp_info = this.tf_ctcp_info.getString();
                    Irc.db.template_query = this.tf_template_query.getString();
                    db.save_advanced();
                }
                this.cg_misc = null;
                this.cg_notificationtypes = null;
                this.cg_notification = null;
                this.cg_font = null;
                this.cg_encoding = null;
                this.tf_height_diff = null;
                this.tf_pooltime = null;
                this.tf_buflines = null;
                this.tf_ctcp_info = null;
                this.tf_template_query = null;
                display.setCurrent((Displayable)mainmenu);
            }
        } else {
            Form cfgform;
            if (cmd == this.cmd_profiles) {
                String[] profiles = db.getProfiles();
                this.list_profile = new List(language.get("profiles"), 3);
                int i = 0;
                while (i < profiles.length) {
                    this.list_profile.append(profiles[i], null);
                    ++i;
                }
                if (Irc.db.profileidx > 0) {
                    this.list_profile.setSelectedIndex(Irc.db.profileidx, true);
                }
                this.list_profile.addCommand(this.cmd_profile_add);
                this.list_profile.addCommand(this.cmd_profile_edit);
                this.list_profile.addCommand(this.cmd_profile_delete);
                this.list_profile.addCommand(this.cmd_ok);
                this.list_profile.setCommandListener((CommandListener)this);
                display.setCurrent((Displayable)this.list_profile);
                this.currentform = 1;
                if (profiles.length == 0) {
                    this.commandAction(this.cmd_profile_add, null);
                }
                return;
            }
            if (cmd == this.cmd_profile_add || cmd == this.cmd_profile_edit) {
                if (cmd == this.cmd_profile_edit) {
                    db.setProfile(this.list_profile.getSelectedIndex());
                } else {
                    db.setProfile(-1);
                }
                this.tf_profilename = new TextField(language.get("profilename"), Irc.db.profilename, 50, 0);
                this.tf_nick = new TextField(language.get("nick"), Irc.db.nick, 50, 0);
                this.tf_altnick = new TextField(language.get("altnick"), Irc.db.altnick, 50, 0);
                this.tf_host = new TextField(language.get("server"), Irc.db.host, 200, 4);
                this.tf_port = new TextField(language.get("port"), new Integer(Irc.db.port).toString(), 5, 2);
                this.tf_channels = new TextField(language.get("channels"), Irc.db.channels, 600, 0);
                this.tf_username = new TextField(language.get("username"), Irc.db.username, 50, 0);
                this.tf_realname = new TextField(language.get("realname"), Irc.db.realname, 50, 0);
                this.tf_passwd = new TextField(language.get("serverpassword"), Irc.db.passwd, 50, 65536);
                this.tf_start_commands = new TextField(language.get("startcommands"), Irc.db.start_commands, 1000, 0);
                this.tf_quit_message = new TextField(language.get("quitmessage"), Irc.db.quit_message, 1000, 0);
                this.tf_msgo = new TextField("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 0", Irc.db.msgo, 50, 0);
                this.tf_textaway = new TextField("\u041f\u0440\u0438\u0441\u0442\u0430\u0432\u043a\u0430 \u043f\u0440\u0438 away", Irc.db.textaway, 15, 0);
                this.tf_finger = new TextField("CTCP \u043e\u0442\u0432\u0435\u0442 FINGER", Irc.db.finger, 50, 0);
                this.tf_exitchan = new TextField("\u0412\u044b\u0445\u043e\u0434 \u0441 \u043a\u0430\u043d\u0430\u043b\u0430", Irc.db.exitchan, 25, 0);
                this.tf_smile2 = new TextField("\u041d\u043e\u0432\u044b\u0435 \u0441\u043c\u0430\u0439\u043b\u044b (1-\u0432\u043a\u043b. 0-\u0432\u044b\u043a\u043b)", Irc.db.smile2, 1, 2);
                cfgform = new Form(language.get("profiles"));
                cfgform.append((Item)this.tf_profilename);
                cfgform.append((Item)this.tf_nick);
                cfgform.append((Item)this.tf_altnick);
                cfgform.append((Item)this.tf_host);
                cfgform.append((Item)this.tf_port);
                cfgform.append((Item)this.tf_channels);
                cfgform.append((Item)this.tf_username);
                cfgform.append((Item)this.tf_realname);
                cfgform.append((Item)this.tf_passwd);
                cfgform.append((Item)this.tf_start_commands);
                cfgform.append((Item)this.tf_quit_message);
                cfgform.append((Item)this.tf_msgo);
                cfgform.append((Item)this.tf_textaway);
                cfgform.append((Item)this.tf_finger);
                cfgform.append((Item)this.tf_exitchan);
                cfgform.append((Item)this.tf_smile2);
                this.currentform = cmd == this.cmd_profile_edit ? 3 : 2;
            } else {
                if (cmd == this.cmd_profile_delete) {
                    db.deleteProfile(this.list_profile.getSelectedIndex());
                    this.commandAction(this.cmd_profiles, null);
                    return;
                }
                if (cmd == this.cmd_settings) {
                    this.cg_misc = new ChoiceGroup(language.get("miscoptions"), 2);
                    this.cg_misc.append(language.get("timestamp"), null);
                    this.cg_misc.append(language.get("colors") + ", " + language.get("styles"), null);
                    this.cg_misc.append(language.get("smiles"), null);
                    this.cg_misc.append(language.get("servermessages"), null);
                    this.cg_misc.append(language.get("showhosts"), null);
                    this.cg_misc.append(language.get("autojoinafterkick"), null);
                    this.cg_misc.append(language.get("showtime"), null);
                    this.cg_misc.append(language.get("socketping"), null);
                    this.cg_misc.append("\u0424\u043e\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0430", null);
                    this.cg_misc.append("\u0415\u043b\u0435\u0433\u0430\u043d\u0442\u043d\u0430\u044f \u0442\u0435\u043c\u0430", null);
                    this.cg_misc.append("\u041d\u043e\u0442\u0438\u0441 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u043f\u0440\u0438\u0432\u0430\u0442\u0430", null);
                    this.cg_misc.setSelectedIndex(0, Irc.db.timestamp);
                    this.cg_misc.setSelectedIndex(1, Irc.db.usecolor);
                    this.cg_misc.setSelectedIndex(2, Irc.db.smiles);
                    this.cg_misc.setSelectedIndex(3, Irc.db.showinput);
                    this.cg_misc.setSelectedIndex(4, Irc.db.showhosts);
                    this.cg_misc.setSelectedIndex(5, Irc.db.ajoinkick);
                    this.cg_misc.setSelectedIndex(6, Irc.db.showtime);
                    this.cg_misc.setSelectedIndex(7, Irc.db.poolmode);
                    this.cg_misc.setSelectedIndex(8, Irc.db.backcground);
                    this.cg_misc.setSelectedIndex(9, Irc.db.eltheme);
                    this.cg_misc.setSelectedIndex(10, Irc.db.closepriv);
                    this.cg_notificationtypes = new ChoiceGroup(language.get("notificationtypes"), 2);
                    this.cg_notificationtypes.append(language.get("vibra"), null);
                    this.cg_notificationtypes.append(language.get("sounds"), null);
                    this.cg_notificationtypes.append(language.get("light"), null);
                    this.cg_notificationtypes.setSelectedIndex(0, Irc.db.vibra);
                    this.cg_notificationtypes.setSelectedIndex(1, Irc.db.sound);
                    this.cg_notificationtypes.setSelectedIndex(2, Irc.db.light);
                    this.cg_notification = new ChoiceGroup(language.get("notification"), 2);
                    this.cg_notification.append(language.get("query"), null);
                    this.cg_notification.append(language.get("address"), null);
                    this.cg_notification.append(language.get("notice"), null);
                    this.cg_notification.append(language.get("action"), null);
                    this.cg_notification.setSelectedIndex(0, Irc.db.onquery);
                    this.cg_notification.setSelectedIndex(1, Irc.db.onaddress);
                    this.cg_notification.setSelectedIndex(2, Irc.db.onnotice);
                    this.cg_notification.setSelectedIndex(3, Irc.db.onaction);
                    this.cg_font = new ChoiceGroup(language.get("font"), 1);
                    this.cg_font.append(language.get("smallphonefont"), null);
                    this.cg_font.append(language.get("mediumphonefont"), null);
                    this.cg_font.append(language.get("largephonefont"), null);
                    if (Irc.db.fontsize == 8) {
                        this.cg_font.setSelectedIndex(0, true);
                    } else if (Irc.db.fontsize == 0) {
                        this.cg_font.setSelectedIndex(1, true);
                    } else if (Irc.db.fontsize == 16) {
                        this.cg_font.setSelectedIndex(2, true);
                    } else {
                        this.cg_font.setSelectedIndex(0, true);
                    }
                    this.cg_encoding = new ChoiceGroup(language.get("encoding"), 1);
                    this.cg_encoding.append("ISO-8859-1", null);
                    this.cg_encoding.append("ISO-8859-2", null);
                    this.cg_encoding.append("UTF-8", null);
                    this.cg_encoding.append("KOI8-R", null);
                    this.cg_encoding.append("Windows-1251", null);
                    if (Irc.db.encoding.equals("ISO-8859-1")) {
                        this.cg_encoding.setSelectedIndex(0, true);
                    } else if (Irc.db.encoding.equals("ISO-8859-2")) {
                        this.cg_encoding.setSelectedIndex(1, true);
                    } else if (Irc.db.encoding.equals("UTF-8")) {
                        this.cg_encoding.setSelectedIndex(2, true);
                    } else if (Irc.db.encoding.equals("KOI8-R")) {
                        this.cg_encoding.setSelectedIndex(3, true);
                    } else if (Irc.db.encoding.equals("Windows-1251")) {
                        this.cg_encoding.setSelectedIndex(4, true);
                    } else {
                        this.cg_encoding.setSelectedIndex(0, true);
                    }
                    this.tf_height_diff = new TextField(language.get("displayheightincrease"), new Integer(Irc.db.height_diff).toString(), 3, 2);
                    this.tf_pooltime = new TextField(language.get("socketpingtime"), new Integer(Irc.db.pooltime).toString(), 5, 2);
                    this.tf_buflines = new TextField(language.get("buffer"), new Integer(Irc.db.buflines).toString(), 3, 2);
                    this.tf_ctcp_info = new TextField(language.get("userinfolabel"), Irc.db.ctcp_info, 1000, 0);
                    this.tf_template_query = new TextField(language.get("templatequery"), Irc.db.template_query, 1, 2);
                    cfgform = new Form(language.get("settings"));
                    cfgform.append((Item)this.cg_misc);
                    cfgform.append((Item)this.tf_pooltime);
                    cfgform.append((Item)this.cg_notificationtypes);
                    cfgform.append((Item)this.cg_notification);
                    cfgform.append((Item)this.cg_font);
                    cfgform.append((Item)this.cg_encoding);
                    cfgform.append((Item)this.tf_height_diff);
                    cfgform.append((Item)this.tf_buflines);
                    cfgform.append((Item)this.tf_ctcp_info);
                    cfgform.append((Item)this.tf_template_query);
                    this.currentform = 4;
                } else {
                    return;
                }
            }
            cfgform.addCommand(this.cmd_ok);
            cfgform.addCommand(this.cmd_cancel);
            cfgform.setCommandListener((CommandListener)this);
            display.setCurrent((Displayable)cfgform);
        }
    }

    public void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        if (irc != null && irc.isConnected()) {
            if (!unconditional) {
                throw new MIDletStateChangeException(language.get("error"));
            }
            Irc.writeLine("QUIT :" + QUIT_MESSAGE);
        }
    }

    public static void disconnect(String quitmessage) {
        if (irc.isConnected()) {
            String ret = irc.writeData("QUIT :" + quitmessage + " /Dm'irc 4.1");
            uihandler.getConsole().writeInfo(ret);
            listener.setNeedUpdate(true);
            listener = null;
            uihandler = null;
            irc.disconnect();
        }
    }

    public static void forceUpdate() {
        listener.setNeedUpdate(true);
    }

    public static int getBytesIn() {
        return irc.getBytesIn();
    }

    public static int getBytesOut() {
        return irc.getBytesOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getViaHttpConnection(String url) throws IOException {
        HttpConnection c = null;
        InputStream is = null;
        try {
            c = (HttpConnection)Connector.open((String)url);
            int len = (int)c.getLength();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    public void onUrlSelect(Window sender, String url) {
        this.openUrl(url);
    }

    public void openUrl(String url) {
        try {
            this.platformRequest(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int parseInt(String input) {
        int ret = 0;
        try {
            ret = Integer.parseInt(input);
        }
        catch (NumberFormatException nfe) {}
        return ret;
    }

    public void pauseApp() {
        Irc.writeLine("NICK " + UIHandler.nick + "_away");
        UIHandler.nick = UIHandler.nick + "_away";
    }

    public void startApp() {
        if (this.isLanguage) {
            if (minimized) {
                display.setCurrent(lastDisplay);
            } else if (!this.running) {
                db.load();
                display.setCurrent((Displayable)mainmenu);
                this.currentform = 0;
                this.running = true;
            }
        }
    }

    public static void writeLine(String message) {
        if (irc.isConnected()) {
            String ret = irc.writeData(message + "\r\n");
            if (ret != null) {
                uihandler.getConsole().writeInfo(ret);
            }
            listener.setNeedUpdate(true);
        }
    }
}

