/*
 * Decompiled with CFR 0.152.
 */
package lib.GraphicControls;

import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lib.Font.SampleFont;
import lib.GraphicControls.TextList;
import lib.Utils.Utils;

public class MessageBox
extends Canvas {
    public static final int TYPE_ALARM = 0;
    public static final int TYPE_CONFIRMATION = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_INFO = 1;
    public static final int TYPE_WARNING = 4;
    private CommandListener cl;
    private Command cmd_center;
    private Command cmd_left;
    private Command cmd_right;
    private Display display;
    private Displayable displayable;
    private Font font = null;
    private int fontHeight;
    private int fontSize;
    private int height;
    private int heightdiff;
    private int left;
    private runningTitle rt;
    private SampleFont sampleFont = null;
    private String text = null;
    public TextList textlist;
    private Graphics tg;
    private Image ti;
    private String title = null;
    private int top;
    private int type;
    private int width;

    public MessageBox(Display display, Displayable displayable, String title, String text, int type, int fontSize, int heightdiff) {
        this.display = display;
        this.displayable = displayable;
        this.title = title;
        this.text = text;
        this.fontSize = fontSize;
        this.heightdiff = heightdiff;
        this.width = this.getWidth();
        this.height = this.getHeight() + heightdiff;
        this.left = 4;
        this.top = 16;
        this.width -= 2 * this.left;
        this.height -= 2 * this.top;
        if (this.height > this.width) {
            this.top = this.height - this.width;
            this.height = this.width - 10;
        }
        if (fontSize < 0) {
            this.sampleFont = new SampleFont("/fonts/font.bin");
            this.fontHeight = this.sampleFont.height;
            if (this.sampleFont.stringWidth(title) > this.width - 12) {
                this.rt = new runningTitle();
                this.rt.setPriority(1);
                this.rt.start();
            }
        } else {
            this.font = Font.getFont((int)0, (int)0, (int)fontSize);
            this.fontHeight = this.font.getHeight();
            if (this.font.stringWidth(title) > this.width - 12) {
                this.rt = new runningTitle();
                this.rt.setPriority(1);
                this.rt.start();
            }
        }
        this.textlist = new TextList(this.width - 10, this.height - 2 * this.fontHeight - 14, fontSize, 0, null);
        this.textlist.addText(text);
    }

    public MessageBox(Display display, CommandListener cl, Command cmd_left, Command cmd_center, Command cmd_right, String title, String text, int type, int fontSize, int heightdiff) {
        this.setFullScreenMode(true);
        this.display = display;
        this.cl = cl;
        this.cmd_left = cmd_left;
        this.cmd_center = cmd_center;
        this.cmd_right = cmd_right;
        this.title = title;
        this.text = text;
        this.fontSize = fontSize;
        this.heightdiff = heightdiff;
        this.width = this.getWidth();
        this.height = this.getHeight() + heightdiff;
        if (this.height > 120) {
            this.left = 4;
            this.top = 16;
        } else {
            this.left = 0;
            this.top = 0;
        }
        this.width -= 2 * this.left;
        this.height -= 2 * this.top;
        if (this.height > this.width) {
            this.top = this.height - this.width;
            this.height = this.width - 10;
        }
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.fontHeight = this.font.getHeight();
        this.textlist = new TextList(this.width - 10, this.height - 2 * this.fontHeight - 14, fontSize, 0, null);
        this.textlist.addText(text);
        if (this.font.stringWidth(title) > this.width - 12) {
            this.rt = new runningTitle();
            this.rt.setPriority(1);
            this.rt.start();
        }
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    protected void keyPressed(int keyCode) {
        if (this.getGameAction(keyCode) == 1 || keyCode == 50 || keyCode == -13) {
            this.textlist.up();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (this.getGameAction(keyCode) == 6 || keyCode == 56 || keyCode == -14) {
            this.textlist.down();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (keyCode == 57) {
            this.textlist.pageDown();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (keyCode == 51) {
            this.textlist.pageUp();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (keyCode == 49) {
            this.textlist.home();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (keyCode == 55) {
            this.textlist.end();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        }
        if ((this.getGameAction(keyCode) == 8 || keyCode == 48) && this.cmd_center != null) {
            this.cl.commandAction(this.cmd_center, null);
        }
        if ((keyCode == 42 || keyCode == -6 || keyCode == -1 || keyCode == -11) && this.cmd_left != null) {
            this.cl.commandAction(this.cmd_left, null);
        }
        if (keyCode == -4 || keyCode == -7 || keyCode == 35 || keyCode == -12) {
            if (this.cmd_right != null) {
                this.cl.commandAction(this.cmd_right, null);
            } else if (this.displayable != null) {
                this.display.setCurrent(this.displayable);
            }
        }
    }

    protected void paint(Graphics g) {
        g.setColor(50, 50, 50);
        g.drawRect(this.left, this.top, this.width - 1, this.height - 1);
        g.setColor(191, 193, 208);
        g.drawRect(this.left + 1, this.top + 1, this.width - 3, this.height - 3);
        g.setColor(241, 241, 241);
        g.drawRect(this.left + 1, this.top + 1, this.width - 4, this.height - 4);
        g.setColor(219, 222, 232);
        g.drawRect(this.left + 2, this.top + 2, this.width - 5, this.height - 5);
        g.setColor(255, 255, 255);
        g.drawRect(this.left + 2, this.top + 2, this.width - 6, this.height - 6);
        g.setColor(212, 208, 200);
        g.drawRect(this.left + 3, this.top + 3, this.width - 7, this.height - 7);
        g.setColor(241, 243, 248);
        g.fillRect(this.left + 4, this.top + 4, this.width - 8, this.height - 8);
        if (this.sampleFont != null) {
            Utils.drawFramedText(g, this.sampleFont, this.title, this.left + this.width / 2 - this.sampleFont.stringWidth(this.title) / 2, this.top + 5, 0xFFFFFF, 0);
        } else {
            Utils.drawFramedText(g, this.font, this.title, this.left + this.width / 2 - this.font.stringWidth(this.title) / 2, this.top + 5, 0xFFFFFF, 65280);
        }
        if (this.cmd_left != null) {
            if (this.sampleFont != null) {
                Utils.drawFramedText(g, this.sampleFont, "*", this.left + 10, this.top + this.height - this.fontHeight - 6, 65280, 0);
            } else {
                Utils.drawFramedText(g, this.font, "*", this.left + 10, this.top + this.height - this.fontHeight - 6, 0xFFFF00, 0);
            }
        }
        if (this.cmd_center != null) {
            if (this.sampleFont != null) {
                Utils.drawFramedText(g, this.sampleFont, "+", this.left + this.width / 2 - 2, this.top + this.height - this.fontHeight - 6, 255, 0);
            } else {
                Utils.drawFramedText(g, this.font, "+", this.left + this.width / 2 - 2, this.top + this.height - this.fontHeight - 6, 255, 0);
            }
        }
        if (this.cmd_right != null || this.displayable != null) {
            if (this.sampleFont != null) {
                Utils.drawFramedText(g, this.sampleFont, "#", this.left + this.width - 15, this.top + this.height - this.fontHeight - 6, 0xFF0000, 0);
            } else {
                Utils.drawFramedText(g, this.font, "#", this.left + this.width - 15, this.top + this.height - this.fontHeight - 6, 0xFF0000, 0);
            }
        }
        this.textlist.paint(g, this.left + 5, this.top + this.fontHeight + 7);
    }

    public void playSound() {
        if (this.type == 0) {
            AlertType.ALARM.playSound(this.display);
        } else if (this.type == 1) {
            AlertType.INFO.playSound(this.display);
        } else if (this.type == 2) {
            AlertType.CONFIRMATION.playSound(this.display);
        } else if (this.type == 3) {
            AlertType.ERROR.playSound(this.display);
        } else if (this.type == 4) {
            AlertType.WARNING.playSound(this.display);
        }
    }

    public void setDisplayable(Displayable displayable) {
        this.displayable = displayable;
    }

    public void setText(String text) {
        this.text = text;
        this.textlist.clear();
        this.textlist.addText(text);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void show() {
        this.display.setCurrent((Displayable)this);
        this.playSound();
    }

    private class runningTitle
    extends Thread {
        public boolean run = true;
        private int size;
        private String temp;

        public runningTitle() {
            this.temp = MessageBox.this.title;
            this.size = (MessageBox.this.width - 20) / MessageBox.this.font.charWidth('D');
            MessageBox.this.title = "";
        }

        public void run() {
            while (this.run) {
                MessageBox.this.title = this.temp.substring(0, this.size);
                this.temp = this.temp.substring(1) + this.temp.charAt(1);
                MessageBox.this.repaint(MessageBox.this.left + 10, MessageBox.this.top + 5, MessageBox.this.width - 25, MessageBox.this.fontHeight + 5);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                }
            }
        }
    }
}

