/*
 * Decompiled with CFR 0.152.
 */
package lib.GraphicControls;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import lib.Font.SampleFont;
import lib.GraphicControls.Page;
import lib.GraphicControls.PageControlCommandListener;
import lib.Resources.ImageList;
import lib.Utils.Utils;

public class PageControl
extends Canvas {
    public int activePage = 0;
    private changerThread changer;
    private int corHeight = 0;
    private Display display;
    private Font font = null;
    private int fontHeight;
    private int fontSize;
    private int height;
    private ImageList icons;
    private List menuList;
    private Vector pages;
    private PageControlCommandListener pcComd;
    private SampleFont sampleFont = null;
    public boolean showMemoryStatus = false;
    private int startPage = 0;
    private Graphics tg;
    private Image ti;
    private int width;

    public PageControl() {
        this.setFullScreenMode(true);
        this.pages = new Vector();
        this.icons = new ImageList();
        this.changer = new changerThread();
        this.changer.setPriority(1);
        this.changer.start();
    }

    public void addPage(String title, List menuList, int imageIndex, ImageList images) {
        Page page = new Page(this, title, imageIndex, menuList, this.width, this.height - this.fontHeight - this.corHeight - 2, 1, 999, this.fontSize);
        page.state = 0;
        page.textlist.setImageList(images);
        if (this.pages.size() == 0) {
            page.state = 1;
        }
        this.pages.addElement(page);
        page = null;
        this.updateBody();
        this.updateHeader();
    }

    public void delAllPages() {
        this.pages.removeAllElements();
        this.activePage = 0;
        this.startPage = 0;
    }

    public void delPage(int index) {
        if (this.pages.size() > 1) {
            this.pages.removeElementAt(index);
            if (this.activePage >= index && this.activePage == this.pages.size()) {
                if (this.activePage == this.startPage) {
                    --this.startPage;
                }
                this.activePage = this.pages.size() - 1;
            }
            this.getPage((int)this.activePage).state = 1;
            this.updateHeader();
            this.updateBody();
        }
    }

    public void drawMemoryStatus(Graphics g) {
        String total = Utils.getKBytes(Runtime.getRuntime().totalMemory()) + " \u043a\u0431";
        String used = Utils.getKBytes(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " \u043a\u0431";
        g.setColor(0);
        g.fillRect(0, this.height - 2 * this.fontHeight, this.font.stringWidth(total), 2 * this.fontHeight);
        g.setColor(0);
        g.setFont(this.font);
        g.drawString(total, 0, this.height - 2 * this.fontHeight, 0);
        g.drawString(used, 0, this.height - this.fontHeight, 0);
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public Page getPage(int index) {
        return (Page)this.pages.elementAt(index);
    }

    public int getSize() {
        return this.pages.size();
    }

    protected void keyPressed(int keyCode) {
        if (this.getGameAction(keyCode) == 1 || keyCode == 50 || keyCode == -13) {
            this.changer.type = 2;
            this.changer.running = true;
            if (this.pcComd != null) {
                this.pcComd.onUp(this);
            }
        } else if (this.getGameAction(keyCode) == 6 || keyCode == 56 || keyCode == -14) {
            this.changer.type = 3;
            this.changer.running = true;
            if (this.pcComd != null) {
                this.pcComd.onDown(this);
            }
        } else if (this.getGameAction(keyCode) == 2 || keyCode == 52) {
            this.changer.type = 0;
            this.changer.running = true;
            if (this.pcComd != null) {
                this.pcComd.onLeft(this);
            }
        } else if (this.getGameAction(keyCode) == 5 || keyCode == 54) {
            this.changer.type = 1;
            this.changer.running = true;
            if (this.pcComd != null) {
                this.pcComd.onRight(this);
            }
        } else if (keyCode == 49) {
            this.getPage((int)this.activePage).textlist.home();
            this.updateBody();
        } else if (keyCode == 55) {
            this.getPage((int)this.activePage).textlist.end();
            this.updateBody();
        } else if (keyCode == 51) {
            this.getPage((int)this.activePage).textlist.pageUp();
            this.updateBody();
        } else if (keyCode == 57) {
            this.getPage((int)this.activePage).textlist.pageDown();
            this.updateBody();
        } else if (keyCode == 35 || keyCode == -7 || keyCode == -4) {
            this.setDisplay((Displayable)this.getPage((int)this.activePage).menuList);
        } else if (this.getGameAction(keyCode) == 8) {
            if (this.pcComd != null) {
                this.pcComd.onEnter(this);
            }
        } else if (keyCode == 48) {
            this.showMemoryStatus = !this.showMemoryStatus;
            this.updateBody();
        }
        if (this.pcComd != null) {
            this.pcComd.onKeyPress(this, keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        this.changer.running = false;
    }

    protected void paint(Graphics g) {
        g.drawImage(this.ti, 0, 0, 0);
        if (this.showMemoryStatus) {
            this.drawMemoryStatus(g);
        }
    }

    public void setAttributes(Display display, int fontsize, int heightdiff, ImageList icons) {
        this.setAttributes(display, fontsize, heightdiff);
        this.icons = icons;
        if (icons != null && icons.getHeight() > this.fontHeight) {
            this.corHeight = icons.getHeight() - this.fontHeight + 1;
        }
    }

    public void setAttributes(Display display, int fontsize, int heightdiff) {
        this.display = display;
        this.fontSize = fontsize;
        this.icons = null;
        this.width = this.getWidth();
        this.height = this.getHeight() + heightdiff;
        if (this.fontSize < 0) {
            this.sampleFont = new SampleFont("/fonts/font.bin");
            this.fontHeight = this.sampleFont.height;
        } else {
            this.font = Font.getFont((int)0, (int)0, (int)this.fontSize);
            this.fontHeight = this.font.getHeight();
        }
        this.ti = Image.createImage((int)this.width, (int)this.height);
        this.tg = this.ti.getGraphics();
        if (this.pages.size() > 0) {
            this.updateHeader();
            this.updateBody();
        }
    }

    public void setDisplay(Displayable d) {
        this.display.setCurrent(d);
    }

    public void setPage(int index, Page page) {
        this.pages.insertElementAt(page, index);
        this.delPage(index + 1);
    }

    public void setPageControlListener(PageControlCommandListener pcComd) {
        this.pcComd = pcComd;
    }

    public void showNextPage() {
        if (this.activePage < this.getSize() - 1) {
            this.showPage(this.activePage + 1);
        } else {
            this.showPage(0);
        }
    }

    public void showPage(int index) {
        if (index > -1 && index < this.getSize()) {
            if (index < this.startPage) {
                this.startPage = index;
            }
            this.getPage((int)this.activePage).state = 0;
            this.activePage = index;
            this.getPage((int)this.activePage).state = 1;
            this.updateBody();
            this.updateHeader();
        }
    }

    public void showPrevPage() {
        if (this.activePage > 0) {
            this.showPage(this.activePage - 1);
        } else {
            this.showPage(this.getSize() - 1);
        }
    }

    public void updateBody() {
        this.getPage((int)this.activePage).textlist.paint(this.tg, 0, this.fontHeight + this.corHeight + 3);
        this.tg.setColor(235, 100, 0);
        this.tg.drawLine(this.width - 14, this.height - 7, this.width - 9, this.height - 7);
        this.tg.drawLine(this.width - 13, this.height - 6, this.width - 10, this.height - 6);
        this.tg.drawLine(this.width - 12, this.height - 5, this.width - 11, this.height - 5);
        this.repaint(0, this.fontHeight + this.corHeight + 4, this.width, this.height - this.fontHeight - this.corHeight - 4);
    }

    public void updateHeader() {
        int x = 0;
        int i = 0;
        int sw = 0;
        int sh = 0;
        boolean notDrawedActivePage = false;
        Page page = null;
        String str = "";
        this.tg.setFont(this.font);
        this.tg.setColor(223, 223, 223);
        this.tg.fillRect(x, 0, this.width, this.fontHeight + 3 + this.corHeight);
        this.tg.setColor(0, 0, 0);
        this.tg.drawLine(0, this.fontHeight + 3 + this.corHeight, this.width + 3, this.fontHeight + 3 + this.corHeight);
        while (!(x >= this.width && notDrawedActivePage || this.startPage + i >= this.pages.size())) {
            page = this.getPage(this.startPage + i);
            int iconsWidth = this.icons != null && page.imageIndex > -1 && page.imageIndex < this.icons.getSize() ? this.icons.getWidth() + 1 : 0;
            str = page.title;
            if (this.fontSize < 0) {
                sw = this.sampleFont.stringWidth(str) + iconsWidth + 2;
                if (sw > this.width - 10 - iconsWidth) {
                    str = Utils.splitString(str, this.sampleFont, this.width - 10 - iconsWidth - this.sampleFont.stringWidth("..."))[0];
                    str = str + "...";
                }
                sw = this.sampleFont.stringWidth(str) + iconsWidth + 2;
            } else {
                sw = this.font.stringWidth(str) + iconsWidth + 2;
                if (sw > this.width - 10 - iconsWidth) {
                    str = Utils.splitString(str, this.font, this.width - 10 - iconsWidth - this.font.stringWidth("..."))[0];
                    str = str + "...";
                }
                sw = this.font.stringWidth(str) + iconsWidth + 2;
            }
            sh = this.fontHeight + this.corHeight;
            if (page.state == 1) {
                notDrawedActivePage = true;
                this.tg.setColor(0, 0, 0);
                this.tg.fillRect(x + 1, 0, sw + 5, sh + 4);
                this.tg.setColor(150, 150, 0);
                this.tg.fillRect(x + 2, 1, sw + 3, sh + 3);
                this.tg.setColor(255, 255, 255);
                this.tg.fillRect(x + 3, 2, sw + 1, sh + 2);
                this.tg.setColor(0, 0, 0);
            } else if (page.state == 0) {
                this.tg.setColor(0, 0, 0);
                this.tg.fillRect(x + 1, 2, sw + 5, sh + 2);
                this.tg.setColor(170, 170, 170);
                this.tg.fillRect(x + 2, 3, sw + 3, sh);
                this.tg.setColor(225, 225, 225);
                this.tg.fillRect(x + 3, 4, sw + 1, sh - 1);
                this.tg.setColor(0, 0, 0);
            } else if (page.state == 5) {
                this.tg.setColor(0, 0, 0);
                this.tg.fillRect(x + 1, 2, sw + 5, sh + 2);
                this.tg.setColor(170, 0, 0);
                this.tg.fillRect(x + 2, 3, sw + 3, sh);
                this.tg.setColor(225, 225, 225);
                this.tg.fillRect(x + 3, 4, sw + 1, sh - 1);
                this.tg.setColor(250, 80, 80);
            } else if (page.state == 3) {
                this.tg.setColor(0, 0, 0);
                this.tg.fillRect(x + 1, 2, sw + 5, sh + 2);
                this.tg.setColor(0, 0, 170);
                this.tg.fillRect(x + 2, 3, sw + 3, sh);
                this.tg.setColor(225, 225, 225);
                this.tg.fillRect(x + 3, 4, sw + 1, sh - 1);
                this.tg.setColor(0, 0, 170);
            } else if (page.state == 2) {
                this.tg.setColor(0, 0, 0);
                this.tg.fillRect(x + 1, 2, sw + 5, sh + 2);
                this.tg.setColor(170, 0, 170);
                this.tg.fillRect(x + 2, 3, sw + 3, sh);
                this.tg.setColor(225, 225, 225);
                this.tg.fillRect(x + 3, 4, sw + 1, sh - 1);
                this.tg.setColor(170, 0, 170);
            } else if (page.state == 4) {
                this.tg.setColor(0, 0, 0);
                this.tg.fillRect(x + 1, 2, sw + 5, sh + 2);
                this.tg.setColor(0, 0, 170);
                this.tg.fillRect(x + 2, 3, sw + 3, sh);
                this.tg.setColor(225, 225, 225);
                this.tg.fillRect(x + 3, 4, sw + 1, sh - 1);
                this.tg.setColor(0, 0, 170);
            }
            if (this.fontSize < 0) {
                this.sampleFont.drawString(this.tg, str, x + iconsWidth + 3, 1 + this.corHeight);
            } else {
                this.tg.drawString(str, x + iconsWidth + 3, 3 + this.corHeight, 20);
            }
            if (this.icons != null && page.imageIndex > -1 && page.imageIndex < this.icons.getSize()) {
                this.icons.drawImage(this.tg, page.imageIndex, x + 4, 4);
            }
            x += sw + 6;
            ++i;
        }
        if (page.state == 1 && x >= this.width) {
            ++this.startPage;
            this.updateHeader();
        }
        this.repaint(0, 0, this.width, sh + 6);
        page = null;
    }

    private class changerThread
    extends Thread {
        public static final int DOWN = 3;
        public static final int NEXT = 1;
        public static final int PREV = 0;
        public static final int UP = 2;
        public boolean running = false;
        public int type = 1;

        public void run() {
            while (this != null) {
                if (!this.running) continue;
                if (this.type == 1) {
                    PageControl.this.showNextPage();
                } else if (this.type == 0) {
                    PageControl.this.showPrevPage();
                } else if (this.type == 2) {
                    PageControl.this.getPage((int)PageControl.this.activePage).textlist.up();
                    PageControl.this.updateBody();
                } else if (this.type == 3) {
                    PageControl.this.getPage((int)PageControl.this.activePage).textlist.down();
                    PageControl.this.updateBody();
                }
                try {
                    Thread.sleep(70L);
                }
                catch (InterruptedException e) {
                }
            }
        }
    }
}

