/*
 * Decompiled with CFR 0.152.
 */
package lib.Resources;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageList {
    private int height = 0;
    private Vector items = new Vector();
    private Image resImage;
    private int size = 0;
    private int width = 0;

    public void clear() {
        this.items.removeAllElements();
        this.resImage = null;
    }

    public void create(Image img, int width) {
        this.resImage = img;
        this.width = width;
        this.height = this.resImage.getHeight();
        this.size = this.resImage.getWidth() / width;
        int i = 0;
        while (i < this.size) {
            Image newImage = Image.createImage((int)width, (int)this.height);
            newImage.getGraphics().drawImage(this.resImage, -width * i, 0, 20);
            this.items.addElement(Image.createImage((Image)newImage));
            ++i;
        }
    }

    public void drawImage(Graphics g, int index, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if (x + this.width > clipX && y + this.height > clipY && x < clipX + clipWidth && y < clipY + clipHeight) {
            int left = x > clipX ? x : clipX + 1;
            int top = y > clipY ? y : clipY + 1;
            int width = this.width < clipWidth ? this.width : clipWidth - 1;
            int height = this.height < clipHeight ? this.height : clipHeight - 1;
            g.setClip(left, top, width, height);
            g.drawImage(this.resImage, x - index * this.width, y, 20);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage(int index) {
        return (Image)this.items.elementAt(index);
    }

    public int getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }

    public void load(String resName, int width) throws IOException {
        this.resImage = Image.createImage((String)resName);
        this.width = width;
        this.height = this.resImage.getHeight();
        this.size = this.resImage.getWidth() / width;
        int i = 0;
        while (i < this.size) {
            Image newImage = Image.createImage((int)width, (int)this.height);
            newImage.getGraphics().drawImage(this.resImage, -width * i, 0, 20);
            this.items.addElement(Image.createImage((Image)newImage));
            ++i;
        }
    }
}

