/*
 * Decompiled with CFR 0.152.
 */
package lib.Font;

import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class CopyOfSampleFont {
    public static final int STYLE_BOLD = 0;
    public static final int STYLE_PLAIN = 1;
    public static final int STYLE_UNDERLINED = 2;
    public int bgColor = 0xFFFFFF;
    public int fontColor = 0;
    private String[][] fontData;
    public int height;
    private InputStream in;
    public int size;
    public int style = 1;
    public int[] width;

    public CopyOfSampleFont(String fontFileName) {
        this.in = this.getClass().getResourceAsStream(fontFileName);
        try {
            this.size = this.in.read() + 1;
            this.height = this.in.read();
            this.width = new int[this.size];
            int i = 0;
            while (i < this.size) {
                this.width[i] = this.in.read();
                ++i;
            }
            this.fontData = new String[this.size][this.height];
            int i2 = 0;
            while (i2 < this.size) {
                int j = 0;
                while (j < this.height) {
                    this.fontData[i2][j] = "";
                    int k = 0;
                    while (k < this.bytesPerSymbol(this.width[i2])) {
                        String[] stringArray = this.fontData[i2];
                        int n = j;
                        stringArray[n] = stringArray[n] + this.DecToBin(this.in.read());
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        catch (Exception e) {
        }
    }

    private String DecToBin(int input) {
        String result = Integer.toBinaryString(input);
        if (result.length() < 8) {
            result = "00000000".substring(result.length()) + result;
        }
        return result;
    }

    private int bytesPerSymbol(int width) {
        if (width <= 8) {
            return 1;
        }
        if (width - width / 8 * 8 == 0) {
            return width / 8;
        }
        return width / 8 + 1;
    }

    public void drawChar(Graphics g, int ch, int left, int top) {
        int x = left;
        int bold = 0;
        if (this.style == 0 || this.style == 2) {
            bold = 1;
        }
        if (this.bgColor != 0xFFFFFF) {
            g.setColor(this.bgColor);
            g.fillRect(left, top, this.width[ch] + bold, this.height);
        }
        g.setColor(this.fontColor);
        if (this.style == 2 || this.style == 2) {
            g.drawLine(x, top + this.height, x + this.width[ch] + bold, top + this.height);
        }
        int i = 0;
        while (i < this.height) {
            int j = 0;
            while (j < this.width[ch] && j < this.fontData[ch][i].length()) {
                if (this.fontData[ch][i].charAt(j) == '0') {
                    g.drawLine(x, top, x + bold, top);
                }
                ++x;
                ++j;
            }
            ++top;
            x = left;
            ++i;
        }
    }

    public void drawString(Graphics g, String text, int left, int top) {
        int i = 0;
        while (i < text.length()) {
            int ch = text.charAt(i);
            if (ch >= 1040 && ch <= 1103) {
                ch -= 848;
            }
            this.drawChar(g, ch, left, top);
            left += this.width[ch];
            ++i;
        }
    }

    private int getBgColor() {
        return this.bgColor;
    }

    private int getFontColor() {
        return this.fontColor;
    }

    private int getStyle() {
        return this.style;
    }

    public void setBgColor(int RGB) {
        int red = RGB >> 16 & 0xFF;
        int green = RGB >> 8 & 0xFF;
        int blue = RGB & 0xFF;
        this.bgColor = RGB & 0xFFFFFF;
    }

    public void setBgColor(int red, int green, int blue) {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.bgColor = red << 16 | green << 8 | blue;
    }

    public void setFontColor(int RGB) {
        int red = RGB >> 16 & 0xFF;
        int green = RGB >> 8 & 0xFF;
        int blue = RGB & 0xFF;
        this.fontColor = RGB & 0xFFFFFF;
    }

    public void setFontColor(int red, int green, int blue) {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.fontColor = red << 16 | green << 8 | blue;
    }

    public void setStyle(int style) {
        if (style < 0 || style > 2) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.style = style;
    }

    public int stringWidth(String str) {
        int result = 0;
        int i = 0;
        while (i < str.length()) {
            int ch = str.charAt(i);
            if (ch >= 1040 && ch <= 1103) {
                ch -= 848;
            }
            result += this.width[ch];
            ++i;
        }
        return result;
    }

    public int substringWidth(String str, int index1, int index2) {
        int result = 0;
        int i = index1;
        while (i < index2) {
            int ch = str.charAt(i);
            if (ch >= 1040 && ch <= 1103) {
                ch -= 848;
            }
            result += this.width[ch];
            ++i;
        }
        return result;
    }

    public int substringWidth(String str, int index1) {
        int result = 0;
        int i = index1;
        while (i < str.length()) {
            int ch = str.charAt(i);
            if (ch >= 1040 && ch <= 1103) {
                ch -= 848;
            }
            result += this.width[ch];
            ++i;
        }
        return result;
    }
}

