/*
 * Decompiled with CFR 0.152.
 */
package inettools;

import inettools.UIHandler;
import lib.GraphicControls.TextList;

public class TextArea
extends TextList {
    private int buffer;
    private UIHandler uihandler;

    public TextArea(int textListWidth, int textListHeight, int fontSize, int cursorStyle, int buffer, UIHandler uihandler) {
        super(textListWidth, textListHeight, fontSize, cursorStyle, uihandler.emotions.smilesList);
        this.buffer = buffer;
        this.uihandler = uihandler;
    }

    public void addIRCText(String text, int fontColor, int bgColor, int fontStyle, int fontSize, int textIndex, boolean smiles) {
        int[] mIRCColors = new int[]{15, 0, 4, 2, 9, 1, 5, 3, 11, 10, 6, 14, 12, 13, 8, 7};
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == '\u0002' | ch == '\u0003' | ch == '\u0016' | ch == '\u001f') {
                if (!text.substring(0, i).equals("")) {
                    if (smiles) {
                        this.uihandler.emotions.addTextWithSmiles(this, text.substring(0, i), fontColor, bgColor, fontStyle, fontSize, textIndex);
                    } else {
                        this.addTextWithURL(text.substring(0, i), fontColor, bgColor, fontStyle, fontSize, textIndex);
                    }
                }
                text = text.substring(i + 1);
                i = -1;
                switch (ch) {
                    case '\u0002': {
                        fontStyle ^= 1;
                        break;
                    }
                    case '\u001f': {
                        fontStyle ^= 4;
                        break;
                    }
                    case '\u0016': {
                        fontStyle ^= 2;
                        break;
                    }
                    case '\u0003': {
                        String[] cols = new String[2];
                        int j = 0;
                        while (j < text.length()) {
                            char c = text.charAt(j);
                            if (c != ',' && !Character.isDigit(c)) {
                                if (j == 0) break;
                                if (cols[0] == null) {
                                    cols[0] = text.substring(0, j);
                                } else {
                                    cols[1] = text.substring(0, j);
                                }
                                text = text.substring(j);
                                break;
                            }
                            if (c == ',' && cols[0] != null) {
                                if (j == 0) break;
                                cols[1] = text.substring(0, j);
                                text = text.substring(j);
                                break;
                            }
                            if (c == ',') {
                                if (j == 0) {
                                    text.substring(j + 1);
                                    break;
                                }
                                cols[0] = text.substring(0, j);
                                if (j == text.length() - 1 || !Character.isDigit(text.charAt(j + 1))) {
                                    text = text.substring(j);
                                    break;
                                }
                                text = text.substring(j + 1);
                                j = 0;
                            }
                            ++j;
                        }
                        if (cols[0] == null) {
                            fontColor = 0;
                            bgColor = 0xFFFFFF;
                            break;
                        }
                        if (cols[0] != null) {
                            fontColor = this.getColor(mIRCColors[Integer.parseInt(cols[0]) < 16 ? Integer.parseInt(cols[0]) : 2]);
                        }
                        if (cols[1] != null) {
                            bgColor = this.getColor(mIRCColors[Integer.parseInt(cols[1]) < 16 ? Integer.parseInt(cols[1]) : 2]);
                        }
                        break;
                    }
                }
            }
            ++i;
        }
        if (!text.equals("")) {
            if (smiles) {
                this.uihandler.emotions.addTextWithSmiles(this, text, fontColor, bgColor, fontStyle, fontSize, textIndex);
            } else {
                this.addTextWithURL(text, fontColor, bgColor, fontStyle, fontSize, textIndex);
            }
        }
    }

    public void addIRCText(String text, boolean smiles) {
        this.addIRCText(text, 0, 0xFFFFFF, 0, this.fontSize, this.items.size(), smiles);
    }

    public void addIRCText(String text, int itemIndex, boolean smiles) {
        this.addIRCText(text, 0, 0xFFFFFF, 0, this.fontSize, itemIndex, smiles);
    }

    public void buffer() {
        if (this.items.size() > this.buffer && this.topItem > 0 && this.currentItem > 0) {
            this.items.removeElementAt(0);
            --this.topItem;
            --this.currentItem;
        }
    }

    public void clear() {
        this.items.removeAllElements();
        this.topPosition = 0;
        this.topItem = 0;
        this.currentItem = 0;
    }

    private int getColor(int numb) {
        switch (numb) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0xAA0000;
            }
            case 2: {
                return 53760;
            }
            case 3: {
                return 0xAA5522;
            }
            case 4: {
                return 170;
            }
            case 5: {
                return 0xAA00AA;
            }
            case 6: {
                return 43690;
            }
            case 7: {
                return 0xAAAAAA;
            }
            case 8: {
                return 0x444444;
            }
            case 9: {
                return 0xFF4444;
            }
            case 10: {
                return 0x44FF44;
            }
            case 11: {
                return 0xFFFF44;
            }
            case 12: {
                return 0x4444FF;
            }
            case 13: {
                return 0xFF44FF;
            }
            case 14: {
                return 0x44FFFF;
            }
            case 15: {
                return 0xFFFFFF;
            }
        }
        return 0xFFFFFF;
    }

    public String getSelectedMessage() {
        return this.getItemText(this.currentItem);
    }
}

