/*
 * Decompiled with CFR 0.152.
 */
package lib.Utils;

import inettools.UIHandler;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import lib.Font.SampleFont;

public class Utils {
    static char[] cp1251map;
    protected static Hashtable hashmap;
    static char[] koi8rmap;

    static {
        koi8rmap = "\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c\u2580\u2584\u2588\u258c\u2590\u2591\u2592\u2593\u2320\u25a0\u2219\u221a\u2248\u2264\u2265\u00a0\u2321\u00b0\u00b2\u00b7\u00f7\u2550\u2551\u2552\u0451\u2553\u2554\u2555\u2556\u2557\u2558\u2559\u255a\u255b\u255c\u255d\u255e\u255f\u2560\u2561\u0401\u2562\u2563\u2564\u2565\u2566\u2567\u2568\u2569\u256a\u256b\u256c\u00a9\u044e\u0430\u0431\u0446\u0434\u0435\u0444\u0433\u0445\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u044f\u0440\u0441\u0442\u0443\u0436\u0432\u044c\u044b\u0437\u0448\u044d\u0449\u0447\u044a\u042e\u0410\u0411\u0426\u0414\u0415\u0424\u0413\u0425\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u042f\u0420\u0421\u0422\u0423\u0416\u0412\u042c\u042b\u0417\u0428\u042d\u0429\u0427\u042a".toCharArray();
        cp1251map = "\u0402\u0403\u201a\u0453\u201e\u2026\u2020\u2021\u20ac\u2030\u0409\u2039\u040a\u040c\u040b\u040f\u0452\u2018\u2019\u201c\u201d\u2022\u2013\u2014\ufffd\u2122\u0459\u203a\u045a\u045c\u045b\u045f\u00a0\u040e\u045e\u0408\u00a4\u0490\u00a6\u00a7\u0401\u00a9\u0404\u00ab\u00ac\u00ad\u00ae\u0407\u00b0\u00b1\u0406\u0456\u0491\u00b5\u00b6\u00b7\u0451\u2116\u0454\u00bb\u0458\u0405\u0455\u0457\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f".toCharArray();
        hashmap = null;
    }

    public static String URLEncode(byte[] input) {
        if (input == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < input.length) {
            int temp = input[i] & 0xFF;
            if (temp >= 48 && temp <= 57 || temp >= 65 && temp <= 90 || temp >= 97 && temp <= 122 || temp == 46 || temp == 45 || temp == 42 || temp == 95) {
                ret.append((char)temp);
            } else if (temp == 32) {
                ret.append('+');
            } else {
                ret.append('%');
                if (temp < 16) {
                    ret.append('0');
                }
                ret.append(Integer.toHexString(temp));
            }
            ++i;
        }
        return ret.toString();
    }

    public static String byteArrayToString(byte[] bytes, String encoding) {
        String ret;
        char[] map = null;
        if (encoding.equals("KOI8-R")) {
            map = koi8rmap;
        } else if (encoding.equals("Windows-1251")) {
            map = cp1251map;
        }
        if (map != null) {
            char[] chars = new char[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                byte b = bytes[i];
                chars[i] = b >= 0 ? (char)b : map[b + 128];
                ++i;
            }
            ret = new String(chars);
        } else {
            try {
                ret = new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                ret = new String(bytes);
            }
        }
        return ret;
    }

    public static void drawFramedText(Graphics g, SampleFont sampleFont, String text, int left, int top, int textColor, int frameColor) {
        sampleFont.setFontColor(frameColor);
        sampleFont.drawString(g, text, left - 1, top);
        sampleFont.drawString(g, text, left + 1, top);
        sampleFont.drawString(g, text, left, top - 1);
        sampleFont.drawString(g, text, left, top + 1);
        sampleFont.setFontColor(textColor);
        sampleFont.drawString(g, text, left, top);
    }

    public static void drawFramedText(Graphics g, Font font, String text, int left, int top, int textColor, int frameColor) {
        g.setFont(font);
        g.setColor(frameColor);
        g.drawString(text, left - 1, top, 0);
        g.drawString(text, left + 1, top, 0);
        g.drawString(text, left, top - 1, 0);
        g.drawString(text, left, top + 1, 0);
        try {
            g.setColor(Integer.parseInt(UIHandler.chasy[0]), Integer.parseInt(UIHandler.chasy[1]), Integer.parseInt(UIHandler.chasy[2]));
        }
        catch (Exception e) {
            // empty catch block
        }
        g.drawString(text, left, top, 0);
    }

    public static String formatDateMillis(long millis) {
        return "";
    }

    private static Hashtable generateHashmap(char[] encmap) {
        Hashtable<Character, Byte> ret = new Hashtable<Character, Byte>();
        int i = 0;
        while (i < encmap.length) {
            ret.put(new Character(encmap[i]), new Byte((byte)(128 + i)));
            ++i;
        }
        return ret;
    }

    public static String getCanonicalDate(Calendar calendar, TimeZone timezone) {
        String monthNames = "JanFebMarAprMayJunJulAugSepOctNovDec";
        String dayNames = "SunMonTueWedThuFriSatSun";
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int weekday = calendar.get(7) - 1;
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        String result = dayNames.substring(3 * weekday, 3 * weekday + 3) + ", " + Utils.intToStr(day, 2) + " " + monthNames.substring(3 * month, 3 * month + 3) + " " + Utils.intToStr(year, 4) + " " + Utils.intToStr(hour, 2) + ":" + Utils.intToStr(minute, 2) + ":" + Utils.intToStr(second, 2);
        if (timezone != null) {
            String name;
            int offset = timezone.getRawOffset() / 1000;
            if (timezone.useDaylightTime()) {
                offset += 3600;
            }
            if (offset >= 0) {
                name = " GMT+";
            } else {
                name = " GMT-";
                offset = -offset;
            }
            result = result + name + Utils.intToStr(offset / 3600, 2) + Utils.intToStr(offset % 3600, 2);
        }
        return result;
    }

    public static String getKBytes(long bytes) {
        String result = Long.toString(bytes / 1024L);
        if (bytes > 1024L) {
            String temp = Long.toString(bytes * 1000L / 1024L);
            result = result + "," + temp.substring(result.length());
        } else {
            String temp = Long.toString(bytes * 1000L / 1024L);
            result = bytes < 100L ? result + ",0" + temp : result + "," + temp;
        }
        return result;
    }

    public static String getTime() {
        Calendar cal = Calendar.getInstance();
        return cal.get(11) + ":" + (cal.get(12) < 10 ? "0" : "") + cal.get(12);
    }

    public static boolean hasNoValue(String s) {
        return s == null || s.equals("") || s.getBytes().length == 0;
    }

    public static byte[] intToByteArray(int input, int length) {
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            result[length - 1 - i] = (byte)input;
            input >>= 8;
            ++i;
        }
        return result;
    }

    private static String intToStr(int value, int length) {
        String result = Integer.toString(value);
        result = "0000".substring(result.length(), length) + result;
        return result;
    }

    public static boolean isChannel(String chan) {
        int temp = 32;
        if (chan.length() > 0) {
            temp = chan.charAt(0);
        }
        return temp == 35 || temp == 38 || temp == 33;
    }

    public static byte[] mergeByteArrays(byte[] inp1, byte[] inp2) {
        byte[] ret = new byte[inp1.length + inp2.length];
        System.arraycopy(inp1, 0, ret, 0, inp1.length);
        System.arraycopy(inp2, 0, ret, inp1.length, inp2.length);
        return ret;
    }

    public static String[] mergeStringArray(String[] inp1, String[] inp2) {
        String[] ret = new String[inp1.length + inp2.length];
        System.arraycopy(inp1, 0, ret, 0, inp1.length);
        System.arraycopy(inp2, 0, ret, inp1.length, inp2.length);
        return inp2;
    }

    public static int parseInt(String input) {
        int ret = 0;
        try {
            ret = Integer.parseInt(input);
        }
        catch (NumberFormatException nfe) {}
        return ret;
    }

    public static byte[] readLine(InputStream is) throws IOException {
        byte[] buf = new byte[512];
        int i = 0;
        while (i < 512) {
            int readbyte = is.read();
            if (readbyte == -1) {
                throw new EOFException();
            }
            buf[i] = (byte)readbyte;
            if (buf[i] == 10) break;
            ++i;
        }
        if (i == 512) {
            return null;
        }
        if (i > 0 && buf[i - 1] == 13) {
            --i;
        }
        byte[] ret = new byte[i];
        System.arraycopy(buf, 0, ret, 0, i);
        return ret;
    }

    public static String replace(String source, String str1, String str2) {
        while (source.indexOf(str1) > -1) {
            source = source.substring(0, source.indexOf(str1)) + str2 + source.substring(source.indexOf(str1) + str1.length());
        }
        return source;
    }

    public static String setEncoding(String str, String encoding) {
        String ret;
        char[] map = null;
        byte[] bytes = str.getBytes();
        if (encoding.toUpperCase().equals("KOI8-R")) {
            map = koi8rmap;
        } else if (encoding.toUpperCase().equals("WINDOWS-1251")) {
            map = cp1251map;
        }
        if (map != null) {
            char[] chars = new char[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                byte b = bytes[i];
                chars[i] = b >= 0 ? (char)b : map[b + 128];
                ++i;
            }
            ret = new String(chars);
        } else {
            try {
                ret = new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                ret = new String(bytes);
            }
        }
        return ret;
    }

    public static String[] splitMessageString(String str) {
        String[] s = new String[]{str};
        return s;
    }

    public static String[] splitString(String str, String delims) {
        if (str == null || str.equals("") || delims == null || delims.length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int pos = 0;
        int newpos = str.indexOf(delims, pos);
        while (newpos != -1) {
            v.addElement(str.substring(pos, newpos));
            pos = newpos + delims.length();
            newpos = str.indexOf(delims, pos);
        }
        v.addElement(str.substring(pos));
        String[] s = new String[v.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = (String)v.elementAt(i);
            ++i;
        }
        return s;
    }

    public static String[] splitString(String str, int partLen) {
        if (str == null || str.equals("")) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        while (partLen < str.length()) {
            System.out.println(str.substring(0, partLen));
            v.addElement(str.substring(0, partLen));
            str = str.substring(partLen + 1);
            System.out.println("=" + str);
        }
        if (str.length() > 0) {
            v.addElement(str);
        }
        String[] s = new String[v.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = (String)v.elementAt(i);
            ++i;
        }
        return s;
    }

    public static String[] splitString(String str, SampleFont sampleFont, int width) {
        Vector<String> temp = new Vector<String>();
        while (str.length() > 0) {
            int i = str.length();
            while (i >= 0 & sampleFont.substringWidth(str, 0, i) > width) {
                --i;
            }
            temp.addElement(str.substring(0, i));
            str = str.substring(i);
        }
        String[] result = new String[temp.size()];
        int j = 0;
        while (j < result.length) {
            result[j] = (String)temp.elementAt(j);
            ++j;
        }
        return result;
    }

    public static String[] splitString(String str, Font font, int width) {
        Vector<String> temp = new Vector<String>();
        while (str.length() > 0) {
            int i = str.length();
            while (i >= 0 & font.substringWidth(str, 0, i) > width) {
                --i;
            }
            temp.addElement(str.substring(0, i));
            str = str.substring(i);
        }
        String[] result = new String[temp.size()];
        int j = 0;
        while (j < result.length) {
            result[j] = (String)temp.elementAt(j);
            ++j;
        }
        return result;
    }

    public static byte[] stringToByteArray(String string, String encoding) {
        byte[] ret;
        if (encoding.equals("KOI8-R") || encoding.equals("Windows-1251")) {
            if (hashmap == null || !encoding.equals((String)hashmap.get("encoding"))) {
                if (encoding.equals("KOI8-R")) {
                    hashmap = Utils.generateHashmap(koi8rmap);
                } else if (encoding.equals("Windows-1251")) {
                    hashmap = Utils.generateHashmap(cp1251map);
                }
                hashmap.put("encoding", encoding);
            }
            char[] chars = string.toCharArray();
            byte[] bytes = new byte[chars.length];
            int i = 0;
            while (i < chars.length) {
                Byte b;
                bytes[i] = chars[i] < '\u0080' ? (int)chars[i] : ((b = (Byte)hashmap.get(new Character(chars[i]))) == null ? 63 : (int)b.byteValue());
                ++i;
            }
            ret = bytes;
        } else {
            try {
                ret = string.getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                ret = string.getBytes();
            }
        }
        return ret;
    }
}

