/*
 * Decompiled with CFR 0.152.
 */
package lib.Resources;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Hashtable;

public class ResourcesUTF8 {
    public static final char DELIMITER = '=';
    private StringBuffer buffer = new StringBuffer();
    private boolean endFile = false;
    private boolean error = false;
    private String fileName;
    private Hashtable hashtable;
    private boolean load = false;

    public ResourcesUTF8(String fileName) {
        this.fileName = fileName;
    }

    public String get(String name) {
        if (!this.load && !this.load()) {
            return "";
        }
        String str = (String)this.hashtable.get(name);
        if (str == null) {
            return "";
        }
        return str;
    }

    private int getByte(InputStream in) throws IOException, UTFDataFormatException {
        int r = in.read();
        if (r < 0 || r == 10) {
            this.endFile = true;
            throw new UTFDataFormatException();
        }
        return r;
    }

    private InputStream getInputStream() {
        if (this.error) {
            return null;
        }
        return this.getClass().getResourceAsStream(this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        if (this.error) {
            return false;
        }
        FilterInputStream in = null;
        try {
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            in = new DataInputStream(inputStream);
            this.hashtable = new Hashtable();
            this.endFile = false;
            this.buffer = new StringBuffer();
            String str = this.readKey((DataInputStream)in);
            while (str != null) {
                String value;
                String key = str.trim();
                if (key.length() > 0 && (value = this.readValue(in)) != null) {
                    this.hashtable.put(key, value.trim());
                }
                str = this.readKey((DataInputStream)in);
            }
            in.close();
            this.load = true;
            boolean bl = true;
            return bl;
        }
        catch (Exception io) {
            this.error = true;
            this.unload();
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                }
            }
        }
    }

    private String readKey(DataInputStream in) throws IOException {
        if (this.endFile) {
            return null;
        }
        this.buffer.setLength(0);
        int r = -1;
        while ((r = in.read()) > 0 && r != 10 && r != 61) {
            char c = (char)r;
            this.buffer.append(c);
        }
        if (r == -1) {
            this.endFile = true;
            return null;
        }
        return this.buffer.toString();
    }

    private String readValue(InputStream in) throws IOException {
        if (this.endFile) {
            return null;
        }
        this.buffer.setLength(0);
        int r = 0;
        while ((r = in.read()) > 0 && r != 10) {
            int c = r & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.buffer.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    int char2 = this.getByte(in);
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.buffer.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    break;
                }
                case 14: {
                    int char2 = this.getByte(in);
                    int char3 = this.getByte(in);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.buffer.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return this.buffer.toString();
    }

    public void unload() {
        this.hashtable = null;
        this.load = false;
        this.endFile = true;
        this.buffer = null;
    }
}

