/*
 * Decompiled with CFR 0.152.
 */
package lib.GraphicControls;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lib.Font.SampleFont;
import lib.GraphicControls.SplashScreenCommandListener;
import lib.Utils.Utils;

public class SplashScreen
extends Canvas {
    private Image IMG_LOAD;
    private Image IMG_LOGO;
    private Font font = null;
    private int fontHeight;
    private int fontSize = 8;
    private int height;
    private String loadingString = " ";
    private String loadingString1 = " ";
    private String loadingString2 = " ";
    private progressBar pb;
    private SampleFont sampleFont = null;
    private SplashScreenCommandListener sscl = null;
    private Graphics tg;
    private Image ti;
    private int width;

    public void addLoadingString(String str) {
        this.loadingString2 = this.loadingString1;
        this.loadingString1 = this.loadingString;
        this.loadingString = str;
        if (this.fontSize < 0) {
            if (this.sampleFont.stringWidth(this.loadingString) > this.width - 15) {
                this.loadingString = Utils.splitString(this.loadingString, this.sampleFont, this.width - 15 - this.sampleFont.stringWidth("..."))[0];
                this.loadingString = this.loadingString + "...";
            }
        } else if (this.font.stringWidth(this.loadingString) > this.width - 15) {
            this.loadingString = Utils.splitString(this.loadingString, this.font, this.width - 15 - this.font.stringWidth("..."))[0];
            this.loadingString = this.loadingString + "...";
        }
        this.updateLoadingString();
    }

    private void drawLogo() {
        this.tg.setColor(180, 180, 180);
        this.tg.drawRect(0, 0, this.width - 1, this.height - 1);
        this.tg.setColor(191, 193, 208);
        this.tg.drawRect(1, 1, this.width - 3, this.height - 3);
        this.tg.setColor(241, 241, 241);
        this.tg.drawRect(1, 1, this.width - 4, this.height - 4);
        this.tg.setColor(219, 222, 232);
        this.tg.drawRect(2, 2, this.width - 5, this.height - 5);
        this.tg.setColor(255, 255, 255);
        this.tg.drawRect(2, 2, this.width - 6, this.height - 6);
        this.tg.setColor(212, 208, 200);
        this.tg.drawRect(3, 3, this.width - 7, this.height - 7);
        this.tg.setColor(241, 243, 248);
        this.tg.fillRect(4, 4, this.width - 8, this.height - 8);
        if (this.IMG_LOGO != null) {
            this.tg.drawImage(this.IMG_LOGO, this.width / 2 - this.IMG_LOGO.getWidth() / 2, 20, 0);
        }
    }

    protected void keyPressed(int keyCode) {
        if ((keyCode == 35 || keyCode == -7 || keyCode == -4 || keyCode == -12) && this.sscl != null) {
            this.sscl.onCancel(this);
        }
    }

    private Image loadImageFromFile(String filename) {
        Image temp = null;
        try {
            temp = Image.createImage((String)filename);
        }
        catch (IOException ioexception) {}
        return temp;
    }

    protected void paint(Graphics g) {
        if (this.isShown()) {
            g.drawImage(this.ti, 0, 0, 0);
        }
    }

    public void setAttributes(String logoFilename, int heightdiff, int fontSize) {
        this.fontSize = fontSize;
        this.pb = null;
        this.width = this.getWidth();
        this.height = this.getHeight() + heightdiff;
        if (fontSize < 0) {
            this.sampleFont = new SampleFont("/fonts/font.bin");
            this.fontHeight = this.sampleFont.height;
        } else {
            this.font = Font.getFont((int)0, (int)0, (int)fontSize);
            this.fontHeight = this.font.getHeight();
        }
        this.IMG_LOGO = this.loadImageFromFile(logoFilename);
        this.ti = Image.createImage((int)this.width, (int)this.height);
        this.tg = this.ti.getGraphics();
        this.drawLogo();
        this.pb = new progressBar();
        this.pb.start();
        this.repaint();
    }

    public void setLoadingString(String str) {
        this.loadingString = str;
        if (this.fontSize < 0) {
            if (this.sampleFont.stringWidth(this.loadingString) > this.width - 15) {
                this.loadingString = Utils.splitString(this.loadingString, this.sampleFont, this.width - 15 - this.sampleFont.stringWidth("..."))[0];
                this.loadingString = this.loadingString + "...";
            }
        } else if (this.font.stringWidth(this.loadingString) > this.width - 15) {
            this.loadingString = Utils.splitString(this.loadingString, this.font, this.width - 15 - this.font.stringWidth("..."))[0];
            this.loadingString = this.loadingString + "...";
        }
        this.updateLoadingString();
    }

    public void setSSCommandListener(SplashScreenCommandListener sscl) {
        this.sscl = sscl;
    }

    private void updateLoadingString() {
        int topPos = this.height - 3 * this.fontHeight - 5;
        this.tg.setClip(4, topPos, this.width - 8, 3 * this.fontHeight + 1);
        this.tg.setColor(241, 243, 248);
        this.tg.fillRect(4, topPos, this.width - 8, 2 * this.fontHeight + 4);
        this.tg.fillRect(4, topPos + 2 * this.fontHeight, this.width - this.IMG_LOAD.getWidth() - 10, this.fontHeight + 1);
        topPos -= 2;
        if (this.fontSize < 0) {
            Utils.drawFramedText(this.tg, this.sampleFont, this.loadingString2, 6, topPos, 0xFFFFFF, 0xCDCDCD);
            Utils.drawFramedText(this.tg, this.sampleFont, this.loadingString1, 6, topPos += this.fontHeight, 0xFFFFFF, 0x909090);
            String temp = this.loadingString;
            if (this.sampleFont.stringWidth(this.loadingString) > this.width - 15 - this.IMG_LOAD.getWidth()) {
                temp = Utils.splitString(this.loadingString, this.sampleFont, this.width - this.IMG_LOAD.getWidth() - 15 - this.font.stringWidth("..."))[0];
                temp = temp + "...";
            }
            Utils.drawFramedText(this.tg, this.sampleFont, temp, 6, topPos += this.fontHeight, 0xFFFFFF, 0);
        } else {
            Utils.drawFramedText(this.tg, this.font, this.loadingString2, 6, topPos, 0xFFFFFF, 0xCDCDCD);
            Utils.drawFramedText(this.tg, this.font, this.loadingString1, 6, topPos += this.fontHeight, 0xFFFFFF, 0x909090);
            String temp = this.loadingString;
            if (this.font.stringWidth(this.loadingString) > this.width - 15 - this.IMG_LOAD.getWidth()) {
                temp = Utils.splitString(this.loadingString, this.font, this.width - this.IMG_LOAD.getWidth() - 15 - this.font.stringWidth("..."))[0];
                temp = temp + "...";
            }
            Utils.drawFramedText(this.tg, this.font, temp, 6, topPos += this.fontHeight, 0xFFFFFF, 0);
        }
        if ((topPos -= 2 * this.fontHeight + 2) < 20 + this.IMG_LOGO.getHeight() + 5) {
            topPos = 20 + this.IMG_LOGO.getHeight() + 7;
        }
        this.repaint(4, topPos, this.width - 8, 3 * this.fontHeight + 8);
    }

    private void updateProgressBar() {
        this.tg.drawImage(this.IMG_LOAD, this.width - this.IMG_LOAD.getWidth() - 6, this.height - this.IMG_LOAD.getHeight() - 5, 20);
        this.repaint(this.width - this.IMG_LOAD.getWidth() - 6, this.height - this.IMG_LOAD.getHeight() - 5, this.IMG_LOAD.getWidth(), this.IMG_LOAD.getHeight());
    }

    private class progressBar
    extends Thread {
        public boolean loading = true;
        public Graphics temp;

        public progressBar() {
            SplashScreen.this.IMG_LOAD = Image.createImage((int)26, (int)8);
            this.temp = SplashScreen.this.IMG_LOAD.getGraphics();
        }

        public void run() {
            int i = 0;
            while (this.loading) {
                this.temp.setColor(160, 160, 160);
                this.temp.fillRect(0, 0, 26, 8);
                this.temp.setColor(225, 225, 225);
                this.temp.fillRect(0, 0, 25, 7);
                this.temp.setColor(212, 208, 200);
                this.temp.drawLine(25, 0, 25, 1);
                this.temp.drawLine(0, 7, 1, 8);
                this.temp.setColor(0);
                int j = 0;
                while (j < 4) {
                    this.temp.drawRect(j * 6, 0, 6, 6);
                    ++j;
                }
                if (i > 3) {
                    i = 0;
                }
                this.temp.setColor(0, 150, 40);
                this.temp.fillRect(i * 6, 0, 6, 6);
                this.temp.setColor(145, 220, 173);
                this.temp.fillRect(i * 6 + 1, 1, 4, 4);
                this.temp.setColor(0, 184, 160);
                this.temp.fillRect(i * 6 + 2, 2, 3, 3);
                SplashScreen.this.updateProgressBar();
                ++i;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                }
            }
        }
    }
}

