/*
 * Decompiled with CFR 0.152.
 */
package lib.GraphicControls;

import inettools.UIHandler;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lib.Font.SampleFont;
import lib.Resources.ImageList;
import lib.Utils.Utils;

public class TextList {
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_RECT = 1;
    public static final int TYPE_PLAIN = 0;
    public static final int TYPE_URL = 1;
    public int currentItem = 0;
    public int cursorStyle = 0;
    public int fontSize;
    private ImageList images;
    public Vector items;
    private SampleFont sampleFont = null;
    public int textListHeight;
    public int textListWidth;
    public int topItem = 0;
    public int topPosition = 0;

    public TextList(int textListWidth, int textListHeight, int fontSize, int cursorStyle, ImageList images) {
        this.textListWidth = textListWidth - 3;
        this.textListHeight = textListHeight - 3;
        this.fontSize = fontSize;
        this.cursorStyle = cursorStyle;
        this.images = images;
        if (fontSize < 0) {
            this.sampleFont = new SampleFont("/fonts/font.bin");
        }
        this.items = new Vector();
    }

    public void addImage(int imageIndex, int itemIndex) {
        if (this.images != null && imageIndex > -1 && imageIndex < this.images.getSize()) {
            if (itemIndex < this.items.size()) {
                ((ListItem)this.items.elementAt(itemIndex)).addImage(imageIndex);
            } else {
                this.addImage(imageIndex);
            }
        }
    }

    public void addImage(int imageIndex) {
        if (this.images != null && imageIndex > -1 && imageIndex < this.images.getSize()) {
            this.items.addElement(new ListItem());
            ((ListItem)this.items.lastElement()).addImage(imageIndex);
        }
    }

    public void addImage(Image image, int itemIndex) {
        if (itemIndex < this.items.size()) {
            ((ListItem)this.items.elementAt(itemIndex)).addImage(image);
        } else {
            this.addImage(image);
        }
    }

    public void addImage(Image image) {
        this.items.addElement(new ListItem());
        ((ListItem)this.items.lastElement()).addImage(image);
    }

    public void addItem() {
        this.items.addElement(new ListItem());
    }

    public void addText(String text, int fontColor, int bgColor, int fontStyle, int fontSize, int itemIndex) {
        if (text.length() > 0) {
            if (itemIndex < this.items.size()) {
                if (fontSize == -1) {
                    ((ListItem)this.items.elementAt(itemIndex)).addText(text, this.sampleFont);
                } else {
                    ((ListItem)this.items.elementAt(itemIndex)).addText(text, fontColor, bgColor, fontStyle, fontSize);
                }
            } else {
                this.items.addElement(new ListItem());
                if (fontSize == -1) {
                    ((ListItem)this.items.elementAt(itemIndex)).addText(text, this.sampleFont);
                } else {
                    ((ListItem)this.items.elementAt(itemIndex)).addText(text, fontColor, bgColor, fontStyle, fontSize);
                }
            }
        }
    }

    public void addText(String text, int fontColor, int bgColor, int fontStyle, int fontSize) {
        this.addText(text, fontColor, bgColor, fontStyle, fontSize, this.items.size());
    }

    public void addText(String text, int itemIndex) {
        this.addText(text, 0, 0xFFFFFF, 0, this.fontSize, itemIndex);
    }

    public void addText(String text) {
        this.addText(text, 0, 0xFFFFFF, 0, this.fontSize);
    }

    public void addTextWithURL(String text, int fontColor, int bgColor, int fontStyle, int fontSize, int itemIndex) {
        if (text.length() > 0) {
            int URLIndex = text.toLowerCase().indexOf("http://");
            if (URLIndex == -1) {
                URLIndex = text.toLowerCase().indexOf("ftp://");
            }
            if (URLIndex == -1) {
                URLIndex = text.toLowerCase().indexOf("mailto:");
            }
            if (URLIndex == -1) {
                URLIndex = text.toLowerCase().indexOf("www.");
            }
            if (URLIndex == -1) {
                URLIndex = text.toLowerCase().indexOf("https://");
            }
            if (URLIndex > -1) {
                String temp = text;
                if (URLIndex > 1) {
                    temp = temp.substring(0, URLIndex - 1);
                    this.addTextWithURL(temp, fontColor, bgColor, fontStyle, fontSize, itemIndex);
                }
                temp = text.substring(URLIndex);
                int splitIndex = 0;
                while (splitIndex < temp.length()) {
                    char ch = temp.charAt(splitIndex);
                    if (!(ch >= '-' && ch <= ':' || ch >= '@' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '?' || ch == '=' || ch == '_' || ch == '&' || ch == '%')) break;
                    ++splitIndex;
                }
                if (splitIndex > -1) {
                    this.addURL(temp.substring(0, splitIndex), bgColor);
                    temp = temp.substring(splitIndex);
                    this.addTextWithURL(temp, fontColor, bgColor, fontStyle, fontSize, this.items.size());
                } else {
                    this.addURL(temp, bgColor);
                }
            } else if (itemIndex < this.items.size()) {
                ((ListItem)this.items.elementAt(itemIndex)).addText(text, fontColor, bgColor, fontStyle, fontSize);
            } else {
                this.items.addElement(new ListItem());
                ((ListItem)this.items.elementAt(itemIndex)).addText(text, fontColor, bgColor, fontStyle, fontSize);
            }
        }
    }

    public void addTextWithURL(String text) {
        this.addTextWithURL(text, 0, 0xFFFFFF, 0, this.fontSize, this.items.size());
    }

    public void addURL(String URL2, int bgColor) {
        this.items.addElement(new ListItem());
        ((ListItem)this.items.lastElement()).type = 1;
        ((ListItem)this.items.lastElement()).addText(URL2, 255, bgColor, 4, this.fontSize);
    }

    public void clear() {
        this.items.removeAllElements();
        this.topPosition = 0;
        this.topItem = 0;
        this.currentItem = 0;
    }

    public void deleteItem(int itemIndex) {
        this.items.removeElementAt(itemIndex);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void down() {
        block5: {
            if (this.currentItem >= this.items.size()) break block5;
            if (this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition < this.textListHeight && this.currentItem < this.items.size() - 1) {
                ++this.currentItem;
            }
            boolean bl = true;
            do {
                block7: {
                    block6: {
                        block9: {
                            block8: {
                                if (!bl || (bl = false)) break block6;
                                if (this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition < this.textListHeight) break block7;
                                if (this.topPosition + ((ListItem)this.items.elementAt((int)this.currentItem)).height <= this.textListHeight) break block8;
                                this.topPosition -= 24;
                                if (this.topPosition + ((ListItem)this.items.elementAt((int)this.currentItem)).height < this.textListHeight) {
                                    this.topPosition = this.textListHeight - ((ListItem)this.items.elementAt((int)this.currentItem)).height - 2;
                                }
                                break block7;
                            }
                            if (this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition != this.textListHeight) break block9;
                            if (this.currentItem < this.items.size() - 1) {
                                ++this.currentItem;
                            }
                            this.topPosition = this.topPosition + ((ListItem)this.items.elementAt((int)this.currentItem)).height > this.textListHeight ? (this.topPosition -= 24) : (this.topPosition -= this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition - this.textListHeight + 2);
                            break block7;
                        }
                        this.topPosition -= this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition - this.textListHeight + 2;
                        if (true) break block7;
                    }
                    this.topPosition += ((ListItem)this.items.elementAt((int)this.topItem)).height;
                    ++this.topItem;
                }
                if (this.topPosition + ((ListItem)this.items.elementAt((int)this.topItem)).height > 0) break;
            } while (this.topItem < this.items.size() - 1);
        }
    }

    private void drawItems(Graphics g, int left, int top) {
        top += 2;
        if (!this.items.isEmpty()) {
            int drawedItem = this.topItem;
            int oldTop = top - this.topPosition;
            while (top - oldTop < this.textListHeight & drawedItem < this.items.size()) {
                if (drawedItem == this.currentItem & this.cursorStyle == 1) {
                    g.setColor(Integer.parseInt(UIHandler.kursor[0]) * 65536 + Integer.parseInt(UIHandler.kursor[1]) * 256 + Integer.parseInt(UIHandler.kursor[2]));
                    g.fillRect(left + 3, top, this.textListWidth - 6, ((ListItem)this.items.elementAt((int)drawedItem)).height);
                    g.setColor(180, 180, 180);
                    g.drawLine(left + 2, top, left + 2, top + ((ListItem)this.items.elementAt((int)drawedItem)).height - 1);
                    g.drawLine(left + 3, top - 1, left + this.textListWidth - 4, top - 1);
                    g.drawLine(left + 3, top + ((ListItem)this.items.elementAt((int)drawedItem)).height, left + this.textListWidth - 4, top + ((ListItem)this.items.elementAt((int)drawedItem)).height);
                    g.drawLine(left + this.textListWidth - 3, top, left + this.textListWidth - 3, top + ((ListItem)this.items.elementAt((int)drawedItem)).height - 1);
                }
                ((ListItem)this.items.elementAt(drawedItem)).paint(g, left, top);
                top += ((ListItem)this.items.elementAt((int)drawedItem)).height;
                ++drawedItem;
            }
        }
    }

    private void drawScrollBar(Graphics g, int left, int top) {
        int x = left + this.textListWidth;
        g.setColor(180, 180, 180);
        g.drawRect(x - 1, top, 4, this.textListHeight);
        g.setColor(230, 230, 230);
        g.drawRect(x, top, 1, this.textListHeight);
        if (!this.items.isEmpty()) {
            int n = this.getItemsHeight(0, this.items.size() - 1) * 1000 / this.textListHeight;
            int y = top;
            if (n != 0) {
                y += (-this.topPosition + this.getItemsHeight(0, this.topItem) - ((ListItem)this.items.elementAt((int)this.topItem)).height) * 1000 / n;
            }
            int scrollBarHeight = 0;
            if (n != 0) {
                scrollBarHeight = this.textListHeight * 1000 / n;
            }
            if (scrollBarHeight < this.textListHeight) {
                g.setColor(170, 200, 250);
                g.fillRect(x, y, 2, scrollBarHeight);
                g.setColor(100, 130, 180);
                g.fillRect(x + 1, y, 1, scrollBarHeight);
                g.setColor(100, 100, 100);
                g.drawRect(x - 1, y, 3, scrollBarHeight);
            }
        }
    }

    public void end() {
        this.topItem = 0;
        this.currentItem = this.items.size() - 1;
        if (this.getItemsHeight(0, this.currentItem) > this.textListHeight) {
            this.topPosition = this.textListHeight - this.getItemsHeight(0, this.currentItem) - 2;
            while (this.topPosition + ((ListItem)this.items.elementAt((int)this.topItem)).height <= 0 & this.topItem < this.items.size() - 2) {
                this.topPosition += ((ListItem)this.items.elementAt((int)this.topItem)).height;
                ++this.topItem;
            }
        }
    }

    public String getItemText(int index) {
        if (index > -1 && index < this.items.size()) {
            return ((ListItem)this.items.elementAt((int)index)).text;
        }
        return "";
    }

    public int getItemType(int index) {
        return ((ListItem)this.items.elementAt((int)index)).type;
    }

    private int getItemsHeight(int from, int to) {
        int height = 0;
        int i = from;
        while (i <= to) {
            height += ((ListItem)this.items.elementAt((int)i)).height;
            ++i;
        }
        return height;
    }

    public void home() {
        this.topPosition = 0;
        this.currentItem = 0;
        this.topItem = 0;
    }

    public void insertImage(int imageIndex, int index) {
        if (this.images != null && imageIndex > -1 && imageIndex < this.images.getSize()) {
            this.items.insertElementAt(new ListItem(), index);
            ((ListItem)this.items.elementAt(index)).addImage(imageIndex);
        }
    }

    public void insertImage(Image image, int index) {
        this.items.insertElementAt(new ListItem(), index);
        ((ListItem)this.items.elementAt(index)).addImage(image);
    }

    public void insertText(String text, int index) {
        this.items.insertElementAt(new ListItem(), index);
        ((ListItem)this.items.elementAt(index)).addText(text, 0, 0xFFFFFF, 0, this.fontSize);
    }

    public void pageDown() {
        if (this.getItemsHeight(0, this.items.size() - 1) > this.textListHeight - 5) {
            if (this.getItemsHeight(this.topItem, this.items.size() - 1) + this.topPosition >= this.textListHeight * 2) {
                this.topPosition -= this.textListHeight;
                while (this.topPosition + ((ListItem)this.items.elementAt((int)this.topItem)).height < 0 & this.topItem < this.items.size() - 2) {
                    this.topPosition += ((ListItem)this.items.elementAt((int)this.topItem)).height;
                    ++this.topItem;
                }
            } else {
                this.topPosition -= this.getItemsHeight(this.topItem, this.items.size() - 1) + this.topPosition - this.textListHeight;
                while (this.topPosition + ((ListItem)this.items.elementAt((int)this.topItem)).height <= 0 & this.topItem < this.items.size() - 2) {
                    this.topPosition += ((ListItem)this.items.elementAt((int)this.topItem)).height;
                    ++this.topItem;
                }
            }
            while (this.topPosition + this.getItemsHeight(this.topItem, this.currentItem) < this.textListHeight && this.currentItem < this.items.size()) {
                ++this.currentItem;
            }
            this.topItem = this.currentItem;
            --this.topPosition;
        }
    }

    public void pageUp() {
        int oldTopItem = this.topItem;
        if (this.getItemsHeight(0, this.topItem) > this.textListHeight) {
            this.topPosition = 0;
            while (this.getItemsHeight(this.topItem, oldTopItem) < this.textListHeight & this.topItem > 0) {
                --this.topItem;
            }
        } else {
            this.topPosition = 0;
            this.topItem = 0;
        }
        this.currentItem = this.topItem;
    }

    public void paint(Graphics g, int left, int top) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(left, top, this.textListWidth + 3, this.textListHeight + 1);
        g.setColor(Integer.parseInt(UIHandler.fon[0]) * 65536 + Integer.parseInt(UIHandler.fon[1]) * 256 + Integer.parseInt(UIHandler.fon[2]));
        g.fillRect(left, top + 1, this.textListWidth + 3, this.textListHeight);
        this.drawItems(g, left, top + this.topPosition);
        this.drawScrollBar(g, left, top + 1);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        g.setColor(100, 100, 100);
        g.drawRect(left, top, this.textListWidth + 2, this.textListHeight + 1);
    }

    public void setAttributes(int textListWidth, int textListHeight, int fontSize, int cursorStyle, ImageList images) {
        this.textListWidth = textListWidth - 3;
        this.textListHeight = textListHeight - 3;
        this.fontSize = fontSize;
        this.cursorStyle = cursorStyle;
    }

    public void setImageList(ImageList imagelist) {
        this.images = imagelist;
    }

    public void up() {
        if (this.currentItem > 0 || this.topPosition < 0) {
            if (this.currentItem > this.topItem) {
                --this.currentItem;
            } else if (this.topPosition < 0) {
                this.topPosition += 24;
                if (this.topPosition > 0) {
                    this.topPosition = 0;
                }
            } else {
                this.topPosition = 0;
                --this.topItem;
                --this.currentItem;
                if (((ListItem)this.items.elementAt((int)this.currentItem)).height > this.textListHeight) {
                    this.topPosition = this.textListHeight - ((ListItem)this.items.elementAt((int)this.currentItem)).height;
                }
            }
        }
    }

    private class ListItem {
        public int height = 0;
        private Vector lines = new Vector();
        public String text = "";
        public int type = 0;

        public void addImage(int imageIndex) {
            if (this.lines.isEmpty()) {
                this.lines.addElement(new LineItem());
            }
            if (!((LineItem)this.lines.lastElement()).addImage(imageIndex)) {
                this.lines.addElement(new LineItem());
                ((LineItem)this.lines.lastElement()).addImage(imageIndex);
            }
            this.getHeight();
        }

        public void addImage(Image image) {
            if (this.lines.isEmpty()) {
                this.lines.addElement(new LineItem());
            }
            if (!((LineItem)this.lines.lastElement()).addImage(image)) {
                this.lines.addElement(new LineItem());
                ((LineItem)this.lines.lastElement()).addImage(image);
            }
            this.getHeight();
        }

        public void addText(String text, SampleFont sampleFont) {
            this.text = this.text + text;
            if (this.lines.isEmpty()) {
                this.lines.addElement(new LineItem());
            }
            text = Utils.replace(text, "\r\n", "\n\n");
            text = Utils.replace(text, "\r", "\n");
            String[] strings = Utils.splitString(text, "\n");
            int i = 0;
            while (i < strings.length) {
                if (strings[i].equals("")) {
                    this.lines.addElement(new LineItem());
                    ((LineItem)this.lines.lastElement()).addText(" ", sampleFont);
                } else {
                    if (strings.length > 1) {
                        this.lines.addElement(new LineItem());
                    }
                    String[] words = Utils.splitString(strings[i], " ");
                    int j = 0;
                    while (j < words.length) {
                        if (!((LineItem)this.lines.lastElement()).addText(words[j] + " ", sampleFont)) {
                            this.lines.addElement(new LineItem());
                            if (words[j].length() == 0) {
                                ((LineItem)this.lines.lastElement()).addText(" ", sampleFont);
                            } else if (!((LineItem)this.lines.lastElement()).addText(words[j] + " ", sampleFont)) {
                                String[] word = Utils.splitString(words[j], sampleFont, TextList.this.textListWidth - 10);
                                int k = 0;
                                while (k < word.length) {
                                    if (!((LineItem)this.lines.lastElement()).addText(word[k], sampleFont)) {
                                        this.lines.addElement(new LineItem());
                                        ((LineItem)this.lines.lastElement()).addText(word[k], sampleFont);
                                    }
                                    ++k;
                                }
                                ((LineItem)this.lines.lastElement()).addText(" ", sampleFont);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.getHeight();
        }

        public void addText(String text, int fontColor, int bgColor, int fontStyle, int fontSize) {
            this.text = this.text + text;
            if (this.lines.isEmpty()) {
                this.lines.addElement(new LineItem());
            }
            text = Utils.replace(text, "\r\n", "\n\n");
            text = Utils.replace(text, "\r", "\n");
            String[] strings = Utils.splitString(text, "\n");
            int i = 0;
            while (i < strings.length) {
                if (!strings[i].equals("")) {
                    if (strings.length > 1) {
                        this.lines.addElement(new LineItem());
                    }
                    String[] words = Utils.splitString(strings[i], " ");
                    int j = 0;
                    while (j < words.length) {
                        if (!((LineItem)this.lines.lastElement()).addText(words[j] + " ", fontColor, bgColor, fontStyle, fontSize)) {
                            this.lines.addElement(new LineItem());
                            if (words[j].length() == 0) {
                                ((LineItem)this.lines.lastElement()).addText(" ", fontColor, bgColor, fontStyle, fontSize);
                            } else if (!((LineItem)this.lines.lastElement()).addText(words[j] + " ", fontColor, bgColor, fontStyle, fontSize)) {
                                String[] word = Utils.splitString(words[j], Font.getFont((int)0, (int)fontStyle, (int)fontSize), TextList.this.textListWidth - 10);
                                int k = 0;
                                while (k < word.length) {
                                    if (!((LineItem)this.lines.lastElement()).addText(word[k], fontColor, bgColor, fontStyle, fontSize)) {
                                        this.lines.addElement(new LineItem());
                                        ((LineItem)this.lines.lastElement()).addText(word[k], fontColor, bgColor, fontStyle, fontSize);
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.getHeight();
        }

        private void getHeight() {
            this.height = 0;
            int i = 0;
            while (i < this.lines.size()) {
                this.height += ((LineItem)this.lines.elementAt((int)i)).height;
                ++i;
            }
        }

        public void paint(Graphics g, int left, int top) {
            left += 3;
            if (!this.lines.isEmpty()) {
                int i = 0;
                while (i < this.lines.size()) {
                    ((LineItem)this.lines.elementAt(i)).paint(g, left, top);
                    top += ((LineItem)this.lines.elementAt((int)i)).height;
                    ++i;
                }
            }
        }
    }

    private class LineItem {
        public int height = 0;
        private Vector items = new Vector();
        public int width = 0;

        public boolean addImage(int imageIndex) {
            if (this.width + TextList.this.images.getWidth() < TextList.this.textListWidth - 5) {
                this.width += TextList.this.images.getWidth();
                this.items.addElement(new Item(imageIndex));
                if (this.height < TextList.this.images.getHeight()) {
                    this.height = TextList.this.images.getHeight();
                    int i = 0;
                    while (i < this.items.size()) {
                        if (((Item)this.items.elementAt((int)i)).height < this.height) {
                            ((Item)this.items.elementAt((int)i)).height = this.height;
                        }
                        ++i;
                    }
                } else {
                    ((Item)this.items.lastElement()).height = this.height;
                }
                return true;
            }
            return false;
        }

        public boolean addImage(Image image) {
            if (this.width + image.getWidth() < TextList.this.textListWidth - 5) {
                this.width += image.getWidth();
                this.items.addElement(new Item(image));
                if (this.height < image.getHeight()) {
                    this.height = image.getHeight();
                    int i = 0;
                    while (i < this.items.size()) {
                        if (((Item)this.items.elementAt((int)i)).height < this.height) {
                            ((Item)this.items.elementAt((int)i)).height = this.height;
                        }
                        ++i;
                    }
                } else {
                    ((Item)this.items.lastElement()).height = this.height;
                }
                return true;
            }
            return false;
        }

        public boolean addText(String text, SampleFont sampleFont) {
            if (this.width + sampleFont.stringWidth(text) < TextList.this.textListWidth - 5) {
                this.width += sampleFont.stringWidth(text);
                this.items.addElement(new Item(text, sampleFont));
                if (this.height < sampleFont.height) {
                    this.height = sampleFont.height;
                    int i = 0;
                    while (i < this.items.size()) {
                        if (((Item)this.items.elementAt((int)i)).height < this.height) {
                            ((Item)this.items.elementAt((int)i)).height = this.height;
                        }
                        ++i;
                    }
                } else {
                    ((Item)this.items.lastElement()).height = this.height;
                }
                return true;
            }
            return false;
        }

        public boolean addText(String text, int fontColor, int bgColor, int fontStyle, int fontSize) {
            Font font = Font.getFont((int)0, (int)fontStyle, (int)fontSize);
            if (this.width + font.stringWidth(text) < TextList.this.textListWidth - 5) {
                this.width += font.stringWidth(text);
                this.items.addElement(new Item(text, fontColor, bgColor, fontStyle, fontSize));
                if (this.height < font.getHeight()) {
                    this.height = font.getHeight();
                    int i = 0;
                    while (i < this.items.size()) {
                        if (((Item)this.items.elementAt((int)i)).height < this.height) {
                            ((Item)this.items.elementAt((int)i)).height = this.height;
                        }
                        ++i;
                    }
                } else {
                    ((Item)this.items.lastElement()).height = this.height;
                }
                font = null;
                return true;
            }
            font = null;
            return false;
        }

        public void paint(Graphics g, int left, int top) {
            if (!this.items.isEmpty()) {
                int i = 0;
                while (i < this.items.size()) {
                    ((Item)this.items.elementAt(i)).paint(g, left, top);
                    left += ((Item)this.items.elementAt((int)i)).width;
                    ++i;
                }
            }
        }
    }

    private class Item {
        public int bgColor;
        public int fontColor;
        public int fontSize;
        public int fontStyle;
        public int height;
        public Image image = null;
        public int imageIndex = -1;
        private SampleFont sampleFont = null;
        public String text = null;
        public int width;

        public Item(String text, SampleFont sampleFont) {
            this.text = text;
            this.sampleFont = sampleFont;
            this.width = sampleFont.stringWidth(text);
            this.height = sampleFont.height;
        }

        public Item(String text, int fontColor, int bgColor, int fontStyle, int fontSize) {
            this.text = text;
            this.fontColor = fontColor;
            this.bgColor = bgColor;
            this.fontStyle = fontStyle;
            this.fontSize = fontSize;
            Font font = Font.getFont((int)0, (int)fontStyle, (int)fontSize);
            this.width = font.stringWidth(text);
            this.height = font.getHeight();
            font = null;
        }

        public Item(int imageIndex) {
            this.imageIndex = imageIndex;
            this.width = TextList.this.images.getWidth();
            this.height = TextList.this.images.getHeight();
        }

        public Item(Image image) {
            this.image = image;
            this.width = image.getWidth();
            this.height = image.getHeight();
        }

        public void paint(Graphics g, int left, int top) {
            if (this.image != null) {
                g.drawImage(this.image, left, top + this.height - this.image.getHeight(), 20);
                left += this.image.getWidth();
            } else if (TextList.this.images != null && this.imageIndex > -1 && this.imageIndex < TextList.this.images.getSize()) {
                TextList.this.images.drawImage(g, this.imageIndex, left, top + this.height - TextList.this.images.getHeight());
                left += TextList.this.images.getWidth();
            } else if (this.text != null) {
                if (this.sampleFont != null) {
                    this.sampleFont.drawString(g, this.text, left, top + this.height - this.sampleFont.height);
                } else {
                    Font font = Font.getFont((int)0, (int)this.fontStyle, (int)this.fontSize);
                    g.setFont(font);
                    if (this.bgColor != 0xFFFFFF) {
                        g.setColor(this.bgColor);
                        g.fillRect(left, top + this.height - font.getHeight(), font.stringWidth(this.text), font.getHeight());
                    }
                    g.setColor(this.fontColor);
                    g.drawString(this.text, left, top + this.height - font.getHeight(), 20);
                    font = null;
                }
            }
        }
    }
}

