/*
 * Decompiled with CFR 0.152.
 */
package lib.GraphicControls;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lib.Font.SampleFont;
import lib.Resources.ImageList;
import lib.Utils.Utils;
import multime.MultiME;

public class TextList {
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_RECT = 1;
    public static final int TYPE_PLAIN = 0;
    public static final int TYPE_URL = 1;
    public int textListWidth;
    public int textListHeight;
    public int fontSize;
    public int cursorStyle = 0;
    public int currentItem = 0;
    public int topItem = 0;
    public int topPosition = 0;
    public Vector items;
    private ImageList images;
    private SampleFont sampleFont = null;

    public TextList(int n, int n2, int n3, int n4, ImageList imageList) {
        this.textListWidth = n - 3;
        this.textListHeight = n2 - 3;
        this.fontSize = n3;
        this.cursorStyle = n4;
        this.images = imageList;
        if (n3 < 0) {
            this.sampleFont = new SampleFont("/fonts/font.bin");
        }
        this.items = new Vector();
    }

    public void setAttributes(int n, int n2, int n3, int n4, ImageList imageList) {
        this.textListWidth = n - 3;
        this.textListHeight = n2 - 3;
        this.fontSize = n3;
        this.cursorStyle = n4;
    }

    public void setImageList(ImageList imageList) {
        this.images = imageList;
    }

    public int getItemType(int n) {
        return ((ListItem)this.items.elementAt((int)n)).type;
    }

    public String getItemText(int n) {
        if (n > -1 && n < this.items.size()) {
            return ((ListItem)this.items.elementAt((int)n)).text;
        }
        return "";
    }

    public void insertImage(Image image, int n) {
        this.items.insertElementAt(new ListItem(), n);
        ((ListItem)this.items.elementAt(n)).addImage(image);
    }

    public void insertImage(int n, int n2) {
        if (this.images != null && n > -1 && n < this.images.getSize()) {
            this.items.insertElementAt(new ListItem(), n2);
            ((ListItem)this.items.elementAt(n2)).addImage(n);
        }
    }

    public void insertText(String string, int n) {
        this.items.insertElementAt(new ListItem(), n);
        ((ListItem)this.items.elementAt(n)).addText(string, 0, 0xFFFFFF, 0, this.fontSize);
    }

    public void addImage(Image image) {
        this.items.addElement(new ListItem());
        ((ListItem)this.items.lastElement()).addImage(image);
    }

    public void addImage(Image image, int n) {
        if (n < this.items.size()) {
            ((ListItem)this.items.elementAt(n)).addImage(image);
        } else {
            this.addImage(image);
        }
    }

    public void addImage(int n) {
        if (this.images != null && n > -1 && n < this.images.getSize()) {
            this.items.addElement(new ListItem());
            ((ListItem)this.items.lastElement()).addImage(n);
        }
    }

    public void addImage(int n, int n2) {
        if (this.images != null && n > -1 && n < this.images.getSize()) {
            if (n2 < this.items.size()) {
                ((ListItem)this.items.elementAt(n2)).addImage(n);
            } else {
                this.addImage(n);
            }
        }
    }

    public void addText(String string) {
        this.addText(string, 0, 0xFFFFFF, 0, this.fontSize);
    }

    public void addText(String string, int n) {
        this.addText(string, 0, 0xFFFFFF, 0, this.fontSize, n);
    }

    public void addText(String string, int n, int n2, int n3, int n4) {
        this.addText(string, n, n2, n3, n4, this.items.size());
    }

    public void addURL(String string, int n) {
        this.items.addElement(new ListItem());
        ((ListItem)this.items.lastElement()).type = 1;
        ((ListItem)this.items.lastElement()).addText(string, 255, n, 4, this.fontSize);
    }

    public void addText(String string, int n, int n2, int n3, int n4, int n5) {
        if (string.length() > 0) {
            if (n5 < this.items.size()) {
                if (n4 == -1) {
                    ((ListItem)this.items.elementAt(n5)).addText(string, this.sampleFont);
                } else {
                    ((ListItem)this.items.elementAt(n5)).addText(string, n, n2, n3, n4);
                }
            } else {
                this.items.addElement(new ListItem());
                if (n4 == -1) {
                    ((ListItem)this.items.elementAt(n5)).addText(string, this.sampleFont);
                } else {
                    ((ListItem)this.items.elementAt(n5)).addText(string, n, n2, n3, n4);
                }
            }
        }
    }

    public void addTextWithURL(String string) {
        this.addTextWithURL(string, 0, 0xFFFFFF, 0, this.fontSize, this.items.size());
    }

    public void addTextWithURL(String string, int n, int n2, int n3, int n4, int n5) {
        if (string.length() > 0) {
            int n6 = string.toLowerCase().indexOf("http://");
            if (n6 == -1) {
                n6 = string.toLowerCase().indexOf("ftp://");
            }
            if (n6 == -1) {
                n6 = string.toLowerCase().indexOf("mailto:");
            }
            if (n6 == -1) {
                n6 = string.toLowerCase().indexOf("www.");
            }
            if (n6 == -1) {
                n6 = string.toLowerCase().indexOf("https://");
            }
            if (n6 > -1) {
                char c2;
                int n7;
                String string2 = string;
                if (n6 > 1) {
                    string2 = string2.substring(0, n6 - 1);
                    this.addTextWithURL(string2, n, n2, n3, n4, n5);
                }
                string2 = string.substring(n6);
                for (n7 = 0; n7 < string2.length() && ((c2 = string2.charAt(n7)) >= '-' && c2 <= ':' || c2 >= '@' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '?' || c2 == '=' || c2 == '_' || c2 == '&' || c2 == '%'); ++n7) {
                }
                if (n7 > -1) {
                    this.addURL(string2.substring(0, n7), n2);
                    string2 = string2.substring(n7);
                    this.addTextWithURL(string2, n, n2, n3, n4, this.items.size());
                } else {
                    this.addURL(string2, n2);
                }
            } else if (n5 < this.items.size()) {
                ((ListItem)this.items.elementAt(n5)).addText(string, n, n2, n3, n4);
            } else {
                this.items.addElement(new ListItem());
                ((ListItem)this.items.elementAt(n5)).addText(string, n, n2, n3, n4);
            }
        }
    }

    public void addItem() {
        this.items.addElement(new ListItem());
    }

    public void deleteItem(int n) {
        this.items.removeElementAt(n);
    }

    public void up() {
        if (this.currentItem > 0 || this.topPosition < 0) {
            if (this.currentItem > this.topItem) {
                --this.currentItem;
            } else if (this.topPosition < 0) {
                this.topPosition += 24;
                if (this.topPosition > 0) {
                    this.topPosition = 0;
                }
            } else {
                this.topPosition = 0;
                --this.topItem;
                --this.currentItem;
                if (((ListItem)this.items.elementAt((int)this.currentItem)).height > this.textListHeight) {
                    this.topPosition = this.textListHeight - ((ListItem)this.items.elementAt((int)this.currentItem)).height;
                }
            }
        }
    }

    public void down() {
        if (this.currentItem < this.items.size()) {
            if (this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition < this.textListHeight && this.currentItem < this.items.size() - 1) {
                ++this.currentItem;
            }
            if (this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition >= this.textListHeight) {
                if (this.topPosition + ((ListItem)this.items.elementAt((int)this.currentItem)).height > this.textListHeight) {
                    this.topPosition -= 24;
                    if (this.topPosition + ((ListItem)this.items.elementAt((int)this.currentItem)).height < this.textListHeight) {
                        this.topPosition = this.textListHeight - ((ListItem)this.items.elementAt((int)this.currentItem)).height - 2;
                    }
                } else if (this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition == this.textListHeight) {
                    if (this.currentItem < this.items.size() - 1) {
                        ++this.currentItem;
                    }
                    this.topPosition = this.topPosition + ((ListItem)this.items.elementAt((int)this.currentItem)).height > this.textListHeight ? (this.topPosition -= 24) : (this.topPosition -= this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition - this.textListHeight + 2);
                } else {
                    this.topPosition -= this.getItemsHeight(this.topItem, this.currentItem) + this.topPosition - this.textListHeight + 2;
                }
            }
            while (this.topPosition + ((ListItem)this.items.elementAt((int)this.topItem)).height <= 0 && this.topItem < this.items.size() - 1) {
                this.topPosition += ((ListItem)this.items.elementAt((int)this.topItem)).height;
                ++this.topItem;
            }
        }
    }

    public void pageDown() {
        if (this.getItemsHeight(0, this.items.size() - 1) > this.textListHeight - 5) {
            if (this.getItemsHeight(this.topItem, this.items.size() - 1) + this.topPosition >= this.textListHeight * 2) {
                this.topPosition -= this.textListHeight;
                while (this.topPosition + ((ListItem)this.items.elementAt((int)this.topItem)).height < 0 & this.topItem < this.items.size() - 2) {
                    this.topPosition += ((ListItem)this.items.elementAt((int)this.topItem)).height;
                    ++this.topItem;
                }
            } else {
                this.topPosition -= this.getItemsHeight(this.topItem, this.items.size() - 1) + this.topPosition - this.textListHeight;
                while (this.topPosition + ((ListItem)this.items.elementAt((int)this.topItem)).height <= 0 & this.topItem < this.items.size() - 2) {
                    this.topPosition += ((ListItem)this.items.elementAt((int)this.topItem)).height;
                    ++this.topItem;
                }
            }
            while (this.topPosition + this.getItemsHeight(this.topItem, this.currentItem) < this.textListHeight && this.currentItem < this.items.size()) {
                ++this.currentItem;
            }
            this.topItem = this.currentItem;
            --this.topPosition;
        }
    }

    public void pageUp() {
        int n = this.topItem;
        if (this.getItemsHeight(0, this.topItem) > this.textListHeight) {
            this.topPosition = 0;
            while (this.getItemsHeight(this.topItem, n) < this.textListHeight & this.topItem > 0) {
                --this.topItem;
            }
        } else {
            this.topPosition = 0;
            this.topItem = 0;
        }
        this.currentItem = this.topItem;
    }

    public void end() {
        this.topItem = 0;
        this.currentItem = this.items.size() - 1;
        if (this.getItemsHeight(0, this.currentItem) > this.textListHeight) {
            this.topPosition = this.textListHeight - this.getItemsHeight(0, this.currentItem) - 2;
            while (this.topPosition + ((ListItem)this.items.elementAt((int)this.topItem)).height <= 0 & this.topItem < this.items.size() - 2) {
                this.topPosition += ((ListItem)this.items.elementAt((int)this.topItem)).height;
                ++this.topItem;
            }
        }
    }

    public void home() {
        this.topPosition = 0;
        this.currentItem = 0;
        this.topItem = 0;
    }

    public void clear() {
        this.items.removeAllElements();
        this.topPosition = 0;
        this.topItem = 0;
        this.currentItem = 0;
    }

    private int getItemsHeight(int n, int n2) {
        int n3 = 0;
        for (int i2 = n; i2 <= n2; ++i2) {
            n3 += ((ListItem)this.items.elementAt((int)i2)).height;
        }
        return n3;
    }

    private void drawItems(Graphics graphics, int n, int n2) {
        n2 += 2;
        if (!this.items.isEmpty()) {
            int n3 = this.topItem;
            int n4 = n2 - this.topPosition;
            while (n2 - n4 < this.textListHeight & n3 < this.items.size()) {
                if (n3 == this.currentItem & this.cursorStyle == 1) {
                    graphics.setColor(219, 225, 231);
                    graphics.fillRect(n + 3, n2, this.textListWidth - 6, ((ListItem)this.items.elementAt((int)n3)).height);
                    graphics.setColor(180, 180, 180);
                    graphics.drawLine(n + 2, n2, n + 2, n2 + ((ListItem)this.items.elementAt((int)n3)).height - 1);
                    graphics.drawLine(n + 3, n2 - 1, n + this.textListWidth - 4, n2 - 1);
                    graphics.drawLine(n + 3, n2 + ((ListItem)this.items.elementAt((int)n3)).height, n + this.textListWidth - 4, n2 + ((ListItem)this.items.elementAt((int)n3)).height);
                    graphics.drawLine(n + this.textListWidth - 3, n2, n + this.textListWidth - 3, n2 + ((ListItem)this.items.elementAt((int)n3)).height - 1);
                }
                ((ListItem)this.items.elementAt(n3)).paint(graphics, n, n2);
                n2 += ((ListItem)this.items.elementAt((int)n3)).height;
                ++n3;
            }
        }
    }

    private void drawScrollBar(Graphics graphics, int n, int n2) {
        int n3 = n + this.textListWidth;
        graphics.setColor(180, 180, 180);
        graphics.drawRect(n3 - 1, n2, 4, this.textListHeight);
        graphics.setColor(230, 230, 230);
        graphics.drawRect(n3, n2, 1, this.textListHeight);
        if (!this.items.isEmpty()) {
            int n4 = this.getItemsHeight(0, this.items.size() - 1) * 1000 / this.textListHeight;
            int n5 = n2;
            if (n4 != 0) {
                n5 += (-this.topPosition + this.getItemsHeight(0, this.topItem) - ((ListItem)this.items.elementAt((int)this.topItem)).height) * 1000 / n4;
            }
            int n6 = 0;
            if (n4 != 0) {
                n6 = this.textListHeight * 1000 / n4;
            }
            if (n6 < this.textListHeight) {
                graphics.setColor(170, 200, 250);
                graphics.fillRect(n3, n5, 2, n6);
                graphics.setColor(100, 130, 180);
                graphics.fillRect(n3 + 1, n5, 1, n6);
                graphics.setColor(100, 100, 100);
                graphics.drawRect(n3 - 1, n5, 3, n6);
            }
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        graphics.setClip(n, n2, this.textListWidth + 3, this.textListHeight + 1);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(n, n2 + 1, this.textListWidth + 3, this.textListHeight);
        this.drawItems(graphics, n, n2 + this.topPosition);
        this.drawScrollBar(graphics, n, n2 + 1);
        graphics.setClip(n3, n4, n5, n6);
        graphics.setColor(100, 100, 100);
        graphics.drawRect(n, n2, this.textListWidth + 2, this.textListHeight + 1);
    }

    static {
        MultiME.classLoaded("lib.GraphicControls.TextList");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("lib.GraphicControls.TextList");
    }

    public static void staticSuperCleaningRoutine() {
    }

    private class ListItem {
        private Vector lines = new Vector();
        public String text = "";
        public int height = 0;
        public int type = 0;

        public void addImage(Image image) {
            if (this.lines.isEmpty()) {
                this.lines.addElement(new LineItem());
            }
            if (!((LineItem)this.lines.lastElement()).addImage(image)) {
                this.lines.addElement(new LineItem());
                ((LineItem)this.lines.lastElement()).addImage(image);
            }
            this.getHeight();
        }

        public void addImage(int n) {
            if (this.lines.isEmpty()) {
                this.lines.addElement(new LineItem());
            }
            if (!((LineItem)this.lines.lastElement()).addImage(n)) {
                this.lines.addElement(new LineItem());
                ((LineItem)this.lines.lastElement()).addImage(n);
            }
            this.getHeight();
        }

        public void addText(String string, int n, int n2, int n3, int n4) {
            this.text = this.text + string;
            if (this.lines.isEmpty()) {
                this.lines.addElement(new LineItem());
            }
            string = Utils.replace(string, "\r\n", "\n\n");
            string = Utils.replace(string, "\r", "\n");
            String[] stringArray = Utils.splitString(string, "\n");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("")) continue;
                if (stringArray.length > 1) {
                    this.lines.addElement(new LineItem());
                }
                String[] stringArray2 = Utils.splitString(stringArray[i2], " ");
                for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                    if (((LineItem)this.lines.lastElement()).addText(stringArray2[i3] + " ", n, n2, n3, n4)) continue;
                    this.lines.addElement(new LineItem());
                    if (stringArray2[i3].length() == 0) {
                        ((LineItem)this.lines.lastElement()).addText(" ", n, n2, n3, n4);
                        continue;
                    }
                    if (((LineItem)this.lines.lastElement()).addText(stringArray2[i3] + " ", n, n2, n3, n4)) continue;
                    String[] stringArray3 = Utils.splitString(stringArray2[i3], Font.getFont((int)0, (int)n3, (int)n4), TextList.this.textListWidth - 10);
                    for (int i4 = 0; i4 < stringArray3.length; ++i4) {
                        if (((LineItem)this.lines.lastElement()).addText(stringArray3[i4], n, n2, n3, n4)) continue;
                        this.lines.addElement(new LineItem());
                        ((LineItem)this.lines.lastElement()).addText(stringArray3[i4], n, n2, n3, n4);
                    }
                }
            }
            this.getHeight();
        }

        public void addText(String string, SampleFont sampleFont) {
            this.text = this.text + string;
            if (this.lines.isEmpty()) {
                this.lines.addElement(new LineItem());
            }
            string = Utils.replace(string, "\r\n", "\n\n");
            string = Utils.replace(string, "\r", "\n");
            String[] stringArray = Utils.splitString(string, "\n");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("")) {
                    this.lines.addElement(new LineItem());
                    ((LineItem)this.lines.lastElement()).addText(" ", sampleFont);
                    continue;
                }
                if (stringArray.length > 1) {
                    this.lines.addElement(new LineItem());
                }
                String[] stringArray2 = Utils.splitString(stringArray[i2], " ");
                for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                    if (((LineItem)this.lines.lastElement()).addText(stringArray2[i3] + " ", sampleFont)) continue;
                    this.lines.addElement(new LineItem());
                    if (stringArray2[i3].length() == 0) {
                        ((LineItem)this.lines.lastElement()).addText(" ", sampleFont);
                        continue;
                    }
                    if (((LineItem)this.lines.lastElement()).addText(stringArray2[i3] + " ", sampleFont)) continue;
                    String[] stringArray3 = Utils.splitString(stringArray2[i3], sampleFont, TextList.this.textListWidth - 10);
                    for (int i4 = 0; i4 < stringArray3.length; ++i4) {
                        if (((LineItem)this.lines.lastElement()).addText(stringArray3[i4], sampleFont)) continue;
                        this.lines.addElement(new LineItem());
                        ((LineItem)this.lines.lastElement()).addText(stringArray3[i4], sampleFont);
                    }
                    ((LineItem)this.lines.lastElement()).addText(" ", sampleFont);
                }
            }
            this.getHeight();
        }

        public void paint(Graphics graphics, int n, int n2) {
            n += 3;
            if (!this.lines.isEmpty()) {
                for (int i2 = 0; i2 < this.lines.size(); ++i2) {
                    ((LineItem)this.lines.elementAt(i2)).paint(graphics, n, n2);
                    n2 += ((LineItem)this.lines.elementAt((int)i2)).height;
                }
            }
        }

        private void getHeight() {
            this.height = 0;
            for (int i2 = 0; i2 < this.lines.size(); ++i2) {
                this.height += ((LineItem)this.lines.elementAt((int)i2)).height;
            }
        }

        static {
            MultiME.classLoaded("lib.GraphicControls.TextList$ListItem");
        }

        public static void staticClinitSuperClone() {
            MultiME.classLoaded("lib.GraphicControls.TextList$ListItem");
        }

        public static void staticSuperCleaningRoutine() {
        }
    }

    private class LineItem {
        private Vector items = new Vector();
        public int width = 0;
        public int height = 0;

        public boolean addImage(Image image) {
            if (this.width + image.getWidth() < TextList.this.textListWidth - 5) {
                this.width += image.getWidth();
                this.items.addElement(new Item(image));
                if (this.height < image.getHeight()) {
                    this.height = image.getHeight();
                    for (int i2 = 0; i2 < this.items.size(); ++i2) {
                        if (((Item)this.items.elementAt((int)i2)).height >= this.height) continue;
                        ((Item)this.items.elementAt((int)i2)).height = this.height;
                    }
                } else {
                    ((Item)this.items.lastElement()).height = this.height;
                }
                return true;
            }
            return false;
        }

        public boolean addImage(int n) {
            if (this.width + TextList.this.images.getWidth() < TextList.this.textListWidth - 5) {
                this.width += TextList.this.images.getWidth();
                this.items.addElement(new Item(n));
                if (this.height < TextList.this.images.getHeight()) {
                    this.height = TextList.this.images.getHeight();
                    for (int i2 = 0; i2 < this.items.size(); ++i2) {
                        if (((Item)this.items.elementAt((int)i2)).height >= this.height) continue;
                        ((Item)this.items.elementAt((int)i2)).height = this.height;
                    }
                } else {
                    ((Item)this.items.lastElement()).height = this.height;
                }
                return true;
            }
            return false;
        }

        public boolean addText(String string, int n, int n2, int n3, int n4) {
            Font font = Font.getFont((int)0, (int)n3, (int)n4);
            if (this.width + font.stringWidth(string) < TextList.this.textListWidth - 5) {
                this.width += font.stringWidth(string);
                this.items.addElement(new Item(string, n, n2, n3, n4));
                if (this.height < font.getHeight()) {
                    this.height = font.getHeight();
                    for (int i2 = 0; i2 < this.items.size(); ++i2) {
                        if (((Item)this.items.elementAt((int)i2)).height >= this.height) continue;
                        ((Item)this.items.elementAt((int)i2)).height = this.height;
                    }
                } else {
                    ((Item)this.items.lastElement()).height = this.height;
                }
                font = null;
                return true;
            }
            font = null;
            return false;
        }

        public boolean addText(String string, SampleFont sampleFont) {
            if (this.width + sampleFont.stringWidth(string) < TextList.this.textListWidth - 5) {
                this.width += sampleFont.stringWidth(string);
                this.items.addElement(new Item(string, sampleFont));
                if (this.height < sampleFont.height) {
                    this.height = sampleFont.height;
                    for (int i2 = 0; i2 < this.items.size(); ++i2) {
                        if (((Item)this.items.elementAt((int)i2)).height >= this.height) continue;
                        ((Item)this.items.elementAt((int)i2)).height = this.height;
                    }
                } else {
                    ((Item)this.items.lastElement()).height = this.height;
                }
                return true;
            }
            return false;
        }

        public void paint(Graphics graphics, int n, int n2) {
            if (!this.items.isEmpty()) {
                for (int i2 = 0; i2 < this.items.size(); ++i2) {
                    ((Item)this.items.elementAt(i2)).paint(graphics, n, n2);
                    n += ((Item)this.items.elementAt((int)i2)).width;
                }
            }
        }

        static {
            MultiME.classLoaded("lib.GraphicControls.TextList$LineItem");
        }

        public static void staticClinitSuperClone() {
            MultiME.classLoaded("lib.GraphicControls.TextList$LineItem");
        }

        public static void staticSuperCleaningRoutine() {
        }
    }

    private class Item {
        public Image image = null;
        public String text = null;
        public int fontColor;
        public int bgColor;
        public int fontStyle;
        public int fontSize;
        public int width;
        public int height;
        public int imageIndex = -1;
        private SampleFont sampleFont = null;

        public Item(Image image) {
            this.image = image;
            this.width = image.getWidth();
            this.height = image.getHeight();
        }

        public Item(int n) {
            this.imageIndex = n;
            this.width = TextList.this.images.getWidth();
            this.height = TextList.this.images.getHeight();
        }

        public Item(String string, int n, int n2, int n3, int n4) {
            this.text = string;
            this.fontColor = n;
            this.bgColor = n2;
            this.fontStyle = n3;
            this.fontSize = n4;
            Font font = Font.getFont((int)0, (int)n3, (int)n4);
            this.width = font.stringWidth(string);
            this.height = font.getHeight();
            font = null;
        }

        public Item(String string, SampleFont sampleFont) {
            this.text = string;
            this.sampleFont = sampleFont;
            this.width = sampleFont.stringWidth(string);
            this.height = sampleFont.height;
        }

        public void paint(Graphics graphics, int n, int n2) {
            if (this.image != null) {
                graphics.drawImage(this.image, n, n2 + this.height - this.image.getHeight(), 20);
                n += this.image.getWidth();
            } else if (TextList.this.images != null && this.imageIndex > -1 && this.imageIndex < TextList.this.images.getSize()) {
                TextList.this.images.drawImage(graphics, this.imageIndex, n, n2 + this.height - TextList.this.images.getHeight());
                n += TextList.this.images.getWidth();
            } else if (this.text != null) {
                if (this.sampleFont != null) {
                    this.sampleFont.drawString(graphics, this.text, n, n2 + this.height - this.sampleFont.height);
                } else {
                    Font font = Font.getFont((int)0, (int)this.fontStyle, (int)this.fontSize);
                    graphics.setFont(font);
                    if (this.bgColor != 0xFFFFFF) {
                        graphics.setColor(this.bgColor);
                        graphics.fillRect(n, n2 + this.height - font.getHeight(), font.stringWidth(this.text), font.getHeight());
                    }
                    graphics.setColor(this.fontColor);
                    graphics.drawString(this.text, n, n2 + this.height - font.getHeight(), 20);
                    font = null;
                }
            }
        }

        static {
            MultiME.classLoaded("lib.GraphicControls.TextList$Item");
        }

        public static void staticClinitSuperClone() {
            MultiME.classLoaded("lib.GraphicControls.TextList$Item");
        }

        public static void staticSuperCleaningRoutine() {
        }
    }
}

