/*
 * Decompiled with CFR 0.152.
 */
package snirc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;
import multime.MultiME;
import snirc.UIHandler;
import snirc.Utils;

public class Database {
    private UIHandler uihandler;
    String profilename;
    String nick;
    String altnick;
    String host;
    int port;
    String channels;
    String username;
    String realname;
    String passwd;
    String nsid = "";
    String startupscript;
    String vers;
    String quitmsg;
    int[] idxarray;
    int profileidx = -1;
    boolean header = true;
    boolean raw = false;
    boolean skip_motd = false;
    boolean hide_ping = false;
    boolean rejoin = false;
    boolean hide_host = false;
    boolean timestamp = true;
    boolean usecolor = true;
    boolean usemirccol = true;
    boolean usepoll = false;
    boolean showinput = true;
    String encoding = "Windows-1251";
    boolean utf8detect = true;
    boolean utf8output = false;
    String hilight = "";
    int buflines = 50;
    boolean usehttp = false;
    String gwhost = "";
    int gwport = 8080;
    String gwpasswd = "";
    int selfpingsecs;
    int quietusers = 150;
    int fnt_face = 0;
    int fnt_style = 0;
    int fnt_size = 2;
    int polltime = 10;
    private static final String STORE_CONFIG = "snirccfg";
    private static final String STORE_PROFILE = "snircprof";
    private static final String STORE_LOG = "snirclog";

    public void load() {
        try {
            String string;
            byte[] byArray;
            RecordStore recordStore = MultiME.openRecordStore(STORE_CONFIG, true, "snirc.Database");
            int n = recordStore.getNumRecords();
            try {
                byArray = recordStore.getRecord(1);
                string = new DataInputStream(new ByteArrayInputStream(byArray)).readUTF();
            }
            catch (Exception exception) {
                string = "";
            }
            if (!string.equals("0.11")) {
                recordStore.closeRecordStore();
                try {
                    MultiME.deleteRecordStore(STORE_CONFIG, "snirc.Database");
                    MultiME.deleteRecordStore(STORE_PROFILE, "snirc.Database");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                recordStore = MultiME.openRecordStore(STORE_CONFIG, true, "snirc.Database");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeUTF("0.11");
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                recordStore.addRecord(byArray, 0, byArray.length);
                byArray = new byte[]{};
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray, 0, byArray.length);
                this.save_profile();
                this.save_advanced();
                this.save_http();
            } else {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(2)));
                this.profileidx = dataInputStream.readInt();
                dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(3)));
                this.raw = dataInputStream.readBoolean();
                this.skip_motd = dataInputStream.readBoolean();
                this.hide_ping = dataInputStream.readBoolean();
                this.rejoin = dataInputStream.readBoolean();
                this.hide_host = dataInputStream.readBoolean();
                this.header = dataInputStream.readBoolean();
                this.timestamp = dataInputStream.readBoolean();
                this.usecolor = dataInputStream.readBoolean();
                this.usemirccol = dataInputStream.readBoolean();
                this.usepoll = dataInputStream.readBoolean();
                this.showinput = dataInputStream.readBoolean();
                this.encoding = dataInputStream.readUTF();
                this.utf8detect = dataInputStream.readBoolean();
                this.utf8output = dataInputStream.readBoolean();
                this.buflines = dataInputStream.readInt();
                this.quietusers = dataInputStream.readInt();
                this.selfpingsecs = dataInputStream.readInt();
                this.hilight = dataInputStream.readUTF();
                dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(4)));
                this.usehttp = dataInputStream.readBoolean();
                this.gwhost = dataInputStream.readUTF();
                this.gwport = dataInputStream.readInt();
                this.gwpasswd = dataInputStream.readUTF();
                this.polltime = dataInputStream.readInt();
                dataInputStream.close();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.uihandler.getConsole().writeAction("!Warning! :" + exception.toString());
        }
        this.getProfiles();
        this.setProfile(this.profileidx);
    }

    public String[] getProfiles() {
        String[] stringArray = null;
        try {
            RecordStore recordStore = MultiME.openRecordStore(STORE_PROFILE, true, "snirc.Database");
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(new byte[4], 0, 4);
                this.idxarray = new int[0];
                stringArray = new String[]{};
            } else {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(1)));
                recordStore.closeRecordStore();
                int n = dataInputStream.readInt();
                stringArray = new String[n];
                this.idxarray = new int[n];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringArray[i2] = dataInputStream.readUTF();
                    this.idxarray[i2] = dataInputStream.readInt();
                }
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            this.uihandler.getConsole().writeAction("!Warning! :" + exception.toString());
        }
        return stringArray;
    }

    public void setProfile(int arg0) {
        if (arg0 < 0) {
            this.profilename = "default";
            this.nick = "";
            this.altnick = "";
            this.host = "irc.senet.ru";
            this.port = 6667;
            this.channels = "#senet";
            this.username = "snirc011";
            this.realname = "snirc user";
            this.passwd = "";
            this.nsid = "";
            this.selfpingsecs = 20;
            this.startupscript = "";
            this.vers = "snirc 0.11 by sniper (" + System.getProperty("microedition.platform") + ")";
            this.quitmsg = "snirc 0.11 by sniper";
        } else if (arg0 < this.idxarray.length) {
            try {
                int n = this.idxarray[arg0];
                RecordStore recordStore = MultiME.openRecordStore(STORE_PROFILE, false, "snirc.Database");
                if (n > 0) {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(n)));
                    this.profilename = dataInputStream.readUTF();
                    this.nick = dataInputStream.readUTF();
                    this.altnick = dataInputStream.readUTF();
                    this.host = dataInputStream.readUTF();
                    this.port = dataInputStream.readInt();
                    this.channels = dataInputStream.readUTF();
                    this.username = dataInputStream.readUTF();
                    this.realname = dataInputStream.readUTF();
                    this.passwd = dataInputStream.readUTF();
                    this.nsid = dataInputStream.readUTF();
                    this.startupscript = dataInputStream.readUTF();
                    this.vers = dataInputStream.readUTF();
                    this.quitmsg = dataInputStream.readUTF();
                }
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                this.uihandler.getConsole().writeAction("!Warning! :" + exception.toString());
            }
        }
    }

    public void addProfile() {
        this.editProfile(this.idxarray.length);
    }

    public void editProfile(int arg0) {
        try {
            RecordStore recordStore = MultiME.openRecordStore(STORE_PROFILE, false, "snirc.Database");
            this.editProfileName(recordStore, arg0, this.profilename);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this.profilename);
            dataOutputStream.writeUTF(this.nick);
            dataOutputStream.writeUTF(this.altnick);
            dataOutputStream.writeUTF(this.host);
            dataOutputStream.writeInt(this.port);
            dataOutputStream.writeUTF(this.channels);
            dataOutputStream.writeUTF(this.username);
            dataOutputStream.writeUTF(this.realname);
            dataOutputStream.writeUTF(this.passwd);
            dataOutputStream.writeUTF(this.nsid);
            dataOutputStream.writeUTF(this.startupscript);
            dataOutputStream.writeUTF(this.vers);
            dataOutputStream.writeUTF(this.quitmsg);
            dataOutputStream.writeInt(this.fnt_face);
            dataOutputStream.writeInt(this.fnt_style);
            dataOutputStream.writeInt(this.fnt_size);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            recordStore.setRecord(this.idxarray[arg0], byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.uihandler.getConsole().writeAction("!!!" + exception.toString());
        }
    }

    public void deleteProfile(int arg0) {
        try {
            RecordStore recordStore = MultiME.openRecordStore(STORE_PROFILE, false, "snirc.Database");
            recordStore.deleteRecord(this.idxarray[arg0]);
            this.editProfileName(recordStore, arg0, null);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.uihandler.getConsole().writeAction("!!!" + exception.toString());
        }
    }

    private void editProfileName(RecordStore recordStore, int n, String string) throws Exception {
        int n2;
        boolean bl = false;
        byte[] byArray = recordStore.getRecord(1);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n3 = dataInputStream.readInt();
        if (string == null && n >= 0 && n < n3) {
            this.idxarray = new int[--n3];
        } else if (n < 0 || n >= n3) {
            this.idxarray = new int[++n3];
            bl = true;
        } else if (string == null) {
            return;
        }
        dataOutputStream.writeInt(n3);
        for (n2 = 0; !(n2 >= n3 || n2 == n3 - 1 && bl); ++n2) {
            if (n2 == n) {
                if (string != null) {
                    dataInputStream.readUTF();
                    dataOutputStream.writeUTF(string);
                    this.idxarray[n2] = dataInputStream.readInt();
                    dataOutputStream.writeInt(this.idxarray[n2]);
                    continue;
                }
                dataInputStream.readUTF();
                dataInputStream.readInt();
            }
            dataOutputStream.writeUTF(dataInputStream.readUTF());
            this.idxarray[n2] = dataInputStream.readInt();
            dataOutputStream.writeInt(this.idxarray[n2]);
        }
        if (bl) {
            dataOutputStream.writeUTF(string);
            this.idxarray[n2] = recordStore.getNextRecordID();
            dataOutputStream.writeInt(this.idxarray[n2]);
            recordStore.addRecord(new byte[0], 0, 0);
        }
        byArray = byteArrayOutputStream.toByteArray();
        dataInputStream.close();
        dataOutputStream.close();
        recordStore.setRecord(1, byArray, 0, byArray.length);
        if (this.profileidx >= this.idxarray.length) {
            this.profileidx = this.idxarray.length - 1;
        }
    }

    public String[] getChannels() {
        return Utils.hasNoValue(this.channels) ? null : Utils.splitString(this.channels, ",");
    }

    public void save_profile() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.profileidx);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore recordStore = MultiME.openRecordStore(STORE_CONFIG, true, "snirc.Database");
            recordStore.setRecord(2, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.uihandler.getConsole().writeAction("!Warning!: " + exception.toString());
        }
    }

    public void save_advanced() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(this.raw);
            dataOutputStream.writeBoolean(this.skip_motd);
            dataOutputStream.writeBoolean(this.hide_ping);
            dataOutputStream.writeBoolean(this.rejoin);
            dataOutputStream.writeBoolean(this.hide_host);
            dataOutputStream.writeBoolean(this.header);
            dataOutputStream.writeBoolean(this.timestamp);
            dataOutputStream.writeBoolean(this.usecolor);
            dataOutputStream.writeBoolean(this.usemirccol);
            dataOutputStream.writeBoolean(this.usepoll);
            dataOutputStream.writeBoolean(this.showinput);
            dataOutputStream.writeUTF(this.encoding);
            dataOutputStream.writeBoolean(this.utf8detect);
            dataOutputStream.writeBoolean(this.utf8output);
            dataOutputStream.writeInt(this.buflines);
            dataOutputStream.writeInt(this.quietusers);
            dataOutputStream.writeInt(this.selfpingsecs);
            dataOutputStream.writeUTF(this.hilight);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore recordStore = MultiME.openRecordStore(STORE_CONFIG, true, "snirc.Database");
            recordStore.setRecord(3, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.uihandler.getConsole().writeAction("!!!" + exception.toString());
        }
    }

    public void save_http() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(this.usehttp);
            dataOutputStream.writeUTF(this.gwhost);
            dataOutputStream.writeInt(this.gwport);
            dataOutputStream.writeUTF(this.gwpasswd);
            dataOutputStream.writeInt(this.polltime);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore recordStore = MultiME.openRecordStore(STORE_CONFIG, true, "snirc.Database");
            recordStore.setRecord(4, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.uihandler.getConsole().writeAction("!!!" + exception.toString());
        }
    }

    static {
        MultiME.classLoaded("snirc.Database");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("snirc.Database");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

