/*
 * Decompiled with CFR 0.152.
 */
package snirc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStore;
import multime.FakeDisplay;
import multime.MultiME;
import snirc.Database;
import snirc.Window;
import snirc.snirc;

public class UIHandler {
    private FakeDisplay display;
    private Window console;
    private boolean header;
    private boolean timestamp;
    private boolean winlock;
    private boolean usecol;
    private boolean mirccol;
    private int quietusers;
    private int buflines;
    private Hashtable channels;
    private Hashtable privates;
    private Vector windows;
    private Vector favourites;
    private int currentwin;
    private String hilight;
    boolean chanlistexist;
    boolean rawlistexist;
    private Window chanlist;
    private Window rawlist;
    public String nick;
    public boolean keylock;

    public UIHandler(Database database, FakeDisplay fakeDisplay) {
        this.nick = database.nick;
        this.keylock = false;
        this.header = database.header;
        this.timestamp = database.timestamp;
        this.hilight = database.hilight;
        this.buflines = database.buflines;
        this.usecol = database.usecolor;
        this.mirccol = database.usemirccol;
        this.quietusers = database.quietusers;
        this.display = fakeDisplay;
        this.winlock = false;
        this.channels = new Hashtable();
        this.privates = new Hashtable();
        this.windows = new Vector();
        this.loadFavs();
        this.currentwin = 0;
        this.chanlistexist = false;
        this.console = new Window(this, "\u0421\u0442\u0430\u0442\u0443\u0441", 0, this.hilight, this.header, this.timestamp, this.usecol, this.mirccol, this.buflines, this.quietusers);
        this.addWindow(this.console);
    }

    public Window getrawlist() {
        if (!this.rawlistexist) {
            this.rawlist = new Window(this, "@RAW", 4, this.hilight, this.header, false, false, false, 300, 300);
            this.addWindow(this.rawlist);
            this.rawlistexist = true;
        }
        return this.rawlist;
    }

    public Window getChanlist() {
        if (!this.chanlistexist) {
            this.chanlist = new Window(this, "\u041a\u0430\u043d\u0430\u043b\u044b", 3, this.hilight, this.header, false, this.usecol, this.mirccol, 4000, 4000);
            this.addWindow(this.chanlist);
            this.chanlistexist = true;
        }
        return this.chanlist;
    }

    public Window getConsole() {
        return this.console;
    }

    public Window getChannel(String string) {
        Window window = (Window)this.channels.get((string = string.trim()).toUpperCase());
        if (window == null) {
            window = new Window(this, string, 1, this.hilight, this.header, this.timestamp, this.usecol, this.mirccol, this.buflines, this.quietusers);
            this.channels.put(string.toUpperCase(), window);
            this.addWindow(window);
        }
        return window;
    }

    public Window getPrivate(String string) {
        Window window = (Window)this.privates.get((string = string.trim()).toUpperCase());
        if (window == null) {
            window = new Window(this, string, 2, this.hilight, this.header, this.timestamp, this.usecol, this.mirccol, this.buflines, this.quietusers);
            this.privates.put(string.toUpperCase(), window);
            this.addWindow(window);
            if (this.keylock) {
                this.playAlarm(true);
            }
        }
        return window;
    }

    public void addWindow(Window window) {
        this.windows.addElement(window);
        this.displayWindow(-1);
    }

    public int[] getIndicators() {
        int[] nArray = new int[this.windows.size()];
        for (int i2 = 0; i2 < this.windows.size(); ++i2) {
            nArray[i2] = i2 == this.currentwin ? 4 : ((Window)this.windows.elementAt(i2)).getState();
        }
        return nArray;
    }

    public void globalHandleMsg(String string) {
        for (int i2 = 1; i2 < this.windows.size(); ++i2) {
            ((Window)this.windows.elementAt(i2)).handleMsg(string);
        }
    }

    public Window getCurrentWindow() {
        return (Window)this.windows.elementAt(this.currentwin);
    }

    public void setHeader(boolean bl) {
        this.header = bl;
        for (int i2 = 0; i2 < this.windows.size(); ++i2) {
            ((Window)this.windows.elementAt(i2)).setHeaderVisible(this.header);
        }
    }

    public void displayNextWindow() {
        this.displayWindow(this.currentwin + 1);
    }

    public void displayPreviousWindow() {
        this.displayWindow(this.currentwin - 1);
    }

    public void displayWindow(int n) {
        if (this.winlock) {
            return;
        }
        if (n >= this.windows.size()) {
            n = 0;
        } else if (n < 0) {
            n = this.windows.size() - 1;
        }
        if (n != this.currentwin) {
            ((Window)this.windows.elementAt(this.currentwin)).setState(0);
            this.setDisplay((Displayable)((Window)this.windows.elementAt(n)));
            this.currentwin = n;
        }
        System.gc();
    }

    public void deleteWindow(Window window) {
        if (window.getType() == 2) {
            this.privates.remove(window.getName().toUpperCase());
        }
        if (window.getType() == 1) {
            this.channels.remove(window.getName().toUpperCase());
        }
        if (this.windows.indexOf(window) <= this.currentwin) {
            --this.currentwin;
            this.setDisplay((Displayable)((Window)this.windows.elementAt(this.currentwin)));
            this.windows.removeElement(window);
        } else {
            this.windows.removeElement(window);
        }
    }

    public void setDisplay(Displayable displayable) {
        this.display.setCurrent(displayable);
    }

    public Hashtable getChannels() {
        return this.channels;
    }

    public Hashtable getPrivates() {
        return this.channels;
    }

    public void clearChanPriv() {
        this.console.enterExitMode();
        if (this.currentwin >= 0) {
            this.setDisplay((Displayable)this.console);
            this.currentwin = 0;
        }
        for (int i2 = this.windows.size() - 1; i2 >= 1; --i2) {
            ((Window)this.windows.elementAt(i2)).enterExitMode();
        }
        this.console.repaint();
    }

    public void cleanup() {
        this.windows.removeAllElements();
        this.channels.clear();
        this.privates.clear();
        this.currentwin = -1;
        System.gc();
        this.setDisplay((Displayable)snirc.mainform);
    }

    public void repaint() {
        if (this.windows.size() >= 0) {
            ((Window)this.windows.elementAt(this.currentwin)).repaint();
        }
    }

    public void setWinlock(boolean bl) {
        this.winlock = bl;
    }

    public boolean playAlarm(boolean bl) {
        if (bl) {
            return AlertType.ALARM.playSound(this.display);
        }
        return AlertType.INFO.playSound(this.display);
    }

    public void loadFavs() {
        try {
            RecordStore recordStore = MultiME.openRecordStore("snircfav", true, "snirc.UIHandler");
            this.favourites = new Vector();
            if (recordStore.getNumRecords() > 0) {
                byte[] byArray = recordStore.enumerateRecords(null, null, false).nextRecord();
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                int n = dataInputStream.readInt();
                for (int i2 = 0; i2 < n; ++i2) {
                    this.favourites.addElement(dataInputStream.readUTF());
                }
                dataInputStream.close();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveFavs() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.favourites.size());
            for (int i2 = 0; i2 < this.favourites.size(); ++i2) {
                dataOutputStream.writeUTF((String)this.favourites.elementAt(i2));
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            MultiME.deleteRecordStore("snircfav", "snirc.UIHandler");
            RecordStore recordStore = MultiME.openRecordStore("snircfav", true, "snirc.UIHandler");
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addFav(String string) {
        for (int i2 = 0; i2 < this.favourites.size(); ++i2) {
            if (string.compareTo((String)this.favourites.elementAt(i2)) >= 0) continue;
            this.favourites.insertElementAt(string, i2);
            return;
        }
        this.favourites.addElement(string);
    }

    public void removeFav(String string) {
        this.favourites.removeElement(string);
    }

    public Vector getFavs() {
        return this.favourites;
    }

    static {
        MultiME.classLoaded("snirc.UIHandler");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("snirc.UIHandler");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

