/*
 * Decompiled with CFR 0.152.
 */
package lib.Font;

import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import multime.MultiME;

public class CopyOfSampleFont {
    public static final int STYLE_BOLD = 0;
    public static final int STYLE_PLAIN = 1;
    public static final int STYLE_UNDERLINED = 2;
    private String[][] fontData;
    private InputStream in;
    public int size;
    public int style = 1;
    public int bgColor = 0xFFFFFF;
    public int fontColor = 0;
    public int height;
    public int[] width;

    public CopyOfSampleFont(String arg0) {
        this.in = MultiME.getResourceAsStream(this.getClass(), arg0, "lib.Font.CopyOfSampleFont");
        try {
            int n2;
            this.size = this.in.read() + 1;
            this.height = this.in.read();
            this.width = new int[this.size];
            for (n2 = 0; n2 < this.size; ++n2) {
                this.width[n2] = this.in.read();
            }
            this.fontData = new String[this.size][this.height];
            for (n2 = 0; n2 < this.size; ++n2) {
                for (int i2 = 0; i2 < this.height; ++i2) {
                    this.fontData[n2][i2] = "";
                    for (int i3 = 0; i3 < this.bytesPerSymbol(this.width[n2]); ++i3) {
                        String[] stringArray = this.fontData[n2];
                        int n3 = i2;
                        stringArray[n3] = stringArray[n3] + this.DecToBin(this.in.read());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String DecToBin(int n2) {
        String string = Integer.toBinaryString(n2);
        if (string.length() < 8) {
            string = "00000000".substring(string.length()) + string;
        }
        return string;
    }

    public void setBgColor(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.bgColor = n2 << 16 | n3 << 8 | n4;
    }

    public void setBgColor(int n2) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        this.bgColor = n2 & 0xFFFFFF;
    }

    public void setFontColor(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.fontColor = n2 << 16 | n3 << 8 | n4;
    }

    public void setFontColor(int n2) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        this.fontColor = n2 & 0xFFFFFF;
    }

    public void setStyle(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.style = n2;
    }

    private int getStyle() {
        return this.style;
    }

    private int getBgColor() {
        return this.bgColor;
    }

    private int getFontColor() {
        return this.fontColor;
    }

    public int substringWidth(String string, int n2) {
        int n3 = 0;
        for (int i2 = n2; i2 < string.length(); ++i2) {
            int n4 = string.charAt(i2);
            if (n4 >= 1040 && n4 <= 1103) {
                n4 -= 848;
            }
            n3 += this.width[n4];
        }
        return n3;
    }

    public int substringWidth(String string, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            int n5 = string.charAt(i2);
            if (n5 >= 1040 && n5 <= 1103) {
                n5 -= 848;
            }
            n4 += this.width[n5];
        }
        return n4;
    }

    public int stringWidth(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = string.charAt(i2);
            if (n3 >= 1040 && n3 <= 1103) {
                n3 -= 848;
            }
            n2 += this.width[n3];
        }
        return n2;
    }

    public void drawString(Graphics graphics, String string, int n2, int n3) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n4 = string.charAt(i2);
            if (n4 >= 1040 && n4 <= 1103) {
                n4 -= 848;
            }
            this.drawChar(graphics, n4, n2, n3);
            n2 += this.width[n4];
        }
    }

    public void drawChar(Graphics graphics, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = 0;
        if (this.style == 0 || this.style == 2) {
            n6 = 1;
        }
        if (this.bgColor != 0xFFFFFF) {
            graphics.setColor(this.bgColor);
            graphics.fillRect(n3, n4, this.width[n2] + n6, this.height);
        }
        graphics.setColor(this.fontColor);
        if (this.style == 2 || this.style == 2) {
            graphics.drawLine(n5, n4 + this.height, n5 + this.width[n2] + n6, n4 + this.height);
        }
        for (int i2 = 0; i2 < this.height; ++i2) {
            for (int i3 = 0; i3 < this.width[n2] && i3 < this.fontData[n2][i2].length(); ++i3) {
                if (this.fontData[n2][i2].charAt(i3) == '0') {
                    graphics.drawLine(n5, n4, n5 + n6, n4);
                }
                ++n5;
            }
            ++n4;
            n5 = n3;
        }
    }

    private int bytesPerSymbol(int n2) {
        if (n2 <= 8) {
            return 1;
        }
        if (n2 - n2 / 8 * 8 == 0) {
            return n2 / 8;
        }
        return n2 / 8 + 1;
    }

    static {
        MultiME.classLoaded("lib.Font.CopyOfSampleFont");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("lib.Font.CopyOfSampleFont");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

