/*
 * Decompiled with CFR 0.152.
 */
package snirc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import multime.MultiME;
import snirc.IrcConnection;
import snirc.Utils;

public class SocketIrc
extends IrcConnection {
    private DataInputStream in;
    private DataOutputStream out;
    private String encoding;
    private String outbuf;
    private boolean utf8detect;
    private boolean utf8output;
    private boolean pollmode;
    private boolean connected;
    private int bytein;
    private int byteout;

    public SocketIrc(boolean bl2, String string) {
        this.encoding = string;
        this.utf8detect = false;
        this.utf8output = false;
        this.bytein = 0;
        this.byteout = 0;
        this.pollmode = bl2;
        this.connected = false;
    }

    public String connect(String string, int n2, String string2) {
        String string3 = null;
        try {
            StreamConnection streamConnection = (StreamConnection)Connector.open((String)("socket://" + string + ":" + n2), (int)3);
            this.in = streamConnection.openDataInputStream();
            this.out = streamConnection.openDataOutputStream();
            this.outbuf = null;
            this.connected = true;
            string3 = this.writeData(string2);
        }
        catch (Exception exception) {
            string3 = "Error trying to connect to IRC server, aborting... ";
            string3 = string3 + "Exception: " + exception.toString();
            return string3;
        }
        return null;
    }

    public void disconnect() {
        if (this.connected) {
            try {
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
                if (this.in != null) {
                    this.in.close();
                }
                this.connected = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String updateConnection() {
        if (this.outbuf != null && this.connected) {
            try {
                byte[] byArray = this.stringToByteArray(this.outbuf, this.encoding, this.utf8output);
                this.out.write(byArray);
                this.out.flush();
                this.byteout += byArray.length;
                this.outbuf = null;
            }
            catch (Exception exception) {
                String string = "Error reading/writing to IRC socket, aborting... ";
                string = string + "Exception: " + exception.toString();
                this.connected = false;
                return string;
            }
        }
        return null;
    }

    public String readLine() {
        String string = null;
        try {
            byte[] byArray = Utils.readLine(this.in);
            if (byArray == null) {
                return null;
            }
            this.bytein += byArray.length + 40;
            string = this.byteArrayToString(byArray, this.encoding, this.utf8detect);
        }
        catch (Exception exception) {
            this.connected = false;
        }
        return string;
    }

    public String writeData(String string) {
        this.outbuf = this.outbuf == null ? string : this.outbuf + string;
        return this.updateConnection();
    }

    public boolean hasDataInBuffer() {
        if (this.pollmode) {
            try {
                return this.in.available() > 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.connected;
    }

    public void setUnicodeMode(boolean bl2, boolean bl3) {
        this.utf8detect = bl2;
        this.utf8output = bl3;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getBytesIn() {
        return this.bytein;
    }

    public int getBytesOut() {
        return this.byteout;
    }

    static {
        MultiME.classLoaded("snirc.SocketIrc");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("snirc.SocketIrc");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

