/*
 * Decompiled with CFR 0.152.
 */
package lib.GraphicControls;

import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lib.Font.SampleFont;
import lib.GraphicControls.TextList;
import lib.Utils.Utils;
import multime.FakeDisplay;
import multime.MultiME;
import multime.misc.PublicKeys;

public class MessageBox
extends Canvas
implements PublicKeys {
    public static final int TYPE_ALARM = 0;
    public static final int TYPE_INFO = 1;
    public static final int TYPE_CONFIRMATION = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_WARNING = 4;
    private Image ti;
    private Graphics tg;
    public TextList textlist;
    private int width;
    private int height;
    private int left;
    private int top;
    private int fontSize;
    private int type;
    private int heightdiff;
    private int fontHeight;
    private String title = null;
    private String text = null;
    private Command cmd_left;
    private Command cmd_center;
    private Command cmd_right;
    private CommandListener cl;
    private FakeDisplay display;
    private Displayable displayable;
    private Font font = null;
    private SampleFont sampleFont = null;
    private runningTitle rt;

    public MessageBox(FakeDisplay fakeDisplay, CommandListener commandListener, Command command, Command command2, Command command3, String string, String string2, int n2, int n3, int n4) {
        this.display = fakeDisplay;
        this.cl = commandListener;
        this.cmd_left = command;
        this.cmd_center = command2;
        this.cmd_right = command3;
        this.title = string;
        this.text = string2;
        this.fontSize = n3;
        this.heightdiff = 0;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.height > 120) {
            this.left = 4;
            this.top = 16;
        } else {
            this.left = 0;
            this.top = 0;
        }
        this.width -= 2 * this.left;
        this.height -= 2 * this.top;
        if (this.height > this.width) {
            this.top = this.height - this.width;
            this.height = this.width - 10;
        }
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.fontHeight = this.font.getHeight();
        this.textlist = new TextList(this.width - 10, this.height - 2 * this.fontHeight - 14, n3, 0, null);
        this.textlist.addText(string2);
        if (this.font.stringWidth(string) > this.width - 12) {
            this.rt = new runningTitle();
            this.rt.setPriority(1);
            this.rt.start();
        }
    }

    public MessageBox(FakeDisplay fakeDisplay, Displayable displayable, String string, String string2, int n2, int n3, int n4) {
        this.display = fakeDisplay;
        this.displayable = displayable;
        this.title = string;
        this.text = string2;
        this.fontSize = n3;
        this.heightdiff = 0;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.left = 4;
        this.top = 16;
        this.width -= 2 * this.left;
        this.height -= 2 * this.top;
        if (this.height > this.width) {
            this.top = this.height - this.width;
            this.height = this.width - 10;
        }
        if (n3 < 0) {
            this.sampleFont = new SampleFont("/fonts/font.bin");
            this.fontHeight = this.sampleFont.height;
            if (this.sampleFont.stringWidth(string) > this.width - 12) {
                this.rt = new runningTitle();
                this.rt.setPriority(1);
                this.rt.start();
            }
        } else {
            this.font = Font.getFont((int)0, (int)0, (int)n3);
            this.fontHeight = this.font.getHeight();
            if (this.font.stringWidth(string) > this.width - 12) {
                this.rt = new runningTitle();
                this.rt.setPriority(1);
                this.rt.start();
            }
        }
        this.textlist = new TextList(this.width - 10, this.height - 2 * this.fontHeight - 14, n3, 0, null);
        this.textlist.addText(string2);
    }

    public void playSound() {
        if (this.type == 0) {
            AlertType.ALARM.playSound(this.display);
        } else if (this.type == 1) {
            AlertType.INFO.playSound(this.display);
        } else if (this.type == 2) {
            AlertType.CONFIRMATION.playSound(this.display);
        } else if (this.type == 3) {
            AlertType.ERROR.playSound(this.display);
        } else if (this.type == 4) {
            AlertType.WARNING.playSound(this.display);
        }
    }

    public void setDisplayable(Displayable displayable) {
        this.displayable = displayable;
    }

    public void show() {
        this.display.setCurrent((Displayable)this);
        this.playSound();
    }

    public void setText(String string) {
        this.text = string;
        this.textlist.clear();
        this.textlist.addText(string);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(50, 50, 50);
        graphics.drawRect(this.left, this.top, this.width - 1, this.height - 1);
        graphics.setColor(191, 193, 208);
        graphics.drawRect(this.left + 1, this.top + 1, this.width - 3, this.height - 3);
        graphics.setColor(241, 241, 241);
        graphics.drawRect(this.left + 1, this.top + 1, this.width - 4, this.height - 4);
        graphics.setColor(219, 222, 232);
        graphics.drawRect(this.left + 2, this.top + 2, this.width - 5, this.height - 5);
        graphics.setColor(255, 255, 255);
        graphics.drawRect(this.left + 2, this.top + 2, this.width - 6, this.height - 6);
        graphics.setColor(212, 208, 200);
        graphics.drawRect(this.left + 3, this.top + 3, this.width - 7, this.height - 7);
        graphics.setColor(241, 243, 248);
        graphics.fillRect(this.left + 4, this.top + 4, this.width - 8, this.height - 8);
        if (this.sampleFont != null) {
            Utils.drawFramedText(graphics, this.sampleFont, this.title, this.left + this.width / 2 - this.sampleFont.stringWidth(this.title) / 2, this.top + 5, 0xFFFFFF, 0);
        } else {
            Utils.drawFramedText(graphics, this.font, this.title, this.left + this.width / 2 - this.font.stringWidth(this.title) / 2, this.top + 5, 0xFFFFFF, 0);
        }
        if (this.cmd_left != null) {
            if (this.sampleFont != null) {
                Utils.drawFramedText(graphics, this.sampleFont, "*", this.left + 10, this.top + this.height - this.fontHeight - 6, 65280, 0);
            } else {
                Utils.drawFramedText(graphics, this.font, "*", this.left + 10, this.top + this.height - this.fontHeight - 6, 65280, 0);
            }
        }
        if (this.cmd_center != null) {
            if (this.sampleFont != null) {
                Utils.drawFramedText(graphics, this.sampleFont, "+", this.left + this.width / 2 - 2, this.top + this.height - this.fontHeight - 6, 255, 0);
            } else {
                Utils.drawFramedText(graphics, this.font, "+", this.left + this.width / 2 - 2, this.top + this.height - this.fontHeight - 6, 255, 0);
            }
        }
        if (this.cmd_right != null || this.displayable != null) {
            if (this.sampleFont != null) {
                Utils.drawFramedText(graphics, this.sampleFont, "#", this.left + this.width - 15, this.top + this.height - this.fontHeight - 6, 0xFF0000, 0);
            } else {
                Utils.drawFramedText(graphics, this.font, "#", this.left + this.width - 15, this.top + this.height - this.fontHeight - 6, 0xFF0000, 0);
            }
        }
        this.textlist.paint(graphics, this.left + 5, this.top + this.fontHeight + 7);
    }

    public void keyPressed(int keyCode) {
        MultiME.globalKeyPressed(this, keyCode);
    }

    static {
        MultiME.classLoaded("lib.GraphicControls.MessageBox");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("lib.GraphicControls.MessageBox");
    }

    public void __keyPressed(int arg0) {
        if (this.getGameAction(arg0) == 1 || arg0 == 50 || arg0 == -13) {
            this.textlist.up();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (this.getGameAction(arg0) == 6 || arg0 == 56 || arg0 == -14) {
            this.textlist.down();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (arg0 == 57) {
            this.textlist.pageDown();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (arg0 == 51) {
            this.textlist.pageUp();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (arg0 == 49) {
            this.textlist.home();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        } else if (arg0 == 55) {
            this.textlist.end();
            this.repaint(this.left + 5, this.top + this.fontHeight + 7, this.width - 8, this.height - 2 * this.fontHeight - 12);
        }
        if ((this.getGameAction(arg0) == 8 || arg0 == 48) && this.cmd_center != null) {
            this.cl.commandAction(this.cmd_center, null);
        }
        if ((arg0 == 42 || arg0 == -6 || arg0 == -1 || arg0 == -11) && this.cmd_left != null) {
            this.cl.commandAction(this.cmd_left, null);
        }
        if (arg0 == -4 || arg0 == -7 || arg0 == 35 || arg0 == -12) {
            if (this.cmd_right != null) {
                this.cl.commandAction(this.cmd_right, null);
            } else if (this.displayable != null) {
                this.display.setCurrent(this.displayable);
            }
        }
    }

    public void keyRepeated(int keyCode) {
        MultiME.globalKeyRepeated(this, keyCode);
    }

    public void __keyRepeated(int k2) {
    }

    public void keyReleased(int keyCode) {
        MultiME.globalKeyReleased(this, keyCode);
    }

    public void __keyReleased(int k2) {
    }

    public static void staticSuperCleaningRoutine() {
    }

    private class runningTitle
    extends Thread {
        public boolean run = true;
        private String temp;
        private int size;

        public runningTitle() {
            this.temp = MessageBox.this.title;
            this.size = (MessageBox.this.width - 20) / MessageBox.this.font.charWidth('D');
            MessageBox.this.title = "";
        }

        public void run() {
            while (this.run) {
                MessageBox.this.title = this.temp.substring(0, this.size);
                this.temp = this.temp.substring(1) + this.temp.charAt(1);
                MessageBox.this.repaint(MessageBox.this.left + 10, MessageBox.this.top + 5, MessageBox.this.width - 25, MessageBox.this.fontHeight + 5);
                try {
                    runningTitle.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        static {
            MultiME.classLoaded("lib.GraphicControls.MessageBox$runningTitle");
        }

        public static void staticClinitSuperClone() {
            MultiME.classLoaded("lib.GraphicControls.MessageBox$runningTitle");
        }

        public static void staticSuperCleaningRoutine() {
        }
    }
}

