/*
 * Decompiled with CFR 0.152.
 */
package snirc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.HttpConnection;
import multime.MultiME;
import multime.io.FakeConnector;
import snirc.IrcConnection;
import snirc.Utils;

public class HttpIrc
extends IrcConnection {
    private Vector inqueue;
    private String encoding;
    private String identifier;
    private String gwhost;
    private String gwpasswd;
    private String outbuf;
    private boolean utf8detect;
    private boolean utf8output;
    private int gwport;
    private boolean connected;
    private boolean closeconn;
    private int bytein;
    private int byteout;

    public HttpIrc(String string, int n2, String string2, String string3) {
        this.gwhost = string;
        this.gwport = n2;
        this.gwpasswd = string2;
        this.encoding = string3;
        this.inqueue = new Vector();
        this.outbuf = null;
        this.utf8detect = false;
        this.utf8output = false;
        this.bytein = 0;
        this.byteout = 0;
        this.closeconn = false;
        this.connected = false;
        this.identifier = "";
    }

    public String connect(String arg0, int arg1, String arg2) {
        int n2;
        HttpConnection httpConnection = null;
        String string = "";
        String string2 = "http://" + this.gwhost + ":" + this.gwport + "/connect?host=" + Utils.URLEncode(arg0.getBytes()) + "&port=" + Utils.URLEncode(("" + arg1).getBytes()) + "&passwd=" + Utils.URLEncode(this.gwpasswd.getBytes()) + "&data=" + Utils.URLEncode(this.stringToByteArray(arg2, this.encoding, this.utf8output));
        try {
            httpConnection = (HttpConnection)FakeConnector.open(string2);
            httpConnection.setRequestMethod("GET");
            n2 = httpConnection.getResponseCode();
            this.identifier = httpConnection.getHeaderField("X-Identifier");
            if (httpConnection != null) {
                httpConnection.close();
            }
        }
        catch (Exception exception) {
            string = string + "Error trying to connect to HTTP proxy server, aborting... ";
            string = string + "\u041f\u0440\u0438\u0447\u0438\u043d\u0430: " + exception.toString();
            return string;
        }
        if (n2 != 200) {
            string = string + "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 IRC-\u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u043f\u043e \u043f\u0440\u0438\u0447\u0438\u043d\u0435: ";
            switch (n2) {
                case 403: {
                    string = string + "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c";
                    break;
                }
                case 502: {
                    string = string + "\u041f\u043b\u043e\u0445\u043e\u0439 \u0448\u043b\u044e\u0437";
                    break;
                }
                case 404: {
                    string = string + "\u041d\u0435\u0442 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 IRC";
                    break;
                }
                default: {
                    string = string + "\u041a\u043e\u0434 \u043e\u0442\u0432\u0435\u0442\u0430 HTTP: " + n2;
                }
            }
            return string;
        }
        this.connected = true;
        return null;
    }

    public void disconnect() {
        if (this.connected) {
            this.closeconn = true;
        }
    }

    public String readLine() {
        String string;
        if (this.inqueue.size() > 0) {
            string = (String)this.inqueue.firstElement();
            this.inqueue.removeElementAt(0);
        } else {
            string = "";
        }
        return string;
    }

    public String updateConnection() {
        String string = "http://" + this.gwhost + ":" + this.gwport + "/" + this.identifier;
        if (this.outbuf != null) {
            string = string + "?data=" + Utils.URLEncode(this.stringToByteArray(this.outbuf, this.encoding, this.utf8output));
            this.byteout += string.getBytes().length;
            this.outbuf = null;
        }
        String string2 = this.handleRequest(string, true);
        if (this.closeconn) {
            this.connected = false;
        }
        return string2;
    }

    public String writeData(String string) {
        this.outbuf = this.outbuf == null ? string : this.outbuf + string;
        return null;
    }

    private String handleRequest(String arg0, boolean arg1) {
        int n2;
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        String string = "";
        try {
            httpConnection = (HttpConnection)FakeConnector.open(arg0);
            if (arg1) {
                httpConnection.setRequestMethod("GET");
            } else {
                httpConnection.setRequestMethod("HEAD");
            }
            n2 = httpConnection.getResponseCode();
            if (arg1) {
                inputStream = httpConnection.openInputStream();
                int n3 = (int)httpConnection.getLength();
                if (n3 > 0) {
                    byte[] byArray = new byte[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        byArray[i2] = (byte)inputStream.read();
                    }
                    this.bytein += byArray.length;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    while (byteArrayInputStream.available() > 0) {
                        byte[] byArray2 = Utils.readLine(byteArrayInputStream);
                        if (byArray2 == null) continue;
                        String string2 = this.byteArrayToString(byArray2, this.encoding, this.utf8detect);
                        this.inqueue.addElement(string2);
                    }
                }
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
        }
        catch (Exception exception) {
            string = string + "Request failed, continuing...";
            return string;
        }
        if (n2 != 200) {
            if (n2 != 404) {
                string = string + "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 IRC-\u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c, \u043e\u0442\u043c\u0435\u043d\u0430... ";
                string = string + "Error: \u041a\u043e\u0434 \u043e\u0442\u0432\u0435\u0442\u0430 HTTP: " + n2;
            }
            this.connected = false;
            return string;
        }
        return null;
    }

    public boolean hasDataInBuffer() {
        return this.inqueue.size() != 0;
    }

    public void setUnicodeMode(boolean bl2, boolean bl3) {
        this.utf8detect = bl2;
        this.utf8output = bl3;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getBytesIn() {
        return this.bytein;
    }

    public int getBytesOut() {
        return this.byteout;
    }

    static {
        MultiME.classLoaded("snirc.HttpIrc");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("snirc.HttpIrc");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

