/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.L2CAPConnection;

public class Misc {
    public static byte[] receiveArray(L2CAPConnection conn) throws IOException {
        Vector<byte[]> arrays = new Vector<byte[]>();
        byte[] inArray = new byte[conn.getReceiveMTU()];
        int ticker = conn.receive(inArray);
        arrays.addElement(inArray);
        ByteArrayInputStream biStream = new ByteArrayInputStream(inArray);
        DataInputStream iStream = new DataInputStream(biStream);
        iStream.readInt();
        int overallLength = iStream.readInt() + 12;
        iStream.close();
        biStream.close();
        while (ticker < overallLength) {
            int MTU = conn.getReceiveMTU();
            inArray = new byte[MTU];
            int receivedBytes = conn.receive(inArray);
            ticker += receivedBytes;
            if (receivedBytes != MTU) {
                byte[] formArray = inArray;
                inArray = new byte[receivedBytes];
                System.arraycopy(formArray, 0, inArray, 0, receivedBytes);
            }
            arrays.addElement(inArray);
        }
        inArray = new byte[overallLength];
        ticker = 0;
        int i = 0;
        while (i < arrays.size()) {
            byte[] vectorArray = (byte[])arrays.elementAt(i);
            System.arraycopy(vectorArray, 0, inArray, ticker, vectorArray.length);
            ticker += vectorArray.length;
            ++i;
        }
        return inArray;
    }

    public static void sendArray(byte[] array, L2CAPConnection conn) throws IOException {
        int MTU = conn.getTransmitMTU();
        int ticker = 0;
        while (ticker < array.length) {
            int size = array.length - ticker > MTU ? MTU : array.length - ticker;
            byte[] tArray = new byte[size];
            System.arraycopy(array, ticker, tArray, 0, size);
            conn.send(tArray);
            ticker += MTU;
        }
    }
}

